/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.component.context.ComponentContext;
import org.springframework.shell.component.support.AbstractTextComponent;
import org.springframework.util.StringUtils;

public class PathInput
extends AbstractTextComponent<Path, PathInputContext> {
    private static final Logger log = LoggerFactory.getLogger(PathInput.class);
    private PathInputContext currentContext;
    private Function<String, Path> pathProvider = path -> Paths.get(path, new String[0]);

    public PathInput(Terminal terminal) {
        this(terminal, null);
    }

    public PathInput(Terminal terminal, String name) {
        this(terminal, name, (Function<PathInputContext, List<AttributedString>>)null);
    }

    public PathInput(Terminal terminal, String name, Function<PathInputContext, List<AttributedString>> renderer) {
        super(terminal, name, null);
        this.setRenderer(renderer != null ? renderer : new DefaultRenderer());
        this.setTemplateLocation("classpath:org/springframework/shell/component/path-input-default.stg");
    }

    @Override
    public PathInputContext getThisContext(ComponentContext<?> context) {
        if (context != null && this.currentContext == context) {
            return this.currentContext;
        }
        this.currentContext = PathInputContext.empty();
        this.currentContext.setName(this.getName());
        if (context != null) {
            context.stream().forEach(e -> this.currentContext.put(e.getKey(), e.getValue()));
        }
        return this.currentContext;
    }

    @Override
    protected boolean read(BindingReader bindingReader, KeyMap<String> keyMap, PathInputContext context) {
        String operation = (String)bindingReader.readBinding(keyMap);
        log.debug("Binding read result {}", (Object)operation);
        if (operation == null) {
            return true;
        }
        switch (operation) {
            case "CHAR": {
                String lastBinding = bindingReader.getLastBinding();
                Object input = context.getInput();
                input = input == null ? lastBinding : (String)input + lastBinding;
                context.setInput((String)input);
                this.checkPath((String)input, context);
                break;
            }
            case "BACKSPACE": {
                String input = context.getInput();
                if (StringUtils.hasLength((String)input)) {
                    input = input.length() > 1 ? input.substring(0, input.length() - 1) : null;
                }
                context.setInput(input);
                this.checkPath(input, context);
                break;
            }
            case "EXIT": {
                if (StringUtils.hasText((String)context.getInput())) {
                    context.setResultValue(Paths.get(context.getInput(), new String[0]));
                }
                return true;
            }
        }
        return false;
    }

    public void setPathProvider(Function<String, Path> pathProvider) {
        this.pathProvider = pathProvider;
    }

    protected Path resolvePath(String path) {
        return this.pathProvider.apply(path);
    }

    private void checkPath(String path, PathInputContext context) {
        if (!StringUtils.hasText((String)path)) {
            context.setMessage(null);
            return;
        }
        Path p = this.resolvePath(path);
        boolean isDirectory = Files.isDirectory(p, new LinkOption[0]);
        if (isDirectory) {
            context.setMessage("Directory exists", AbstractTextComponent.TextComponentContext.MessageLevel.ERROR);
        } else {
            context.setMessage("Path ok", AbstractTextComponent.TextComponentContext.MessageLevel.INFO);
        }
    }

    private class DefaultRenderer
    implements Function<PathInputContext, List<AttributedString>> {
        private DefaultRenderer() {
        }

        @Override
        public List<AttributedString> apply(PathInputContext context) {
            return PathInput.this.renderTemplateResource(context.toTemplateModel());
        }
    }

    public static interface PathInputContext
    extends AbstractTextComponent.TextComponentContext<Path, PathInputContext> {
        public static PathInputContext empty() {
            return new DefaultPathInputContext();
        }
    }

    private static class DefaultPathInputContext
    extends AbstractTextComponent.BaseTextComponentContext<Path, PathInputContext>
    implements PathInputContext {
        private DefaultPathInputContext() {
        }

        @Override
        public Map<String, Object> toTemplateModel() {
            Map<String, Object> attributes = super.toTemplateModel();
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("model", attributes);
            return model;
        }
    }
}

