/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.InfoCmp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.component.context.ComponentContext;
import org.springframework.shell.component.support.AbstractTextComponent;
import org.springframework.shell.component.support.Nameable;
import org.springframework.shell.component.support.SelectorList;
import org.springframework.shell.style.PartsText;
import org.springframework.shell.support.search.SearchMatch;
import org.springframework.shell.support.search.SearchMatchResult;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PathSearch
extends AbstractTextComponent<Path, PathSearchContext> {
    private static final Logger log = LoggerFactory.getLogger(PathSearch.class);
    private static final String DEFAULT_TEMPLATE_LOCATION = "classpath:org/springframework/shell/component/path-search-default.stg";
    private final PathSearchConfig config;
    private PathSearchContext currentContext;
    private Function<String, Path> pathProvider = path -> Paths.get(path, new String[0]);
    private final SelectorList<PathSearchContext.PathViewItem> selectorList;

    public PathSearch(Terminal terminal) {
        this(terminal, null);
    }

    public PathSearch(Terminal terminal, String name) {
        this(terminal, name, (PathSearchConfig)null);
    }

    public PathSearch(Terminal terminal, String name, PathSearchConfig config) {
        this(terminal, name, config, null);
    }

    public PathSearch(Terminal terminal, String name, PathSearchConfig config, Function<PathSearchContext, List<AttributedString>> renderer) {
        super(terminal, name, null);
        this.setRenderer(renderer != null ? renderer : new DefaultRenderer());
        this.setTemplateLocation(DEFAULT_TEMPLATE_LOCATION);
        this.config = config != null ? config : new PathSearchConfig();
        this.selectorList = SelectorList.of(this.config.getMaxPathsShow());
    }

    @Override
    protected void bindKeyMap(KeyMap<String> keyMap) {
        super.bindKeyMap(keyMap);
        keyMap.bind((Object)"DOWN", new CharSequence[]{KeyMap.ctrl((char)'E'), KeyMap.key((Terminal)this.getTerminal(), (InfoCmp.Capability)InfoCmp.Capability.key_down)});
        keyMap.bind((Object)"UP", new CharSequence[]{KeyMap.ctrl((char)'Y'), KeyMap.key((Terminal)this.getTerminal(), (InfoCmp.Capability)InfoCmp.Capability.key_up)});
    }

    @Override
    public PathSearchContext getThisContext(ComponentContext<?> context) {
        if (context != null && this.currentContext == context) {
            return this.currentContext;
        }
        this.currentContext = PathSearchContext.empty();
        this.currentContext.setName(this.getName());
        this.currentContext.setTerminalWidth(this.getTerminal().getWidth());
        this.currentContext.setPathSearchConfig(this.config);
        this.currentContext.setMessage("Type '<path> <pattern>' to search", AbstractTextComponent.TextComponentContext.MessageLevel.INFO);
        if (context != null) {
            context.stream().forEach(e -> this.currentContext.put(e.getKey(), e.getValue()));
        }
        return this.currentContext;
    }

    @Override
    protected boolean read(BindingReader bindingReader, KeyMap<String> keyMap, PathSearchContext context) {
        String operation = (String)bindingReader.readBinding(keyMap);
        log.debug("Binding read result {}", (Object)operation);
        if (operation == null) {
            return true;
        }
        switch (operation) {
            case "CHAR": {
                String lastBinding = bindingReader.getLastBinding();
                Object input = context.getInput();
                input = input == null ? lastBinding : (String)input + lastBinding;
                context.setInput((String)input);
                this.inputUpdated(context, (String)input);
                break;
            }
            case "BACKSPACE": {
                String input = context.getInput();
                if (StringUtils.hasLength((String)input)) {
                    input = input.length() > 1 ? input.substring(0, input.length() - 1) : null;
                }
                context.setInput(input);
                this.inputUpdated(context, input);
                break;
            }
            case "EXIT": {
                PathSearchContext.PathViewItem selected = this.selectorList.getSelected();
                if (selected != null) {
                    context.setResultValue(selected.getPath());
                }
                return true;
            }
            case "UP": {
                this.selectorList.scrollUp();
                this.selectorListUpdated(context);
                break;
            }
            case "DOWN": {
                this.selectorList.scrollDown();
                this.selectorListUpdated(context);
                break;
            }
        }
        return false;
    }

    public void setPathProvider(Function<String, Path> pathProvider) {
        this.pathProvider = pathProvider;
    }

    protected Path resolvePath(String path) {
        return this.pathProvider.apply(path);
    }

    private void inputUpdated(PathSearchContext context, String input) {
        context.setMessage("Type '<path> <pattern>' to search", AbstractTextComponent.TextComponentContext.MessageLevel.INFO);
        this.updateSelectorList(input, context);
        this.selectorListUpdated(context);
    }

    private void selectorListUpdated(PathSearchContext context) {
        List<PathSearchContext.PathViewItem> pathViews = this.selectorList.getProjection().stream().map(i -> new PathSearchContext.PathViewItem(((PathSearchContext.PathViewItem)i.getItem()).getPath(), ((PathSearchContext.PathViewItem)i.getItem()).getPartsText(), i.isSelected())).collect(Collectors.toList());
        context.setPathViewItems(pathViews);
    }

    private void updateSelectorList(String path, PathSearchContext context) {
        if (path == null) {
            this.selectorList.reset(Collections.emptyList());
            return;
        }
        PathScannerResult result = this.config.pathScanner.get().apply(path, context);
        List items = result.getScoredPaths().stream().filter(scoredPath -> {
            if (result.hasFilter()) {
                return scoredPath.result.getScore() > 0;
            }
            return true;
        }).map(scoredPath -> {
            int[] positions = scoredPath.getResult().getPositions();
            String text = scoredPath.getPath().toString();
            if (!StringUtils.hasText((String)text)) {
                text = ".";
            }
            PartsText partsText = PathSearchContext.ofPositions(text, positions);
            PathSearchContext.PathViewItem item = new PathSearchContext.PathViewItem(scoredPath.getPath(), partsText, false);
            return item;
        }).collect(Collectors.toList());
        long total = result.getDirCount() + result.getFileCount();
        if (total > -1L) {
            int found = items.size();
            String message = String.format(", %s/%s", found, total);
            context.setMessage("Type '<path> <pattern>' to search" + message, AbstractTextComponent.TextComponentContext.MessageLevel.INFO);
        }
        this.selectorList.reset(items);
    }

    public static class PathSearchConfig {
        private int maxPathsShow = 5;
        private int maxPathsSearch = 20;
        private boolean searchForward = true;
        private boolean searchCaseSensitive = false;
        private boolean searchNormalize = false;
        private Supplier<BiFunction<String, PathSearchContext, PathScannerResult>> pathScanner = () -> DefaultPathScanner.of();

        public int getMaxPathsShow() {
            return this.maxPathsShow;
        }

        public void setMaxPathsShow(int maxPathsShow) {
            Assert.state((maxPathsShow > 0 || maxPathsShow < 33 ? 1 : 0) != 0, (String)"maxPathsShow has to be between 1 and 32");
            this.maxPathsShow = maxPathsShow;
        }

        public int getMaxPathsSearch() {
            return this.maxPathsSearch;
        }

        public void setMaxPathsSearch(int maxPathsSearch) {
            Assert.state((maxPathsSearch > 0 ? 1 : 0) != 0, (String)"maxPathsSearch has to be more than 0");
            this.maxPathsSearch = maxPathsSearch;
        }

        public void setPathScanner(Supplier<BiFunction<String, PathSearchContext, PathScannerResult>> pathScanner) {
            Assert.notNull(pathScanner, (String)"pathScanner supplier cannot be null");
            this.pathScanner = pathScanner;
        }

        public boolean isSearchForward() {
            return this.searchForward;
        }

        public void setSearchForward(boolean searchForward) {
            this.searchForward = searchForward;
        }

        public boolean isSearchCaseSensitive() {
            return this.searchCaseSensitive;
        }

        public void setSearchCaseSensitive(boolean searchCaseSensitive) {
            this.searchCaseSensitive = searchCaseSensitive;
        }

        public boolean isSearchNormalize() {
            return this.searchNormalize;
        }

        public void setSearchNormalize(boolean searchNormalize) {
            this.searchNormalize = searchNormalize;
        }
    }

    private class DefaultRenderer
    implements Function<PathSearchContext, List<AttributedString>> {
        private DefaultRenderer() {
        }

        @Override
        public List<AttributedString> apply(PathSearchContext context) {
            return PathSearch.this.renderTemplateResource(context.toTemplateModel());
        }
    }

    public static interface PathSearchContext
    extends AbstractTextComponent.TextComponentContext<Path, PathSearchContext> {
        public List<PathViewItem> getPathViewItems();

        public void setPathViewItems(List<PathViewItem> var1);

        public PathSearchConfig getPathSearchConfig();

        public void setPathSearchConfig(PathSearchConfig var1);

        public static PathSearchContext empty() {
            return new DefaultPathSearchContext();
        }

        public static PartsText ofPositions(String text, int[] positions) {
            ArrayList<PartsText.PartText> parts = new ArrayList<PartsText.PartText>();
            if (positions.length == 0) {
                parts.addAll(PathSearchContext.ofPosition(text, -1));
            } else if (positions.length == 1 && positions[0] == text.length()) {
                parts.addAll(PathSearchContext.ofPosition(text, text.length() - 1));
            } else {
                int sidx = 0;
                int eidx = 0;
                for (int i = 0; i < positions.length; ++i) {
                    eidx = positions[i];
                    if (sidx < text.length()) {
                        String partText = text.substring(sidx, eidx + 1);
                        parts.addAll(PathSearchContext.ofPosition(partText, eidx - sidx));
                    } else {
                        parts.addAll(PathSearchContext.ofPosition(String.valueOf(text.charAt(text.length() - 1)), 0));
                    }
                    sidx = eidx + 1;
                }
                if (sidx < text.length()) {
                    String partText = text.substring(sidx, text.length());
                    parts.addAll(PathSearchContext.ofPosition(partText, -1));
                }
            }
            return PartsText.of(parts);
        }

        public static List<PartsText.PartText> ofPosition(String text, int position) {
            ArrayList<PartsText.PartText> parts = new ArrayList<PartsText.PartText>();
            if (position < 0) {
                parts.add(PartsText.PartText.of(text, false));
            } else if (position == 0) {
                if (text.length() == 1) {
                    parts.add(PartsText.PartText.of(String.valueOf(text.charAt(0)), true));
                } else {
                    parts.add(PartsText.PartText.of(String.valueOf(text.charAt(0)), true));
                    parts.add(PartsText.PartText.of(text.substring(1, text.length()), false));
                }
            } else if (position == text.length() - 1) {
                parts.add(PartsText.PartText.of(text.substring(0, text.length() - 1), false));
                parts.add(PartsText.PartText.of(String.valueOf(text.charAt(text.length() - 1)), true));
            } else {
                parts.add(PartsText.PartText.of(text.substring(0, position), false));
                parts.add(PartsText.PartText.of(String.valueOf(text.charAt(position)), true));
                parts.add(PartsText.PartText.of(text.substring(position + 1, text.length()), false));
            }
            return parts;
        }

        public static class PathViewItem
        implements Nameable {
            private Path path;
            private PartsText partsText;
            private boolean selected;

            public PathViewItem(Path path, PartsText partsText, boolean selected) {
                this.path = path;
                this.partsText = partsText;
                this.selected = selected;
            }

            @Override
            public String getName() {
                return this.path.toString();
            }

            public Path getPath() {
                return this.path;
            }

            public boolean isSelected() {
                return this.selected;
            }

            public PartsText getPartsText() {
                return this.partsText;
            }
        }
    }

    public static class PathScannerResult {
        private final List<ScoredPath> scoredPaths;
        private long dirCount = -1L;
        private long fileCount = -1L;
        private boolean hasFilter = false;

        PathScannerResult(List<ScoredPath> scoredPaths, long dirCount, long fileCount, boolean hasFilter) {
            Assert.notNull(scoredPaths, (String)"Scored paths cannot be null");
            this.scoredPaths = scoredPaths;
            this.dirCount = dirCount;
            this.fileCount = fileCount;
            this.hasFilter = hasFilter;
        }

        public static PathScannerResult of(List<ScoredPath> scoredPaths, boolean hasFilter) {
            return new PathScannerResult(scoredPaths, -1L, -1L, hasFilter);
        }

        public static PathScannerResult of(List<ScoredPath> scoredPaths, long dirCount, long fileCount, boolean hasFilter) {
            return new PathScannerResult(scoredPaths, dirCount, fileCount, hasFilter);
        }

        public List<ScoredPath> getScoredPaths() {
            return this.scoredPaths;
        }

        public long getDirCount() {
            return this.dirCount;
        }

        public long getFileCount() {
            return this.fileCount;
        }

        public boolean hasFilter() {
            return this.hasFilter;
        }
    }

    public static class ScoredPath
    implements Comparable<ScoredPath> {
        private final Path path;
        private final SearchMatchResult result;

        ScoredPath(Path path, SearchMatchResult result) {
            this.path = path;
            this.result = result;
        }

        public static ScoredPath of(Path path, SearchMatchResult result) {
            return new ScoredPath(path, result);
        }

        public Path getPath() {
            return this.path;
        }

        public SearchMatchResult getResult() {
            return this.result;
        }

        @Override
        public int compareTo(ScoredPath other) {
            int scoreCompare = Integer.compare(other.result.getScore(), this.result.getScore());
            if (scoreCompare == 0) {
                return -Integer.compare(other.getPath().toString().length(), this.getPath().toString().length());
            }
            return scoreCompare;
        }
    }

    private static class PathSearchPathVisitor
    extends AccumulatorPathVisitor {
        private final int limitFiles;
        private static final IOFileFilter DNFILTER = new NotFileFilter((IOFileFilter)new WildcardFileFilter(".*"));

        PathSearchPathVisitor(int limitFiles) {
            super(Counters.longPathCounters(), (PathFilter)DNFILTER, (PathFilter)DNFILTER);
            this.limitFiles = limitFiles;
        }

        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            FileVisitResult result = super.visitFile(file, attributes);
            if (this.getPathCounters().getFileCounter().get() >= (long)this.limitFiles) {
                return FileVisitResult.TERMINATE;
            }
            return result;
        }
    }

    private static class DefaultPathScanner
    implements BiFunction<String, PathSearchContext, PathScannerResult> {
        private DefaultPathScanner() {
        }

        static DefaultPathScanner of() {
            return new DefaultPathScanner();
        }

        @Override
        public PathScannerResult apply(String input, PathSearchContext context) {
            String[] split = input.split(" ", 2);
            String match = split.length == 2 ? split[1] : null;
            PathSearchPathVisitor visitor = new PathSearchPathVisitor(context.getPathSearchConfig().getMaxPathsSearch());
            try {
                String p2 = split[0];
                if (".".equals(p2)) {
                    p2 = "";
                }
                Path path = Path.of(p2, new String[0]);
                log.debug("Walking input {} for path {}", (Object)input, (Object)path);
                Files.walkFileTree(path, (FileVisitor<? super Path>)((Object)visitor));
                log.debug("walked files {} dirs {}", (Object)visitor.getPathCounters().getFileCounter().get(), (Object)visitor.getPathCounters().getDirectoryCounter().get());
            }
            catch (Exception e) {
                log.debug("PathSearchPathVisitor caused exception", (Throwable)e);
            }
            HashSet treeSet = new HashSet();
            Stream.concat(visitor.getFileList().stream(), visitor.getDirList().stream()).forEach(p -> {
                SearchMatchResult result;
                if (StringUtils.hasText((String)match)) {
                    SearchMatch searchMatch = SearchMatch.builder().caseSensitive(context.getPathSearchConfig().isSearchCaseSensitive()).normalize(context.getPathSearchConfig().isSearchNormalize()).forward(context.getPathSearchConfig().searchForward).build();
                    result = searchMatch.match(p.toString(), match);
                } else {
                    result = SearchMatchResult.ofMinus();
                }
                treeSet.add(ScoredPath.of(p, result));
            });
            return treeSet.stream().sorted().limit(context.getPathSearchConfig().getMaxPathsSearch()).collect(Collectors.collectingAndThen(Collectors.toList(), list -> PathScannerResult.of(list, visitor.getPathCounters().getDirectoryCounter().get(), visitor.getPathCounters().getFileCounter().get(), StringUtils.hasText((String)match))));
        }
    }

    private static class DefaultPathSearchContext
    extends AbstractTextComponent.BaseTextComponentContext<Path, PathSearchContext>
    implements PathSearchContext {
        private List<PathSearchContext.PathViewItem> pathViewItems;
        private PathSearchConfig pathSearchConfig;

        private DefaultPathSearchContext() {
        }

        @Override
        public List<PathSearchContext.PathViewItem> getPathViewItems() {
            return this.pathViewItems;
        }

        @Override
        public void setPathViewItems(List<PathSearchContext.PathViewItem> pathViewItems) {
            this.pathViewItems = pathViewItems;
        }

        @Override
        public PathSearchConfig getPathSearchConfig() {
            return this.pathSearchConfig;
        }

        @Override
        public void setPathSearchConfig(PathSearchConfig config) {
            this.pathSearchConfig = config;
        }

        @Override
        public Map<String, Object> toTemplateModel() {
            Map<String, Object> attributes = super.toTemplateModel();
            attributes.put("pathViewItems", this.getPathViewItems());
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("model", attributes);
            return model;
        }
    }
}

