/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component;

import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.component.ViewComponentExecutor;
import org.springframework.shell.component.message.ShellMessageBuilder;
import org.springframework.shell.component.view.TerminalUI;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.control.ViewDoneEvent;
import org.springframework.shell.component.view.event.EventLoop;
import org.springframework.shell.geom.Rectangle;
import org.springframework.util.Assert;

public class ViewComponent {
    private static final Logger log = LoggerFactory.getLogger(ViewComponent.class);
    private final Terminal terminal;
    private final View view;
    private EventLoop eventLoop;
    private TerminalUI terminalUI;
    private boolean useTerminalWidth = true;
    private ViewComponentExecutor viewComponentExecutor;

    public ViewComponent(TerminalUI terminalUI, Terminal terminal, ViewComponentExecutor viewComponentExecutor, View view) {
        Assert.notNull((Object)terminalUI, (String)"terminal ui must be set");
        Assert.notNull((Object)terminal, (String)"terminal must be set");
        Assert.notNull((Object)view, (String)"view must be set");
        this.terminalUI = terminalUI;
        this.terminal = terminal;
        this.view = view;
        this.viewComponentExecutor = viewComponentExecutor;
        this.eventLoop = terminalUI.getEventLoop();
        view.setEventLoop(this.eventLoop);
    }

    public ViewComponentRun runAsync() {
        ViewComponentRun run = this.viewComponentExecutor.start(() -> this.runBlocking());
        return run;
    }

    public void runBlocking() {
        log.debug("Start run()");
        this.eventLoop.onDestroy(this.eventLoop.viewEvents(ViewDoneEvent.class, this.view).subscribe(event -> this.exit()));
        this.view.setEventLoop(this.eventLoop);
        Size terminalSize = this.terminal.getSize();
        Rectangle rect = this.view.getRect();
        if (this.useTerminalWidth) {
            this.view.setRect(rect.x(), rect.y(), terminalSize.getColumns() - rect.x(), rect.height());
        }
        this.terminalUI.setRoot(this.view, false);
        this.terminalUI.run();
        log.debug("End run()");
    }

    public void setUseTerminalWidth(boolean useTerminalWidth) {
        this.useTerminalWidth = useTerminalWidth;
    }

    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public void exit() {
        this.eventLoop.dispatch(ShellMessageBuilder.ofInterrupt());
    }

    public static interface ViewComponentRun {
        public void await();

        public void cancel();

        public boolean isDone();
    }
}

