/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.shell.component.ViewComponent;

public class ViewComponentExecutor
implements AutoCloseable {
    private final Logger log = LoggerFactory.getLogger(ViewComponentExecutor.class);
    private final SimpleAsyncTaskExecutor executor = new SimpleAsyncTaskExecutor();
    private Future<?> future;

    @Override
    public void close() throws Exception {
        this.executor.close();
    }

    public ViewComponent.ViewComponentRun start(Runnable runnable) {
        if (this.future != null && !this.future.isDone()) {
            throw new IllegalStateException("Can run component as there is existing one in non stopped state");
        }
        this.future = this.executor.submit(() -> {
            this.log.debug("About to run component");
            runnable.run();
            this.log.debug("Finished run component");
        });
        return new FutureViewComponentRun(this.future);
    }

    public void stop() {
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.future = null;
    }

    private static class FutureViewComponentRun
    implements ViewComponent.ViewComponentRun {
        private Future<?> future;

        private FutureViewComponentRun(Future<?> future) {
            this.future = future;
        }

        @Override
        public void await() {
            try {
                this.future.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }

        @Override
        public void cancel() {
            this.future.cancel(true);
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }
    }
}

