/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.flow;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jline.utils.AttributedString;
import org.springframework.shell.component.PathInput;
import org.springframework.shell.component.flow.BaseInput;
import org.springframework.shell.component.flow.ComponentFlow;
import org.springframework.shell.component.flow.PathInputSpec;
import org.springframework.shell.component.flow.ResultMode;

public abstract class BasePathInput
extends BaseInput<PathInputSpec>
implements PathInputSpec {
    private String name;
    private String resultValue;
    private ResultMode resultMode;
    private String defaultValue;
    private Function<PathInput.PathInputContext, List<AttributedString>> renderer;
    private List<Consumer<PathInput.PathInputContext>> preHandlers = new ArrayList<Consumer<PathInput.PathInputContext>>();
    private List<Consumer<PathInput.PathInputContext>> postHandlers = new ArrayList<Consumer<PathInput.PathInputContext>>();
    private boolean storeResult = true;
    private String templateLocation;
    private Function<PathInput.PathInputContext, String> next;

    public BasePathInput(ComponentFlow.BaseBuilder builder, String id) {
        super(builder, id);
    }

    @Override
    public PathInputSpec name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public PathInputSpec resultValue(String resultValue) {
        this.resultValue = resultValue;
        return this;
    }

    @Override
    public PathInputSpec resultMode(ResultMode resultMode) {
        this.resultMode = resultMode;
        return this;
    }

    @Override
    public PathInputSpec defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public PathInputSpec renderer(Function<PathInput.PathInputContext, List<AttributedString>> renderer) {
        this.renderer = renderer;
        return this;
    }

    @Override
    public PathInputSpec template(String location) {
        this.templateLocation = location;
        return this;
    }

    @Override
    public PathInputSpec preHandler(Consumer<PathInput.PathInputContext> handler) {
        this.preHandlers.add(handler);
        return this;
    }

    @Override
    public PathInputSpec postHandler(Consumer<PathInput.PathInputContext> handler) {
        this.postHandlers.add(handler);
        return this;
    }

    @Override
    public PathInputSpec storeResult(boolean store) {
        this.storeResult = store;
        return this;
    }

    @Override
    public PathInputSpec next(Function<PathInput.PathInputContext, String> next) {
        this.next = next;
        return this;
    }

    @Override
    public ComponentFlow.Builder and() {
        this.getBuilder().addPathInput(this);
        return this.getBuilder();
    }

    @Override
    public PathInputSpec getThis() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getResultValue() {
        return this.resultValue;
    }

    public ResultMode getResultMode() {
        return this.resultMode;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Function<PathInput.PathInputContext, List<AttributedString>> getRenderer() {
        return this.renderer;
    }

    public String getTemplateLocation() {
        return this.templateLocation;
    }

    public List<Consumer<PathInput.PathInputContext>> getPreHandlers() {
        return this.preHandlers;
    }

    public List<Consumer<PathInput.PathInputContext>> getPostHandlers() {
        return this.postHandlers;
    }

    public boolean isStoreResult() {
        return this.storeResult;
    }

    public Function<PathInput.PathInputContext, String> getNext() {
        return this.next;
    }
}

