/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.message;

import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.shell.component.message.ShellMessageHeaderAccessor;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.event.EventLoop;
import org.springframework.shell.component.view.event.KeyEvent;
import org.springframework.shell.component.view.event.MouseEvent;
import org.springframework.util.Assert;

public final class ShellMessageBuilder<T> {
    private final T payload;
    private final ShellMessageHeaderAccessor headerAccessor;
    @Nullable
    private final Message<T> originalMessage;

    private ShellMessageBuilder(T payload, @Nullable Message<T> originalMessage) {
        Assert.notNull(payload, (String)"payload must not be null");
        this.payload = payload;
        this.originalMessage = originalMessage;
        this.headerAccessor = new ShellMessageHeaderAccessor(originalMessage);
    }

    public static <T> ShellMessageBuilder<T> withPayload(T payload) {
        return new ShellMessageBuilder<T>(payload, null);
    }

    public static Message<String> ofRedraw() {
        return new ShellMessageBuilder<String>("redraw", null).setEventType(EventLoop.Type.SYSTEM).setPriority(0).build();
    }

    public static Message<String> ofInterrupt() {
        return new ShellMessageBuilder<String>("int", null).setEventType(EventLoop.Type.SYSTEM).setPriority(0).build();
    }

    public static Message<String> ofSignal(String signal) {
        return new ShellMessageBuilder<String>(signal, null).setEventType(EventLoop.Type.SIGNAL).setPriority(0).build();
    }

    public static Message<KeyEvent> ofKeyEvent(KeyEvent event) {
        return new ShellMessageBuilder<KeyEvent>(event, null).setEventType(EventLoop.Type.KEY).build();
    }

    public static Message<MouseEvent> ofMouseEvent(MouseEvent event) {
        return new ShellMessageBuilder<MouseEvent>(event, null).setEventType(EventLoop.Type.MOUSE).build();
    }

    public static Message<?> ofView(View view, Object args) {
        return new ShellMessageBuilder<Object>(args, null).setEventType(EventLoop.Type.VIEW).setView(view).build();
    }

    public static Message<String> ofViewFocus(String action, View view) {
        return new ShellMessageBuilder<String>(action, null).setEventType(EventLoop.Type.SYSTEM).setView(view).build();
    }

    public ShellMessageBuilder<T> setPriority(Integer priority) {
        return this.setHeader("priority", priority);
    }

    public ShellMessageBuilder<T> setView(View view) {
        return this.setHeader("view", view);
    }

    public ShellMessageBuilder<T> setEventType(EventLoop.Type type) {
        return this.setHeader("eventType", (Object)type);
    }

    public ShellMessageBuilder<T> setHeader(String headerName, @Nullable Object headerValue) {
        this.headerAccessor.setHeader(headerName, headerValue);
        return this;
    }

    public Message<T> build() {
        return new GenericMessage(this.payload, this.headerAccessor.toMap());
    }
}

