/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.message;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.event.EventLoop;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.util.context.ContextView;

public class ShellMessageHeaderAccessor
extends MessageHeaderAccessor {
    public static final String PRIORITY = "priority";
    public static final String VIEW = "view";
    public static final String REACTOR_CONTEXT = "reactorContext";
    public static final String EVENT_TYPE = "eventType";
    private static final BiFunction<String, String, String> TYPE_VERIFY_MESSAGE_FUNCTION = (name, trailer) -> "The '" + name + trailer;
    private Set<String> readOnlyHeaders = new HashSet<String>();

    public ShellMessageHeaderAccessor(@Nullable Message<?> message) {
        super(message);
    }

    public void setReadOnlyHeaders(String ... readOnlyHeaders) {
        Assert.noNullElements((Object[])readOnlyHeaders, (String)"'readOnlyHeaders' must not be contain null items.");
        if (!ObjectUtils.isEmpty((Object[])readOnlyHeaders)) {
            this.readOnlyHeaders = new HashSet<String>(Arrays.asList(readOnlyHeaders));
        }
    }

    @Nullable
    public Integer getPriority() {
        Number priority = this.getHeader(PRIORITY, Number.class);
        return priority != null ? Integer.valueOf(priority.intValue()) : null;
    }

    @Nullable
    public View getView() {
        View view = this.getHeader(VIEW, View.class);
        return view;
    }

    @Nullable
    public ContextView getReactorContext() {
        return this.getHeader(REACTOR_CONTEXT, ContextView.class);
    }

    @Nullable
    public EventLoop.Type getEventType() {
        return this.getHeader(EVENT_TYPE, EventLoop.Type.class);
    }

    @Nullable
    public <T> T getHeader(String key, Class<T> type) {
        Object value = this.getHeader(key);
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Incorrect type specified for header '" + key + "'. Expected [" + type + "] but actual type is [" + value.getClass() + "]");
        }
        return (T)value;
    }

    protected void verifyType(String headerName, Object headerValue) {
        if (headerName != null && headerValue != null) {
            super.verifyType(headerName, headerValue);
            if (PRIORITY.equals(headerName)) {
                Assert.isTrue((boolean)Number.class.isAssignableFrom(headerValue.getClass()), (String)TYPE_VERIFY_MESSAGE_FUNCTION.apply(headerName, "' header value must be a Number."));
            }
        }
    }

    public boolean isReadOnly(String headerName) {
        return super.isReadOnly(headerName) || this.readOnlyHeaders.contains(headerName);
    }

    public Map<String, Object> toMap() {
        if (ObjectUtils.isEmpty(this.readOnlyHeaders)) {
            return super.toMap();
        }
        Map headers = super.toMap();
        for (String header : this.readOnlyHeaders) {
            headers.remove(header);
        }
        return headers;
    }
}

