/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.message;

import java.util.UUID;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.event.EventLoop;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public final class StaticShellMessageHeaderAccessor {
    private StaticShellMessageHeaderAccessor() {
    }

    @Nullable
    public static UUID getId(Message<?> message) {
        Object value = message.getHeaders().get((Object)"id");
        if (value == null) {
            return null;
        }
        return value instanceof UUID ? (UUID)value : UUID.fromString(value.toString());
    }

    @Nullable
    public static Long getTimestamp(Message<?> message) {
        Object value = message.getHeaders().get((Object)"timestamp");
        if (value == null) {
            return null;
        }
        return value instanceof Long ? (Long)value : Long.parseLong(value.toString());
    }

    @Nullable
    public static Integer getPriority(Message<?> message) {
        Number priority = (Number)message.getHeaders().get((Object)"priority", Number.class);
        return priority != null ? Integer.valueOf(priority.intValue()) : null;
    }

    @Nullable
    public static View getView(Message<?> message) {
        View view = (View)message.getHeaders().get((Object)"view", View.class);
        return view;
    }

    public static ContextView getReactorContext(Message<?> message) {
        ContextView reactorContext = (ContextView)message.getHeaders().get((Object)"reactorContext", ContextView.class);
        if (reactorContext == null) {
            reactorContext = Context.empty();
        }
        return reactorContext;
    }

    public static EventLoop.Type getEventType(Message<?> message) {
        EventLoop.Type eventType = (EventLoop.Type)((Object)message.getHeaders().get((Object)"eventType", EventLoop.Type.class));
        return eventType;
    }
}

