/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.support;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.DumbTerminal;
import org.jline.utils.AttributedString;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.shell.component.context.ComponentContext;
import org.springframework.shell.style.TemplateExecutor;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractComponent<T extends ComponentContext<T>>
implements ResourceLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractComponent.class);
    public static final String OPERATION_EXIT = "EXIT";
    public static final String OPERATION_BACKSPACE = "BACKSPACE";
    public static final String OPERATION_CHAR = "CHAR";
    public static final String OPERATION_UNICODE = "UNICODE";
    public static final String OPERATION_SELECT = "SELECT";
    public static final String OPERATION_DOWN = "DOWN";
    public static final String OPERATION_UP = "UP";
    private final Terminal terminal;
    private final BindingReader bindingReader;
    private final KeyMap<String> keyMap = new KeyMap();
    private final List<Consumer<T>> preRunHandlers = new ArrayList<Consumer<T>>();
    private final List<Consumer<T>> postRunHandlers = new ArrayList<Consumer<T>>();
    private Function<T, List<AttributedString>> renderer;
    private boolean printResults = true;
    private String templateLocation;
    private TemplateExecutor templateExecutor;
    private ResourceLoader resourceLoader;

    public AbstractComponent(Terminal terminal) {
        Assert.notNull((Object)terminal, (String)"terminal must be set");
        this.terminal = terminal;
        this.bindingReader = new BindingReader(terminal.reader());
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setRenderer(Function<T, List<AttributedString>> renderer) {
        this.renderer = renderer;
    }

    public List<AttributedString> render(T context) {
        log.debug("Rendering with context [{}] as class [{}] in [{}]", new Object[]{context, context.getClass(), this});
        return this.renderer.apply(context);
    }

    public void addPreRunHandler(Consumer<T> handler) {
        this.preRunHandlers.add(handler);
    }

    public void addPostRunHandler(Consumer<T> handler) {
        this.postRunHandlers.add(handler);
    }

    public void setPrintResults(boolean printResults) {
        this.printResults = printResults;
    }

    public final T run(ComponentContext<?> context) {
        this.bindKeyMap(this.keyMap);
        context = this.runPreRunHandlers(this.getThisContext(context));
        T run = this.runInternal(this.getThisContext(context));
        context = this.runPostRunHandlers(this.getThisContext(context));
        if (this.printResults && this.hasTty()) {
            this.printResults(context);
        }
        return run;
    }

    public TemplateExecutor getTemplateExecutor() {
        return this.templateExecutor;
    }

    public void setTemplateExecutor(TemplateExecutor templateExecutor) {
        this.templateExecutor = templateExecutor;
    }

    public void setTemplateLocation(String templateLocation) {
        this.templateLocation = templateLocation;
    }

    protected boolean hasTty() {
        boolean hasTty = true;
        if (this.terminal instanceof DumbTerminal && this.terminal.getSize().getRows() == 0) {
            hasTty = false;
        }
        log.debug("Terminal is {} with size {}, marking hasTty as {}", new Object[]{this.terminal, this.terminal.getSize(), hasTty});
        return hasTty;
    }

    protected List<AttributedString> renderTemplateResource(Map<String, Object> attributes) {
        String templateResource = AbstractComponent.resourceAsString(this.resourceLoader.getResource(this.templateLocation));
        log.debug("Rendering template: {}", (Object)templateResource);
        log.debug("Rendering template attributes: {}", attributes);
        AttributedString rendered = this.templateLocation.endsWith(".stg") ? this.templateExecutor.renderGroup(templateResource, attributes) : this.templateExecutor.render(templateResource, attributes);
        log.debug("Template executor result: [{}]", (Object)rendered);
        List rows = rendered.columnSplitLength(Integer.MAX_VALUE);
        int lastIndex = rows.size() - 1;
        if (lastIndex > 0 && ((AttributedString)rows.get(lastIndex)).length() == 0) {
            rows.remove(lastIndex);
        }
        return rows;
    }

    public abstract T getThisContext(ComponentContext<?> var1);

    protected abstract boolean read(BindingReader var1, KeyMap<String> var2, T var3);

    protected abstract T runInternal(T var1);

    protected abstract void bindKeyMap(KeyMap<String> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loop(ComponentContext<?> context) {
        Display display = new Display(this.terminal, false);
        Attributes attr = this.terminal.enterRawMode();
        Size size = new Size();
        try {
            boolean exit;
            this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.cursor_invisible, new Object[0]);
            this.terminal.writer().flush();
            size.copy(this.terminal.getSize());
            display.clear();
            display.reset();
            do {
                display.resize(size.getRows(), size.getColumns());
                display.update(this.render(this.getThisContext(context)), 0);
            } while (!(exit = this.read(this.bindingReader, this.keyMap, this.getThisContext(context))));
        }
        finally {
            this.terminal.setAttributes(attr);
            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.cursor_normal, new Object[0]);
            display.update(Collections.emptyList(), 0);
        }
    }

    protected T runPreRunHandlers(T context) {
        this.preRunHandlers.stream().forEach(c -> c.accept(context));
        return context;
    }

    protected T runPostRunHandlers(T context) {
        this.postRunHandlers.stream().forEach(c -> c.accept(context));
        return context;
    }

    private void printResults(ComponentContext<?> context) {
        log.debug("About to write result with incoming context [{}] as class [{}] in [{}]", new Object[]{context, context.getClass(), this});
        String out = this.render(this.getThisContext(context)).stream().map(as -> as.toAnsi()).collect(Collectors.joining("\n"));
        log.debug("Writing result [{}] in [{}]", (Object)out, (Object)this);
        if (StringUtils.hasText((String)out)) {
            this.terminal.writer().println(out);
            this.terminal.writer().flush();
        }
    }

    private static String resourceAsString(Resource resource) {
        String string;
        InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
        try {
            string = FileCopyUtils.copyToString((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((Reader)reader).close();
        return string;
    }
}

