/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.support;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.component.context.BaseComponentContext;
import org.springframework.shell.component.context.ComponentContext;
import org.springframework.shell.component.support.AbstractComponent;
import org.springframework.shell.component.support.Enableable;
import org.springframework.shell.component.support.Matchable;
import org.springframework.shell.component.support.Nameable;
import org.springframework.shell.component.support.Selectable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractSelectorComponent<T, C extends SelectorComponentContext<T, I, C>, I extends Nameable & Matchable & Selectable>
extends AbstractComponent<C> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSelectorComponent.class);
    protected final String name;
    private final List<I> items;
    private Comparator<I> comparator = (o1, o2) -> 0;
    private boolean exitSelects;
    private int maxItems = 5;
    private Function<T, String> itemMapper = item -> item.toString();
    private boolean stale = false;
    private AtomicInteger start = new AtomicInteger(0);
    private AtomicInteger pos = new AtomicInteger(0);
    private I defaultExpose;
    private boolean expose = false;

    public AbstractSelectorComponent(Terminal terminal, String name, List<I> items, boolean exitSelects, Comparator<I> comparator) {
        super(terminal);
        this.name = name;
        this.items = items;
        this.exitSelects = exitSelects;
        if (comparator != null) {
            this.comparator = comparator;
        }
    }

    public void setMaxItems(int maxItems) {
        Assert.state((maxItems > 0 || maxItems < 33 ? 1 : 0) != 0, (String)"maxItems has to be between 1 and 32");
        this.maxItems = maxItems;
    }

    public void setItemMapper(Function<T, String> itemMapper) {
        Assert.notNull(itemMapper, (String)"itemMapper cannot be null");
        this.itemMapper = itemMapper;
    }

    public Function<T, String> getItemMapper() {
        return this.itemMapper;
    }

    public void setDefaultExpose(I defaultExpose) {
        this.defaultExpose = defaultExpose;
        if (defaultExpose != null) {
            this.expose = true;
        }
    }

    protected List<I> getItems() {
        return this.items;
    }

    @Override
    protected void bindKeyMap(KeyMap<String> keyMap) {
        keyMap.bind((Object)"SELECT", (CharSequence)" ");
        keyMap.bind((Object)"DOWN", new CharSequence[]{KeyMap.ctrl((char)'E'), KeyMap.key((Terminal)this.getTerminal(), (InfoCmp.Capability)InfoCmp.Capability.key_down)});
        keyMap.bind((Object)"UP", new CharSequence[]{KeyMap.ctrl((char)'Y'), KeyMap.key((Terminal)this.getTerminal(), (InfoCmp.Capability)InfoCmp.Capability.key_up)});
        keyMap.bind((Object)"EXIT", (CharSequence)"\r");
        keyMap.bind((Object)"BACKSPACE", new CharSequence[]{KeyMap.del(), KeyMap.key((Terminal)this.getTerminal(), (InfoCmp.Capability)InfoCmp.Capability.key_backspace)});
        for (char i = '!'; i < '\u007f'; i = (char)(i + '\u0001')) {
            keyMap.bind((Object)"CHAR", (CharSequence)Character.toString(i));
        }
    }

    @Override
    protected C runInternal(C context) {
        SelectorComponentContext thisContext = (SelectorComponentContext)this.getThisContext((ComponentContext<?>)context);
        this.initialExpose(thisContext);
        ItemStateViewProjection buildItemStateView = this.buildItemStateView(this.start.get(), thisContext);
        List itemStateView = buildItemStateView.items;
        thisContext.setItemStateView(itemStateView);
        thisContext.setCursorRow(this.start.get() + this.pos.get());
        return (C)thisContext;
    }

    @Override
    protected boolean read(BindingReader bindingReader, KeyMap<String> keyMap, C context) {
        if (this.stale) {
            this.start.set(0);
            this.pos.set(0);
            this.stale = false;
        }
        SelectorComponentContext thisContext = (SelectorComponentContext)this.getThisContext((ComponentContext<?>)context);
        ItemStateViewProjection buildItemStateView = this.buildItemStateView(this.start.get(), thisContext);
        List itemStateView = buildItemStateView.items;
        String operation = (String)bindingReader.readBinding(keyMap);
        log.debug("Binding read result {}", (Object)operation);
        if (operation == null) {
            return true;
        }
        switch (operation) {
            case "SELECT": {
                if (this.exitSelects) break;
                itemStateView.forEach(i -> {
                    if (i.index == this.start.get() + this.pos.get() && i.enabled) {
                        i.selected = !i.selected;
                    }
                });
                break;
            }
            case "DOWN": {
                if (this.start.get() + this.pos.get() + 1 < itemStateView.size()) {
                    this.pos.incrementAndGet();
                    break;
                }
                if (this.start.get() + this.pos.get() + 1 >= buildItemStateView.total) {
                    this.start.set(0);
                    this.pos.set(0);
                    break;
                }
                this.start.incrementAndGet();
                break;
            }
            case "UP": {
                if (this.start.get() > 0 && this.pos.get() == 0) {
                    this.start.decrementAndGet();
                    break;
                }
                if (this.start.get() + this.pos.get() >= itemStateView.size()) {
                    this.pos.decrementAndGet();
                    break;
                }
                if (this.start.get() + this.pos.get() <= 0) {
                    this.start.set(buildItemStateView.total - Math.min(this.maxItems, itemStateView.size()));
                    this.pos.set(itemStateView.size() - 1);
                    break;
                }
                this.pos.decrementAndGet();
                break;
            }
            case "CHAR": {
                String lastBinding = bindingReader.getLastBinding();
                Object input = thisContext.getInput();
                input = input == null ? lastBinding : (String)input + lastBinding;
                thisContext.setInput((String)input);
                this.stale = true;
                break;
            }
            case "BACKSPACE": {
                String input = thisContext.getInput();
                if (StringUtils.hasLength((String)input)) {
                    input = input.length() > 1 ? input.substring(0, input.length() - 1) : null;
                }
                thisContext.setInput(input);
                break;
            }
            case "EXIT": {
                if (this.exitSelects) {
                    if (itemStateView.size() == 0) break;
                    itemStateView.forEach(i -> {
                        if (i.index == this.start.get() + this.pos.get()) {
                            i.selected = !i.selected;
                        }
                    });
                }
                List values = thisContext.getItemStates().stream().filter(i -> i.selected).map(i -> (Nameable)i.item).collect(Collectors.toList());
                thisContext.setResultItems(values);
                return true;
            }
        }
        thisContext.setCursorRow(this.start.get() + this.pos.get());
        buildItemStateView = this.buildItemStateView(this.start.get(), thisContext);
        thisContext.setItemStateView(buildItemStateView.items);
        return false;
    }

    private void initialExpose(C context) {
        if (!this.expose) {
            return;
        }
        this.expose = false;
        List<ItemState<Object>> itemStates = context.getItemStates();
        if (itemStates == null) {
            AtomicInteger index = new AtomicInteger(0);
            itemStates = context.getItems().stream().sorted(this.comparator).map(item -> ItemState.of(item, item.getName(), index.getAndIncrement(), ((Enableable)((Object)item)).isEnabled(), ((Selectable)((Object)item)).isSelected())).collect(Collectors.toList());
        }
        for (int i = 0; i < itemStates.size(); ++i) {
            if (!ObjectUtils.nullSafeEquals((Object)itemStates.get(i).getName(), (Object)this.defaultExpose.getName())) continue;
            if (i < this.maxItems) {
                this.pos.set(i);
                break;
            }
            this.pos.set(this.maxItems - 1);
            this.start.set(i - this.maxItems + 1);
            break;
        }
    }

    private ItemStateViewProjection buildItemStateView(int skip, SelectorComponentContext<T, I, ?> context) {
        List<ItemState<Object>> itemStates = context.getItemStates();
        if (itemStates == null) {
            AtomicInteger index = new AtomicInteger(0);
            itemStates = context.getItems().stream().sorted(this.comparator).map(item -> ItemState.of(item, item.getName(), index.getAndIncrement(), ((Enableable)((Object)item)).isEnabled(), ((Selectable)((Object)item)).isSelected())).collect(Collectors.toList());
            context.setItemStates(itemStates);
        }
        AtomicInteger reindex = new AtomicInteger(0);
        List filtered = itemStates.stream().filter(i -> i.matches(context.getInput())).map(i -> {
            i.index = reindex.getAndIncrement();
            return i;
        }).collect(Collectors.toList());
        List items = filtered.stream().skip(skip).limit(this.maxItems).collect(Collectors.toList());
        return new ItemStateViewProjection(items, filtered.size());
    }

    public static interface SelectorComponentContext<T, I extends Nameable & Matchable, C extends SelectorComponentContext<T, I, C>>
    extends ComponentContext<C> {
        public String getName();

        public void setName(String var1);

        public String getInput();

        public void setInput(String var1);

        public List<ItemState<I>> getItemStates();

        public void setItemStates(List<ItemState<I>> var1);

        public List<ItemState<I>> getItemStateView();

        public void setItemStateView(List<ItemState<I>> var1);

        public boolean isResult();

        public Integer getCursorRow();

        public void setCursorRow(Integer var1);

        public List<I> getItems();

        public void setItems(List<I> var1);

        public List<I> getResultItems();

        public void setResultItems(List<I> var1);

        public static <T, I extends Nameable & Matchable, C extends SelectorComponentContext<T, I, C>> SelectorComponentContext<T, I, C> empty() {
            return new BaseSelectorComponentContext();
        }
    }

    private class ItemStateViewProjection {
        List<ItemState<I>> items;
        int total;

        ItemStateViewProjection(List<ItemState<I>> items, int total) {
            this.items = items;
            this.total = total;
        }
    }

    public static class ItemState<I extends Matchable>
    implements Matchable {
        I item;
        String name;
        boolean selected;
        boolean enabled;
        int index;

        ItemState(I item, String name, int index, boolean enabled, boolean selected) {
            this.item = item;
            this.name = name;
            this.index = index;
            this.enabled = enabled;
            this.selected = selected;
        }

        @Override
        public boolean matches(String match) {
            return this.item.matches(match);
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        static <I extends Matchable> ItemState<I> of(I item, String name, int index, boolean enabled, boolean selected) {
            return new ItemState<I>(item, name, index, enabled, selected);
        }
    }

    protected static class BaseSelectorComponentContext<T, I extends Nameable & Matchable, C extends SelectorComponentContext<T, I, C>>
    extends BaseComponentContext<C>
    implements SelectorComponentContext<T, I, C> {
        private String name;
        private String input;
        private List<ItemState<I>> itemStates;
        private List<ItemState<I>> itemStateView;
        private Integer cursorRow;
        private List<I> items;
        private List<I> resultItems;

        protected BaseSelectorComponentContext() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getInput() {
            return this.input;
        }

        @Override
        public void setInput(String input) {
            this.input = input;
        }

        @Override
        public List<ItemState<I>> getItemStates() {
            return this.itemStates;
        }

        @Override
        public void setItemStates(List<ItemState<I>> itemStates) {
            this.itemStates = itemStates;
        }

        @Override
        public List<ItemState<I>> getItemStateView() {
            return this.itemStateView;
        }

        @Override
        public void setItemStateView(List<ItemState<I>> itemStateView) {
            this.itemStateView = itemStateView;
        }

        @Override
        public boolean isResult() {
            return this.resultItems != null;
        }

        @Override
        public Integer getCursorRow() {
            return this.cursorRow;
        }

        @Override
        public Map<String, Object> toTemplateModel() {
            Map<String, Object> attributes = super.toTemplateModel();
            attributes.put("name", this.getName());
            attributes.put("input", this.getInput());
            attributes.put("itemStates", this.getItemStates());
            attributes.put("itemStateView", this.getItemStateView());
            attributes.put("isResult", this.isResult());
            attributes.put("cursorRow", this.getCursorRow());
            return attributes;
        }

        @Override
        public void setCursorRow(Integer cursorRow) {
            this.cursorRow = cursorRow;
        }

        @Override
        public List<I> getItems() {
            return this.items;
        }

        @Override
        public void setItems(List<I> items) {
            this.items = items;
        }

        @Override
        public List<I> getResultItems() {
            return this.resultItems;
        }

        @Override
        public void setResultItems(List<I> resultItems) {
            this.resultItems = resultItems;
        }

        @Override
        public String toString() {
            return "DefaultSelectorComponentContext [cursorRow=" + this.cursorRow + "]";
        }
    }
}

