/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view;

import java.io.IOError;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.shell.component.message.ShellMessageBuilder;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.control.ViewService;
import org.springframework.shell.component.view.event.DefaultEventLoop;
import org.springframework.shell.component.view.event.EventLoop;
import org.springframework.shell.component.view.event.KeyBinder;
import org.springframework.shell.component.view.event.KeyEvent;
import org.springframework.shell.component.view.event.KeyHandler;
import org.springframework.shell.component.view.event.MouseEvent;
import org.springframework.shell.component.view.event.MouseHandler;
import org.springframework.shell.component.view.screen.DefaultScreen;
import org.springframework.shell.geom.Rectangle;
import org.springframework.shell.style.ThemeResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TerminalUI
implements ViewService {
    private static final Logger log = LoggerFactory.getLogger(TerminalUI.class);
    private final Terminal terminal;
    private final BindingReader bindingReader;
    private final KeyMap<Integer> keyMap = new KeyMap();
    private final DefaultScreen virtualDisplay = new DefaultScreen();
    private Display display;
    private Size size;
    private View rootView;
    private View modalView;
    private boolean fullScreen;
    private final KeyBinder keyBinder;
    private DefaultEventLoop eventLoop = new DefaultEventLoop();
    private View focus = null;
    private ThemeResolver themeResolver;
    private String themeName = "default";
    private BiFunction<Terminal, View, Rectangle> fullScreenViewRect = (terminal, view) -> {
        Size s = terminal.getSize();
        return new Rectangle(0, 0, s.getColumns(), s.getRows());
    };
    private BiFunction<Terminal, View, Rectangle> nonfullScreenViewRect = (terminal, view) -> {
        Size s = terminal.getSize();
        Rectangle rect = view.getRect();
        if (!rect.isEmpty()) {
            return rect;
        }
        return new Rectangle(0, 0, s.getColumns(), 5);
    };

    public TerminalUI(Terminal terminal2) {
        Assert.notNull((Object)terminal2, (String)"terminal must be set");
        this.terminal = terminal2;
        this.bindingReader = new BindingReader(terminal2.reader());
        this.keyBinder = new KeyBinder(terminal2);
    }

    @Override
    public View getModal() {
        return this.modalView;
    }

    @Override
    public void setModal(View view) {
        this.modalView = view;
    }

    public void setRoot(View root, boolean fullScreen) {
        this.setFocus(root);
        this.rootView = root;
        this.fullScreen = fullScreen;
    }

    public void run() {
        this.bindKeyMap(this.keyMap);
        this.display = new Display(this.terminal, this.fullScreen);
        this.size = new Size();
        this.loop();
    }

    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public void redraw() {
        this.getEventLoop().dispatch(ShellMessageBuilder.ofRedraw());
    }

    public void setThemeResolver(ThemeResolver themeResolver) {
        this.themeResolver = themeResolver;
    }

    public ThemeResolver getThemeResolver() {
        return this.themeResolver;
    }

    public void setThemeName(String themeName) {
        this.themeName = themeName;
    }

    public String getThemeName() {
        return this.themeName;
    }

    public ViewService getViewService() {
        return this;
    }

    public void configure(View view) {
        view.init();
        view.setEventLoop(this.eventLoop);
        view.setThemeResolver(this.themeResolver);
        view.setThemeName(this.themeName);
        view.setViewService(this.getViewService());
    }

    @Override
    public void setFocus(@Nullable View view) {
        if (this.focus != null) {
            this.focus.focus(this.focus, false);
        }
        this.focus = view;
        if (this.focus != null) {
            this.focus.focus(this.focus, true);
        }
    }

    private void render(Rectangle rect) {
        if (this.rootView != null) {
            this.rootView.setRect(rect.x(), rect.y(), rect.width(), rect.height());
            this.rootView.draw(this.virtualDisplay);
        }
        if (this.modalView != null) {
            this.modalView.setLayer(1);
            this.modalView.setRect(rect.x(), rect.y(), rect.width(), rect.height());
            this.modalView.draw(this.virtualDisplay);
        }
    }

    public void setFullScreenViewRect(BiFunction<Terminal, View, Rectangle> fullScreenViewRect) {
        Assert.notNull(fullScreenViewRect, (String)"view rect function must be set");
        this.fullScreenViewRect = fullScreenViewRect;
    }

    public void setNonfullScreenViewRect(BiFunction<Terminal, View, Rectangle> nonfullScreenViewRect) {
        Assert.notNull(nonfullScreenViewRect, (String)"view rect function must be set");
        this.nonfullScreenViewRect = nonfullScreenViewRect;
    }

    private synchronized void display() {
        log.trace("display() start");
        this.size.copy(this.terminal.getSize());
        if (this.fullScreen) {
            this.display.clear();
            this.display.reset();
            this.display.resize(this.size.getRows(), this.size.getColumns());
            rect = this.fullScreenViewRect.apply(this.terminal, this.rootView);
            this.rootView.setRect(rect.x(), rect.y(), rect.width(), rect.height());
            this.virtualDisplay.resize(this.size.getRows(), this.size.getColumns());
            this.virtualDisplay.setShowCursor(false);
            this.render(rect);
        } else {
            rect = this.nonfullScreenViewRect.apply(this.terminal, this.rootView);
            this.display.reset();
            this.display.resize(this.size.getRows(), this.size.getColumns());
            this.virtualDisplay.resize(rect.height(), rect.width());
            this.virtualDisplay.setShowCursor(false);
            this.render(rect);
        }
        List<AttributedString> newLines = this.virtualDisplay.getScreenLines();
        int targetCursorPos = 0;
        if (this.virtualDisplay.isShowCursor()) {
            this.terminal.puts(InfoCmp.Capability.cursor_normal, new Object[0]);
            targetCursorPos = this.size.cursorPos(this.virtualDisplay.getCursorPosition().y(), this.virtualDisplay.getCursorPosition().x());
            log.debug("Display targetCursorPos {}", (Object)targetCursorPos);
        } else {
            this.terminal.puts(InfoCmp.Capability.cursor_invisible, new Object[0]);
        }
        this.display.update(newLines, targetCursorPos);
        log.trace("display() end");
    }

    private void dispatchWinch() {
        this.eventLoop.dispatch(ShellMessageBuilder.ofSignal("WINCH"));
    }

    private void registerEventHandling() {
        this.eventLoop.onDestroy(this.eventLoop.signalEvents().subscribe(event -> this.display()));
        this.eventLoop.onDestroy(this.eventLoop.systemEvents().subscribe(event -> {
            if ("redraw".equals(event)) {
                this.display();
            } else if ("int".equals(event)) {
                this.terminal.raise(Terminal.Signal.INT);
            }
        }));
        this.eventLoop.onDestroy(this.eventLoop.keyEvents().doOnNext(m -> this.handleKeyEvent((KeyEvent)m)).subscribe());
        this.eventLoop.onDestroy(this.eventLoop.mouseEvents().doOnNext(m -> this.handleMouseEvent((MouseEvent)m)).subscribe());
    }

    private void handleKeyEvent(KeyEvent event) {
        log.trace("handleKeyEvent {}", (Object)event);
        if (this.rootView != null) {
            KeyHandler.KeyHandlerResult result;
            KeyHandler handler = this.rootView.getHotKeyHandler();
            if (handler != null && (result = handler.handle(KeyHandler.argsOf(event))).consumed()) {
                if (result.focus() != null) {
                    this.setFocus(result.focus());
                }
                return;
            }
            if (this.rootView.hasFocus() && (handler = this.rootView.getKeyHandler()) != null && (result = handler.handle(KeyHandler.argsOf(event))).focus() != null) {
                this.setFocus(result.focus());
            }
        }
    }

    private void handleMouseEvent(MouseEvent event) {
        MouseHandler.MouseHandlerResult result;
        MouseHandler handler;
        View view;
        log.trace("handleMouseEvent {}", (Object)event);
        View view2 = view = this.modalView != null ? this.modalView : this.rootView;
        if (view != null && (handler = view.getMouseHandler()) != null && (result = handler.handle(MouseHandler.argsOf(event))).focus() != null) {
            this.setFocus(result.focus());
        }
    }

    private void loop() {
        Attributes attr = this.terminal.enterRawMode();
        this.registerEventHandling();
        this.terminal.handle(Terminal.Signal.WINCH, signal -> {
            log.debug("Handling signal {}", (Object)signal);
            this.dispatchWinch();
        });
        try {
            boolean exit;
            if (this.fullScreen) {
                this.terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0]);
            }
            this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.cursor_invisible, new Object[0]);
            this.terminal.trackMouse(Terminal.MouseTracking.Normal);
            this.terminal.writer().flush();
            this.size.copy(this.terminal.getSize());
            this.display.clear();
            this.display.reset();
            do {
                this.display();
            } while (!(exit = this.read(this.bindingReader, this.keyMap)));
        }
        finally {
            this.eventLoop.destroy();
            this.terminal.setAttributes(attr);
            log.debug("Setting cursor visible");
            this.terminal.puts(InfoCmp.Capability.cursor_normal, new Object[0]);
            if (this.fullScreen) {
                this.display.update(Collections.emptyList(), 0);
            }
            this.terminal.trackMouse(Terminal.MouseTracking.Off);
            if (this.fullScreen) {
                this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
            }
            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
            if (!this.fullScreen) {
                this.display.update(Collections.emptyList(), 0);
            }
        }
    }

    private void bindKeyMap(KeyMap<Integer> keyMap) {
        this.keyBinder.bindAll(keyMap);
    }

    private boolean read(BindingReader bindingReader, KeyMap<Integer> keyMap) {
        Thread readThread = Thread.currentThread();
        this.terminal.handle(Terminal.Signal.INT, signal -> {
            log.debug("Handling signal {}", (Object)signal);
            readThread.interrupt();
        });
        Integer operation = null;
        try {
            operation = (Integer)bindingReader.readBinding(keyMap);
            log.debug("Read got operation {}", (Object)operation);
        }
        catch (IOError e) {
            log.trace("Read binding error {}", (Throwable)e);
        }
        if (operation == null) {
            return true;
        }
        if (operation == 0x1000000) {
            String lastBinding = bindingReader.getLastBinding();
            if (StringUtils.hasLength((String)lastBinding)) {
                this.dispatchKeyEvent(KeyEvent.of(lastBinding.charAt(0)));
            }
        } else if (operation == 0x1000002) {
            String lastBinding = bindingReader.getLastBinding();
            if (StringUtils.hasLength((String)lastBinding)) {
                this.dispatchKeyEvent(KeyEvent.of(lastBinding));
            }
        } else if (operation == 0x1000001) {
            this.mouseEvent();
        } else {
            this.dispatchKeyEvent(KeyEvent.of(operation));
        }
        return false;
    }

    private void dispatchKeyEvent(KeyEvent event) {
        log.debug("Dispatch key event: {}", (Object)event);
        this.eventLoop.dispatch(ShellMessageBuilder.ofKeyEvent(event));
    }

    private void dispatchMouse(MouseEvent event) {
        log.debug("Dispatch mouse event: {}", (Object)event);
        this.eventLoop.dispatch(ShellMessageBuilder.ofMouseEvent(event));
    }

    private void mouseEvent() {
        this.dispatchMouse(MouseEvent.of(this.terminal.readMouseEvent()));
    }
}

