/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jline.terminal.Terminal;
import org.springframework.shell.component.view.TerminalUI;
import org.springframework.shell.component.view.TerminalUICustomizer;
import org.springframework.shell.style.ThemeResolver;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class TerminalUIBuilder {
    private final Terminal terminal;
    private final Set<TerminalUICustomizer> customizers;
    private final ThemeResolver themeResolver;
    private final String themeName;

    public TerminalUIBuilder(Terminal terminal, TerminalUICustomizer ... customizers) {
        this.terminal = terminal;
        this.customizers = this.copiedSetOf(customizers);
        this.themeResolver = null;
        this.themeName = null;
    }

    public TerminalUIBuilder(Terminal terminal, Set<TerminalUICustomizer> customizers, ThemeResolver themeResolver, String themeName) {
        this.terminal = terminal;
        this.customizers = customizers;
        this.themeResolver = themeResolver;
        this.themeName = themeName;
    }

    public TerminalUIBuilder themeResolver(ThemeResolver themeResolver) {
        return new TerminalUIBuilder(this.terminal, this.customizers, themeResolver, this.themeName);
    }

    public TerminalUIBuilder themeName(String themeName) {
        return new TerminalUIBuilder(this.terminal, this.customizers, this.themeResolver, themeName);
    }

    public TerminalUIBuilder customizers(Collection<? extends TerminalUICustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers must not be null");
        return new TerminalUIBuilder(this.terminal, this.copiedSetOf(customizers), this.themeResolver, this.themeName);
    }

    public TerminalUI build() {
        return this.configure(new TerminalUI(this.terminal));
    }

    public <T extends TerminalUI> T configure(T terminalUI) {
        if (this.themeResolver != null) {
            terminalUI.setThemeResolver(this.themeResolver);
        }
        if (StringUtils.hasText((String)this.themeName)) {
            terminalUI.setThemeName(this.themeName);
        }
        if (!CollectionUtils.isEmpty(this.customizers)) {
            for (TerminalUICustomizer customizer : this.customizers) {
                customizer.customize(terminalUI);
            }
        }
        return terminalUI;
    }

    private <T> Set<T> copiedSetOf(T ... items) {
        return this.copiedSetOf((Collection<? extends T>)Arrays.asList(items));
    }

    private <T> Set<T> copiedSetOf(Collection<? extends T> collection) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(collection));
    }
}

