/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view.control;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.springframework.shell.component.message.ShellMessageBuilder;
import org.springframework.shell.component.view.control.BoxView;
import org.springframework.shell.component.view.control.GridView;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.control.ViewEvent;
import org.springframework.shell.component.view.control.ViewEventArgs;
import org.springframework.shell.component.view.event.KeyEvent;
import org.springframework.shell.component.view.event.KeyHandler;
import org.springframework.shell.component.view.event.MouseHandler;
import org.springframework.shell.component.view.screen.Screen;
import org.springframework.shell.geom.Rectangle;
import org.springframework.shell.style.ThemeResolver;
import org.springframework.util.Assert;

public class AppView
extends BoxView {
    private GridView grid;
    private View main;
    private View menu;
    private View status;
    private boolean menuVisible = true;
    private boolean statusVisible = true;

    public AppView(View main, View menuBar, View statusBar) {
        Assert.notNull((Object)main, (String)"Main view must be set");
        Assert.notNull((Object)menuBar, (String)"Menubar view must be set");
        Assert.notNull((Object)statusBar, (String)"Statusbar view must be set");
        this.main = main;
        this.menu = menuBar;
        this.status = statusBar;
        this.initLayout();
    }

    @Override
    public void setThemeName(String themeName) {
        super.setThemeName(themeName);
        this.main.setThemeName(themeName);
        this.menu.setThemeName(themeName);
        this.status.setThemeName(themeName);
    }

    @Override
    public void setThemeResolver(ThemeResolver themeResolver) {
        super.setThemeResolver(themeResolver);
        this.main.setThemeResolver(themeResolver);
        this.menu.setThemeResolver(themeResolver);
        this.status.setThemeResolver(themeResolver);
    }

    private void initLayout() {
        this.grid = new GridView();
        this.grid.setRowSize(1, 0, 1);
        this.grid.setColumnSize(0);
        this.grid.clearItems();
        if (this.menuVisible && this.statusVisible) {
            this.grid.addItem(this.menu, 0, 0, 1, 1, 0, 0);
            this.grid.addItem(this.main, 1, 0, 1, 1, 0, 0);
            this.grid.addItem(this.status, 2, 0, 1, 1, 0, 0);
        } else if (!this.menuVisible && !this.statusVisible) {
            this.grid.addItem(this.menu, 0, 0, 0, 0, 0, 0);
            this.grid.addItem(this.main, 0, 0, 3, 1, 0, 0);
            this.grid.addItem(this.status, 2, 0, 0, 0, 0, 0);
        } else if (this.menuVisible && !this.statusVisible) {
            this.grid.addItem(this.menu, 0, 0, 1, 1, 0, 0);
            this.grid.addItem(this.main, 1, 0, 2, 1, 0, 0);
            this.grid.addItem(this.status, 2, 0, 0, 1, 0, 0);
        } else if (!this.menuVisible && this.statusVisible) {
            this.grid.addItem(this.menu, 0, 0, 0, 1, 0, 0);
            this.grid.addItem(this.main, 0, 0, 2, 1, 0, 0);
            this.grid.addItem(this.status, 2, 0, 1, 1, 0, 0);
        }
    }

    @Override
    protected void drawInternal(Screen screen) {
        Rectangle rect = this.getInnerRect();
        if (this.grid != null) {
            this.grid.setRect(rect.x(), rect.y(), rect.width(), rect.height());
            this.grid.draw(screen);
        }
        super.drawInternal(screen);
    }

    @Override
    public MouseHandler getMouseHandler() {
        MouseHandler handler = this.grid.getMouseHandler();
        return handler.thenIfNotConsumed(super.getMouseHandler());
    }

    @Override
    public KeyHandler getKeyHandler() {
        KeyHandler handler = args -> {
            KeyEvent event = args.event();
            boolean consumed = false;
            if (event.isKey(0x100002)) {
                this.dispatch(ShellMessageBuilder.ofView(this, AppViewEvent.of(this, AppViewEventArgs.Direction.PREVIOUS)));
                consumed = true;
            } else if (event.isKey(0x100003)) {
                this.dispatch(ShellMessageBuilder.ofView(this, AppViewEvent.of(this, AppViewEventArgs.Direction.NEXT)));
                consumed = true;
            }
            return KeyHandler.resultOf(event, consumed, null);
        };
        if (this.menu != null && this.menu.hasFocus()) {
            return this.menu.getKeyHandler();
        }
        KeyHandler otherHandler = this.main != null ? this.main.getKeyHandler() : super.getKeyHandler();
        return otherHandler.thenIfNotConsumed(handler);
    }

    @Override
    public KeyHandler getHotKeyHandler() {
        KeyHandler mainHandler = this.main != null ? this.main.getHotKeyHandler() : super.getHotKeyHandler();
        KeyHandler menuHandler = this.menu != null ? this.menu.getHotKeyHandler() : super.getHotKeyHandler();
        KeyHandler statusHandler = this.status != null ? this.status.getHotKeyHandler() : super.getHotKeyHandler();
        return mainHandler.thenIfNotConsumed(menuHandler).thenIfNotConsumed(statusHandler);
    }

    @Override
    public boolean hasFocus() {
        if (this.grid != null) {
            return this.grid.hasFocus();
        }
        return super.hasFocus();
    }

    public void setMenuBarVisible(boolean visible) {
        this.menuVisible = visible;
        this.initLayout();
    }

    public void setStatusBarVisible(boolean visible) {
        this.statusVisible = visible;
        this.initLayout();
    }

    public void toggleMenuBarVisibility() {
        this.setMenuBarVisible(!this.menuVisible);
    }

    public void toggleStatusBarVisibility() {
        this.setStatusBarVisible(!this.statusVisible);
    }

    public record AppViewEventArgs(Direction direction) implements ViewEventArgs
    {
        public static AppViewEventArgs of(Direction direction) {
            return new AppViewEventArgs(direction);
        }

        public static enum Direction {
            PREVIOUS,
            NEXT;

        }
    }

    public static final class AppViewEvent
    extends Record
    implements ViewEvent {
        private final View view;
        private final AppViewEventArgs args;

        public AppViewEvent(View view, AppViewEventArgs args) {
            this.view = view;
            this.args = args;
        }

        public static AppViewEvent of(View view, AppViewEventArgs.Direction direction) {
            return new AppViewEvent(view, AppViewEventArgs.of(direction));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{AppViewEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AppViewEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AppViewEvent.class, "view;args", "view", "args"}, this, o);
        }

        @Override
        public View view() {
            return this.view;
        }

        @Override
        public AppViewEventArgs args() {
            return this.args;
        }
    }
}

