/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view.control;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.springframework.shell.component.message.ShellMessageBuilder;
import org.springframework.shell.component.view.control.BoxView;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.control.ViewEvent;
import org.springframework.shell.component.view.control.ViewEventArgs;
import org.springframework.shell.component.view.event.KeyHandler;
import org.springframework.shell.component.view.event.MouseEvent;
import org.springframework.shell.component.view.event.MouseHandler;
import org.springframework.shell.component.view.screen.Screen;
import org.springframework.shell.geom.Dimension;
import org.springframework.shell.geom.HorizontalAlign;
import org.springframework.shell.geom.Rectangle;
import org.springframework.shell.geom.VerticalAlign;

public class ButtonView
extends BoxView {
    private String text;
    private Runnable action;

    public ButtonView() {
        this(null, null);
    }

    public ButtonView(String text) {
        this(text, null);
    }

    public ButtonView(String text, Runnable action) {
        this.text = text;
        this.action = action;
    }

    @Override
    protected void initInternal() {
        this.registerKeyBinding((Integer)0x100004, () -> this.keySelect());
        this.registerMouseBinding((Integer)65, event -> this.mouseSelect((MouseEvent)event));
    }

    @Override
    public KeyHandler getKeyHandler() {
        return super.getKeyHandler();
    }

    @Override
    public MouseHandler getMouseHandler() {
        return super.getMouseHandler();
    }

    @Override
    protected String getBackgroundStyle() {
        return "style-button-background";
    }

    @Override
    protected void drawInternal(Screen screen) {
        Rectangle rect = this.getInnerRect();
        Screen.Writer writer = screen.writerBuilder().layer(this.getLayer()).build();
        if (this.text != null) {
            writer.border(rect.x(), rect.y(), rect.width(), rect.height());
            writer.text(this.text, rect, HorizontalAlign.CENTER, VerticalAlign.CENTER);
        }
        super.drawInternal(screen);
    }

    public Dimension getPreferredDimension() {
        return null;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAction(Runnable action) {
        this.action = action;
    }

    private void keySelect() {
        this.dispatch();
    }

    private void mouseSelect(MouseEvent event) {
        this.dispatch();
    }

    private void dispatch() {
        this.dispatch(ShellMessageBuilder.ofView(this, ButtonViewSelectEvent.of(this)));
        if (this.action != null) {
            this.dispatchRunnable(this.action);
        }
    }

    public static final class ButtonViewSelectEvent
    extends Record
    implements ViewEvent {
        private final View view;
        private final ButtonViewItemEventArgs args;

        public ButtonViewSelectEvent(View view, ButtonViewItemEventArgs args) {
            this.view = view;
            this.args = args;
        }

        public static ButtonViewSelectEvent of(View view) {
            return new ButtonViewSelectEvent(view, ButtonViewItemEventArgs.of());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ButtonViewSelectEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ButtonViewSelectEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ButtonViewSelectEvent.class, "view;args", "view", "args"}, this, o);
        }

        @Override
        public View view() {
            return this.view;
        }

        @Override
        public ButtonViewItemEventArgs args() {
            return this.args;
        }
    }

    public record ButtonViewItemEventArgs() implements ViewEventArgs
    {
        public static ButtonViewItemEventArgs of() {
            return new ButtonViewItemEventArgs();
        }
    }
}

