/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view.control;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.springframework.shell.component.message.ShellMessageBuilder;
import org.springframework.shell.component.view.control.ButtonView;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.control.ViewEvent;
import org.springframework.shell.component.view.control.ViewEventArgs;
import org.springframework.shell.component.view.control.ViewService;
import org.springframework.shell.component.view.control.WindowView;
import org.springframework.shell.component.view.event.EventLoop;
import org.springframework.shell.component.view.event.MouseHandler;
import org.springframework.shell.component.view.screen.Screen;
import org.springframework.shell.geom.Rectangle;

public class DialogView
extends WindowView {
    private View content;
    private List<ButtonView> buttons;

    public DialogView() {
        this(null, new ButtonView[0]);
    }

    public DialogView(View content, ButtonView ... buttons) {
        this(content, Arrays.asList(buttons));
    }

    public DialogView(View content, List<ButtonView> buttons) {
        this.content = content;
        this.buttons = buttons;
    }

    @Override
    public void setEventLoop(EventLoop eventLoop) {
        super.setEventLoop(eventLoop);
        this.hookButtonEvents();
    }

    @Override
    protected String getBackgroundStyle() {
        return "style-dialog-background";
    }

    @Override
    public void setLayer(int index) {
        if (this.content != null) {
            this.content.setLayer(index);
        }
        this.buttons.forEach(b -> b.setLayer(index + 1));
        super.setLayer(index);
    }

    private void hookButtonEvents() {
        this.buttons.forEach(b -> this.onDestroy(this.getEventLoop().viewEvents(ButtonView.ButtonViewSelectEvent.class, (View)b).subscribe(event -> {
            this.dispatch();
            ViewService viewService = this.getViewService();
            if (viewService != null) {
                viewService.setModal(null);
            }
        })));
    }

    @Override
    public MouseHandler getMouseHandler() {
        return args -> {
            View focus = null;
            for (ButtonView b : this.buttons) {
                MouseHandler.MouseHandlerResult r = b.getMouseHandler().handle(args);
                if (r.focus() == null) continue;
                focus = r.focus();
                break;
            }
            return MouseHandler.resultOf(args.event(), true, focus, null);
        };
    }

    @Override
    public void setRect(int x, int y, int width, int height) {
        super.setRect(x, y, width, height);
        Rectangle rect = this.getInnerRect();
        rect = new Rectangle(rect.x() + 1, rect.y() + 1, rect.width() - 2, rect.height() - 2);
        if (this.content != null) {
            this.content.setRect(rect.x(), rect.y(), rect.width(), rect.height() - 3);
        }
        int xx = rect.x();
        ListIterator<ButtonView> iter = this.buttons.listIterator();
        while (iter.hasNext()) {
            ButtonView button = iter.next();
            button.setRect(xx, rect.y() + rect.height() - 3, 7, 3);
            xx += 7;
        }
    }

    @Override
    protected void drawInternal(Screen screen) {
        Rectangle rect = this.getInnerRect();
        Screen.Writer writer = screen.writerBuilder().layer(this.getLayer()).build();
        writer.border(rect.x(), rect.y(), rect.width(), rect.height());
        if (this.content != null) {
            this.content.draw(screen);
        }
        ListIterator<ButtonView> iter = this.buttons.listIterator();
        while (iter.hasNext()) {
            ButtonView button = iter.next();
            button.draw(screen);
        }
        super.drawInternal(screen);
    }

    private void dispatch() {
        this.dispatch(ShellMessageBuilder.ofView(this, DialogViewCloseEvent.of(this)));
    }

    public static final class DialogViewCloseEvent
    extends Record
    implements ViewEvent {
        private final View view;
        private final DialogViewItemEventArgs args;

        public DialogViewCloseEvent(View view, DialogViewItemEventArgs args) {
            this.view = view;
            this.args = args;
        }

        public static DialogViewCloseEvent of(View view) {
            return new DialogViewCloseEvent(view, DialogViewItemEventArgs.of());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DialogViewCloseEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DialogViewCloseEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DialogViewCloseEvent.class, "view;args", "view", "args"}, this, o);
        }

        @Override
        public View view() {
            return this.view;
        }

        @Override
        public DialogViewItemEventArgs args() {
            return this.args;
        }
    }

    public record DialogViewItemEventArgs() implements ViewEventArgs
    {
        public static DialogViewItemEventArgs of() {
            return new DialogViewItemEventArgs();
        }
    }
}

