/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.component.view.control.BoxView;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.control.ViewCommand;
import org.springframework.shell.component.view.event.KeyHandler;
import org.springframework.shell.component.view.event.MouseHandler;
import org.springframework.shell.component.view.screen.Screen;
import org.springframework.shell.geom.Rectangle;
import org.springframework.util.Assert;

public class GridView
extends BoxView {
    private static final Logger log = LoggerFactory.getLogger(GridView.class);
    private List<GridItem> gridItems = new ArrayList<GridItem>();
    private int[] columnSize;
    private int[] rowSize;
    private int minWidth;
    private int minHeight;
    private int gapRows;
    private int gapColumns;
    private int rowOffset;
    private int columnOffset;
    private boolean showBorders;

    public GridView setColumnSize(int ... columns) {
        this.columnSize = columns;
        return this;
    }

    public GridView setRowSize(int ... rows) {
        this.rowSize = rows;
        return this;
    }

    public GridView setMinSize(int minWidth, int minHeight) {
        Assert.state((minWidth > -1 || minHeight > -1 ? 1 : 0) != 0, (String)"Minimum sizes for rows or colums cannot be negative");
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        return this;
    }

    public GridView addItem(View view, int row, int column, int rowSpan, int colSpan, int minGridHeight, int minGridWidth) {
        GridItem gridItem = new GridItem(view, row, column, colSpan, rowSpan, minGridHeight, minGridWidth, false);
        this.gridItems.add(gridItem);
        return this;
    }

    public void clearItems() {
        this.gridItems.clear();
    }

    public void setShowBorders(boolean showBorders) {
        this.showBorders = showBorders;
    }

    public boolean isShowBorders() {
        return this.showBorders;
    }

    @Override
    public MouseHandler getMouseHandler() {
        log.trace("getMouseHandler()");
        return args -> {
            View focus = null;
            for (GridItem i : this.gridItems) {
                MouseHandler.MouseHandlerResult r = i.view.getMouseHandler().handle(args);
                if (r.focus() == null) continue;
                focus = r.focus();
                break;
            }
            return MouseHandler.resultOf(args.event(), true, focus, null);
        };
    }

    private void nextView() {
        View toFocus = null;
        boolean found = false;
        for (GridItem i : this.gridItems) {
            if (!i.visible) continue;
            if (toFocus == null) {
                toFocus = i.view;
            }
            if (found) {
                toFocus = i.view;
                break;
            }
            if (!i.view.hasFocus()) continue;
            found = true;
        }
        if (toFocus != null) {
            this.getViewService().setFocus(toFocus);
        }
    }

    @Override
    protected void initInternal() {
        this.registerViewCommand(ViewCommand.NEXT_VIEW, () -> this.nextView());
        this.registerKeyBinding((Integer)0x100007, ViewCommand.NEXT_VIEW);
    }

    @Override
    public KeyHandler getKeyHandler() {
        log.trace("getKeyHandler()");
        KeyHandler handler = null;
        for (GridItem i : this.gridItems) {
            if (!i.view.hasFocus()) continue;
            handler = i.view.getKeyHandler();
            break;
        }
        if (handler != null) {
            return handler.thenIfNotConsumed(super.getKeyHandler());
        }
        return super.getKeyHandler();
    }

    @Override
    public KeyHandler getHotKeyHandler() {
        log.trace("getHotKeyHandler()");
        KeyHandler handler = null;
        for (GridItem i : this.gridItems) {
            if (handler == null) {
                handler = i.view.getHotKeyHandler();
                continue;
            }
            handler = handler.thenIfNotConsumed(i.view.getHotKeyHandler());
        }
        if (handler != null) {
            return handler.thenIfNotConsumed(super.getHotKeyHandler());
        }
        return super.getHotKeyHandler();
    }

    @Override
    public boolean hasFocus() {
        for (GridItem i : this.gridItems) {
            if (!i.view.hasFocus()) continue;
            return true;
        }
        return super.hasFocus();
    }

    @Override
    protected void drawInternal(Screen screen) {
        int pos;
        int index;
        int index2;
        int gap;
        int index3;
        int column;
        int row;
        int index4;
        super.drawInternal(screen);
        Rectangle rect = this.getInnerRect();
        int x = rect.x();
        int y = rect.y();
        int width = rect.width();
        int height = rect.height();
        HashMap<View, GridItem> items = new HashMap<View, GridItem>();
        for (GridItem item : this.gridItems) {
            Object previousItem;
            item.visible = false;
            if (item.width <= 0 || item.height <= 0 || width < item.minGridWidth || height < item.minGridHeight || (previousItem = (GridItem)items.get(item.view)) != null && item.minGridWidth < ((GridItem)previousItem).minGridWidth && item.minGridHeight < ((GridItem)previousItem).minGridHeight) continue;
            items.put(item.view, item);
        }
        int rows = this.rowSize.length;
        int columns = this.columnSize.length;
        for (GridItem item : items.values()) {
            int columnEnd;
            int rowEnd = item.row + item.height;
            if (rowEnd > rows) {
                rows = rowEnd;
            }
            if ((columnEnd = item.column + item.width) <= columns) continue;
            columns = columnEnd;
        }
        if (rows == 0 || columns == 0) {
            return;
        }
        int[] rowPos = new int[rows];
        int[] rowHeight = new int[rows];
        int[] columnPos = new int[columns];
        int[] columnWidth = new int[columns];
        int remainingWidth = width;
        int remainingHeight = height;
        int proportionalWidth = 0;
        int proportionalHeight = 0;
        for (index4 = 0; index4 < this.rowSize.length; ++index4) {
            row = this.rowSize[index4];
            if (row > 0) {
                if (row < this.minHeight) {
                    row = this.minHeight;
                }
                remainingHeight -= row;
                rowHeight[index4] = row;
                continue;
            }
            if (row == 0) {
                ++proportionalHeight;
                continue;
            }
            proportionalHeight += -row;
        }
        for (index4 = 0; index4 < this.columnSize.length; ++index4) {
            column = this.columnSize[index4];
            if (column > 0) {
                if (column < this.minWidth) {
                    column = this.minWidth;
                }
                remainingWidth -= column;
                columnWidth[index4] = column;
                continue;
            }
            if (column == 0) {
                ++proportionalWidth;
                continue;
            }
            proportionalWidth += -column;
        }
        if (this.isShowBorders()) {
            remainingHeight -= rows + 1;
            remainingWidth -= columns + 1;
        } else {
            remainingHeight -= (rows - 1) * this.gapRows;
            remainingWidth -= (columns - 1) * this.gapColumns;
        }
        if (rows > this.rowSize.length) {
            proportionalHeight += rows - this.rowSize.length;
        }
        if (columns > this.columnSize.length) {
            proportionalWidth += columns - this.columnSize.length;
        }
        for (index4 = 0; index4 < rows; ++index4) {
            row = 0;
            if (index4 < this.rowSize.length) {
                row = this.rowSize[index4];
            }
            if (row > 0) continue;
            row = row == 0 ? 1 : -row;
            int rowAbs = row * remainingHeight / proportionalHeight;
            remainingHeight -= rowAbs;
            proportionalHeight -= row;
            if (rowAbs < this.minHeight) {
                rowAbs = this.minHeight;
            }
            rowHeight[index4] = rowAbs;
        }
        for (index4 = 0; index4 < columns; ++index4) {
            column = 0;
            if (index4 < this.columnSize.length) {
                column = this.columnSize[index4];
            }
            if (column > 0) continue;
            column = column == 0 ? 1 : -column;
            int columnAbs = column * remainingWidth / proportionalWidth;
            remainingWidth -= columnAbs;
            proportionalWidth -= column;
            if (columnAbs < this.minWidth) {
                columnAbs = this.minWidth;
            }
            columnWidth[index4] = columnAbs;
        }
        int columnX = 0;
        int rowY = 0;
        if (this.isShowBorders()) {
            ++columnX;
            ++rowY;
        }
        for (index3 = 0; index3 < rowHeight.length; ++index3) {
            int row2 = rowHeight[index3];
            rowPos[index3] = rowY;
            gap = this.gapRows;
            if (this.isShowBorders()) {
                gap = 1;
            }
            rowY += row2 + gap;
        }
        for (index3 = 0; index3 < columnWidth.length; ++index3) {
            int column2 = columnWidth[index3];
            columnPos[index3] = columnX;
            gap = this.gapColumns;
            if (this.isShowBorders()) {
                gap = 1;
            }
            columnX += column2 + gap;
        }
        GridItem focus = null;
        for (Map.Entry entry : items.entrySet()) {
            int index5;
            View primitive = (View)entry.getKey();
            GridItem item = (GridItem)entry.getValue();
            int px = columnPos[item.column];
            int py = rowPos[item.row];
            int pw = 0;
            int ph = 0;
            for (index5 = 0; index5 < item.height; ++index5) {
                ph += rowHeight[item.row + index5];
            }
            for (index5 = 0; index5 < item.width; ++index5) {
                pw += columnWidth[item.column + index5];
            }
            if (this.isShowBorders()) {
                pw += item.width - 1;
                ph += item.height - 1;
            } else {
                pw += (item.width - 1) * this.gapColumns;
                ph += (item.height - 1) * this.gapRows;
            }
            item.x = px;
            item.y = py;
            item.w = pw;
            item.h = ph;
            item.visible = true;
            if (!primitive.hasFocus()) continue;
            focus = item;
        }
        int offsetX = 0;
        int offsetY = 0;
        int add = 1;
        if (!this.isShowBorders()) {
            add = this.gapRows;
        }
        for (index2 = 0; index2 < rowHeight.length; ++index2) {
            int height2 = rowHeight[index2];
            if (index2 >= this.rowOffset) break;
            offsetY += height2 + add;
        }
        if (!this.isShowBorders()) {
            add = this.gapColumns;
        }
        for (index2 = 0; index2 < columnWidth.length; ++index2) {
            int width2 = columnWidth[index2];
            if (index2 >= this.columnOffset) break;
            offsetX += width2 + add;
        }
        if (focus != null) {
            if (focus.y + focus.h - offsetY >= height) {
                offsetY = focus.y - height + focus.h;
            }
            if (focus.y - offsetY < 0) {
                offsetY = focus.y;
            }
            if (focus.x + focus.w - offsetX >= width) {
                offsetX = focus.x - width + focus.w;
            }
            if (focus.x - offsetX < 0) {
                offsetX = focus.x;
            }
        }
        int from = 0;
        int to = 0;
        for (index = 0; index < rowPos.length; ++index) {
            pos = rowPos[index];
            if (pos - offsetY < 0) {
                from = index + 1;
            }
            if (pos - offsetY >= height) continue;
            to = index;
        }
        if (this.rowOffset < from) {
            this.rowOffset = from;
        }
        if (this.rowOffset > to) {
            this.rowOffset = to;
        }
        from = 0;
        to = 0;
        for (index = 0; index < columnPos.length; ++index) {
            pos = columnPos[index];
            if (pos - offsetX < 0) {
                from = index + 1;
            }
            if (pos - offsetX >= width) continue;
            to = index;
        }
        if (this.columnOffset < from) {
            this.columnOffset = from;
        }
        if (this.columnOffset > to) {
            this.columnOffset = to;
        }
        for (Map.Entry entry : items.entrySet()) {
            View view = (View)entry.getKey();
            GridItem item = (GridItem)entry.getValue();
            if (!item.visible) continue;
            item.x -= offsetX;
            item.y -= offsetY;
            if (item.x >= width || item.x + item.w <= 0 || item.y >= height || item.y + item.h <= 0) {
                item.visible = false;
                continue;
            }
            if (item.x + item.w > width) {
                item.w = width - item.x;
            }
            if (item.y + item.h > height) {
                item.h = height - item.y;
            }
            if (item.x < 0) {
                item.w += item.x;
                item.x = 0;
            }
            if (item.y < 0) {
                item.h += item.y;
                item.y = 0;
            }
            if (item.w <= 0 || item.h <= 0) {
                item.visible = false;
                continue;
            }
            item.x += x;
            item.y += y;
            view.setRect(item.x, item.y, item.w, item.h);
            view.draw(screen);
            if (!this.isShowBorders()) continue;
            screen.writerBuilder().build().border(item.x - 1, item.y - 1, item.w + 2, item.h + 2);
        }
    }

    private static class GridItem {
        View view;
        int row;
        int column;
        int width;
        int height;
        int minGridHeight;
        int minGridWidth;
        boolean visible;
        int x;
        int y;
        int w;
        int h;

        GridItem(View view, int row, int column, int width, int height, int minGridHeight, int minGridWidth, boolean visible) {
            this.view = view;
            this.row = row;
            this.column = column;
            this.width = width;
            this.height = height;
            this.minGridHeight = minGridHeight;
            this.minGridWidth = minGridWidth;
            this.visible = visible;
        }
    }
}

