/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view.control;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.component.message.ShellMessageBuilder;
import org.springframework.shell.component.view.control.BoxView;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.control.ViewCommand;
import org.springframework.shell.component.view.control.ViewDoneEvent;
import org.springframework.shell.component.view.control.ViewEvent;
import org.springframework.shell.component.view.control.ViewEventArgs;
import org.springframework.shell.component.view.event.KeyEvent;
import org.springframework.shell.component.view.event.KeyHandler;
import org.springframework.shell.component.view.screen.Screen;
import org.springframework.shell.geom.Position;
import org.springframework.shell.geom.Rectangle;

public class InputView
extends BoxView {
    private final Logger log = LoggerFactory.getLogger(InputView.class);
    private final ArrayList<String> text = new ArrayList();
    private int cursorIndex = 0;

    @Override
    protected void initInternal() {
        this.registerViewCommand(ViewCommand.ACCEPT, () -> this.done());
        this.registerViewCommand(ViewCommand.LEFT, () -> this.left());
        this.registerViewCommand(ViewCommand.RIGHT, () -> this.right());
        this.registerViewCommand(ViewCommand.DELETE_CHAR_LEFT, () -> this.deleteCharLeft());
        this.registerViewCommand(ViewCommand.DELETE_CHAR_RIGHT, () -> this.deleteCharRight());
        this.registerKeyBinding((Integer)0x100004, ViewCommand.ACCEPT);
        this.registerKeyBinding((Integer)0x100002, ViewCommand.LEFT);
        this.registerKeyBinding((Integer)0x100003, ViewCommand.RIGHT);
        this.registerKeyBinding((Integer)0x100005, ViewCommand.DELETE_CHAR_LEFT);
        this.registerKeyBinding((Integer)0x100006, ViewCommand.DELETE_CHAR_RIGHT);
    }

    @Override
    public KeyHandler getKeyHandler() {
        this.log.trace("getKeyHandler()");
        KeyHandler handler = args -> {
            KeyEvent event = args.event();
            boolean consumed = false;
            if (event.isKey()) {
                consumed = true;
                int plainKey = event.getPlainKey();
                this.add(new String(new char[]{(char)plainKey}));
            } else if (event.isKey(0x1000002)) {
                this.add(event.data());
            }
            return KeyHandler.resultOf(event, consumed, null);
        };
        return handler.thenIfNotConsumed(super.getKeyHandler());
    }

    @Override
    protected void drawInternal(Screen screen) {
        Rectangle rect = this.getInnerRect();
        String s = this.getInputText();
        screen.writerBuilder().build().text(s, rect.x(), rect.y());
        if (this.hasFocus()) {
            screen.setShowCursor(true);
            int cPos = this.cursorPosition();
            screen.setCursorPosition(new Position(rect.x() + cPos, rect.y()));
        }
        super.drawInternal(screen);
    }

    public String getInputText() {
        return this.text.stream().collect(Collectors.joining());
    }

    private int cursorPosition() {
        return this.text.stream().limit(this.cursorIndex).mapToInt(text -> text.length()).sum();
    }

    private void dispatchTextChange(String oldText, String newText) {
        this.dispatch(ShellMessageBuilder.ofView(this, InputViewTextChangeEvent.of(this, oldText, newText)));
    }

    private void add(String data) {
        String oldText = this.text.stream().collect(Collectors.joining());
        this.text.add(this.cursorIndex, data);
        this.moveCursor(1);
        String newText = this.text.stream().collect(Collectors.joining());
        this.dispatchTextChange(oldText, newText);
    }

    private void deleteCharLeft() {
        if (this.cursorIndex > 0) {
            String oldText = this.text.stream().collect(Collectors.joining());
            this.text.remove(this.cursorIndex - 1);
            String newText = this.text.stream().collect(Collectors.joining());
            this.dispatchTextChange(oldText, newText);
        }
        this.left();
    }

    private void deleteCharRight() {
        if (this.cursorIndex < this.text.size()) {
            String oldText = this.text.stream().collect(Collectors.joining());
            this.text.remove(this.cursorIndex);
            String newText = this.text.stream().collect(Collectors.joining());
            this.dispatchTextChange(oldText, newText);
        }
    }

    private void moveCursor(int index) {
        int toIndex = this.cursorIndex + index;
        if (toIndex > -1 && toIndex <= this.text.size()) {
            this.cursorIndex = toIndex;
        }
    }

    private void left() {
        this.moveCursor(-1);
    }

    private void right() {
        this.moveCursor(1);
    }

    private void done() {
        this.dispatch(ShellMessageBuilder.ofView(this, ViewDoneEvent.of(this)));
    }

    public static final class InputViewTextChangeEvent
    extends Record
    implements ViewEvent {
        private final View view;
        private final InputViewTextChangeEventArgs args;

        public InputViewTextChangeEvent(View view, InputViewTextChangeEventArgs args) {
            this.view = view;
            this.args = args;
        }

        public static InputViewTextChangeEvent of(View view, String oldText, String newText) {
            return new InputViewTextChangeEvent(view, InputViewTextChangeEventArgs.of(oldText, newText));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{InputViewTextChangeEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InputViewTextChangeEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InputViewTextChangeEvent.class, "view;args", "view", "args"}, this, o);
        }

        @Override
        public View view() {
            return this.view;
        }

        @Override
        public InputViewTextChangeEventArgs args() {
            return this.args;
        }
    }

    public record InputViewTextChangeEventArgs(String oldText, String newText) implements ViewEventArgs
    {
        public static InputViewTextChangeEventArgs of(String oldText, String newText) {
            return new InputViewTextChangeEventArgs(oldText, newText);
        }
    }
}

