/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view.control;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.BiFunction;
import org.springframework.lang.Nullable;
import org.springframework.shell.component.message.ShellMessageBuilder;
import org.springframework.shell.component.view.control.BoxView;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.control.ViewCommand;
import org.springframework.shell.component.view.control.ViewEvent;
import org.springframework.shell.component.view.control.ViewEventArgs;
import org.springframework.shell.component.view.control.cell.ListCell;
import org.springframework.shell.component.view.event.MouseEvent;
import org.springframework.shell.component.view.screen.Screen;
import org.springframework.shell.geom.Rectangle;
import org.springframework.util.Assert;

public class ListView<T>
extends BoxView {
    private final List<T> items = new ArrayList<T>();
    private final List<ListCell<T>> cells = new ArrayList<ListCell<T>>();
    private final ItemStyle itemStyle;
    private int start = 0;
    private int pos = 0;
    private final Set<Integer> selected = new HashSet<Integer>();
    private BiFunction<ListView<T>, T, ListCell<T>> factory = (listView, item) -> ListCell.of(item, listView.getItemStyle());

    public ListView() {
        this.itemStyle = ItemStyle.NOCHECK;
    }

    public ListView(ItemStyle itemStyle) {
        Assert.notNull((Object)((Object)itemStyle), (String)"item style must be set");
        this.itemStyle = itemStyle;
        this.setItems(null);
    }

    public ListView(T[] items, ItemStyle itemStyle) {
        this(items != null ? Arrays.asList(items) : Collections.emptyList(), itemStyle);
    }

    public ListView(@Nullable List<T> items, ItemStyle itemStyle) {
        Assert.notNull((Object)((Object)itemStyle), (String)"item style must be set");
        this.itemStyle = itemStyle;
        this.setItems(items);
    }

    @Override
    protected void initInternal() {
        super.initInternal();
        this.registerViewCommand(ViewCommand.LINE_UP, () -> this.up());
        this.registerViewCommand(ViewCommand.LINE_DOWN, () -> this.down());
        this.registerKeyBinding((Integer)0x100000, ViewCommand.LINE_UP);
        this.registerKeyBinding((Integer)0x100001, ViewCommand.LINE_DOWN);
        this.registerKeyBinding((Integer)0x100004, () -> this.enter());
        this.registerKeyBinding((Integer)32, () -> this.space());
        this.registerMouseBinding((Integer)516, ViewCommand.LINE_UP);
        this.registerMouseBinding((Integer)1028, ViewCommand.LINE_DOWN);
        this.registerMouseBinding((Integer)65, event -> this.click((MouseEvent)event));
    }

    public ItemStyle getItemStyle() {
        return this.itemStyle;
    }

    private void updateCells() {
        this.cells.clear();
        for (T i : this.items) {
            ListCell<T> c = this.factory.apply(this, (ListView)i);
            c.setItemStyle(this.getItemStyle());
            this.cells.add(c);
        }
    }

    public void setItems(@Nullable List<T> items) {
        this.items.clear();
        if (items != null) {
            this.items.addAll(items);
        }
        if (this.items.isEmpty()) {
            this.start = -1;
            this.pos = -1;
        } else {
            this.start = 0;
            this.pos = 0;
        }
        this.updateCells();
    }

    private void updateSelectionStates() {
        int active = this.start + this.pos;
        if (this.itemStyle == ItemStyle.CHECKED) {
            boolean removed = this.selected.remove(active);
            if (!removed) {
                this.selected.add(active);
            }
        } else if (this.itemStyle == ItemStyle.RADIO) {
            this.selected.clear();
            this.selected.add(active);
        }
        ListIterator<ListCell<T>> iter = this.cells.listIterator();
        while (iter.hasNext()) {
            int index = iter.nextIndex();
            ListCell<T> c = iter.next();
            c.setSelected(this.selected.contains(index));
        }
    }

    @Override
    protected void drawInternal(Screen screen) {
        if (this.start > -1 && this.pos > -1) {
            Rectangle rect = this.getInnerRect();
            int y = rect.y();
            int selectedStyle = this.resolveThemeStyle("style-highlight", 1);
            int selectedForegroundColor = this.resolveThemeForeground("style-highlight", -1, -1);
            int selectedBackgroundColor = this.resolveThemeBackground("style-highlight", -1, -1);
            int i = 0;
            for (ListCell<T> c : this.cells) {
                if (i < this.start) {
                    ++i;
                    continue;
                }
                c.setRect(rect.x(), y++, rect.width(), 1);
                if (i == this.start + this.pos) {
                    c.setForegroundColor(selectedForegroundColor);
                    c.setBackgroundColor(selectedBackgroundColor);
                    c.setStyle(selectedStyle);
                } else {
                    c.setBackgroundColor(-1);
                    c.setForegroundColor(-1);
                    c.setStyle(-1);
                }
                c.draw(screen);
                if (++i - this.start < rect.height()) continue;
                break;
            }
        }
        super.drawInternal(screen);
    }

    public void setCellFactory(BiFunction<ListView<T>, T, ListCell<T>> factory) {
        Assert.notNull(factory, (String)"cell factory must be set");
        this.factory = factory;
    }

    private void scrollIndex(boolean up) {
        int size = this.items.size();
        int maxItems = this.getInnerRect().height();
        int active = this.start + this.pos;
        if (up) {
            if (this.start > 0 && this.pos == 0) {
                --this.start;
            } else if (this.start + this.pos <= 0) {
                this.start = size - Math.min(maxItems, size);
                this.pos = Math.min(maxItems, size) - 1;
            } else {
                --this.pos;
            }
        } else if (this.start + this.pos + 1 < Math.min(maxItems, size)) {
            ++this.pos;
        } else if (this.start + this.pos + 1 >= size) {
            this.start = 0;
            this.pos = 0;
        } else {
            ++this.start;
        }
        if (active != this.start + this.pos) {
            this.dispatch(ShellMessageBuilder.ofView(this, ListViewSelectedItemChangedEvent.of(this, this.selectedItem())));
        }
    }

    private void scrollIndex(int step) {
        block4: {
            block3: {
                if (this.start < 0 && this.pos < 0) {
                    return;
                }
                if (step >= 0) break block3;
                for (int i = step; i < 0; ++i) {
                    this.scrollIndex(true);
                }
                break block4;
            }
            if (step <= 0) break block4;
            for (int i = step; i > 0; --i) {
                this.scrollIndex(false);
            }
        }
    }

    private T selectedItem() {
        T selectedItem = null;
        int active = this.start + this.pos;
        if (active >= 0 && active < this.items.size()) {
            selectedItem = this.items.get(active);
        }
        return selectedItem;
    }

    private void up() {
        this.scrollIndex(-1);
    }

    private void down() {
        this.scrollIndex(1);
    }

    private void enter() {
        if (this.itemStyle == ItemStyle.NOCHECK) {
            this.dispatch(ShellMessageBuilder.ofView(this, ListViewOpenSelectedItemEvent.of(this, this.selectedItem())));
            return;
        }
    }

    private void space() {
        this.updateSelectionStates();
    }

    private void click(MouseEvent event) {
        int index = event.y() - this.getInnerRect().y();
        int active = this.start + index;
        if (active >= 0 && active < this.items.size()) {
            this.pos = index;
            if (this.itemStyle == ItemStyle.NOCHECK) {
                this.dispatch(ShellMessageBuilder.ofView(this, ListViewSelectedItemChangedEvent.of(this, this.selectedItem())));
                return;
            }
        }
        this.updateSelectionStates();
    }

    public static enum ItemStyle {
        NOCHECK,
        CHECKED,
        RADIO;

    }

    public static final class ListViewSelectedItemChangedEvent<T>
    extends Record
    implements ViewEvent {
        private final View view;
        private final ListViewItemEventArgs<T> args;

        public ListViewSelectedItemChangedEvent(View view, ListViewItemEventArgs<T> args) {
            this.view = view;
            this.args = args;
        }

        public static <T> ListViewSelectedItemChangedEvent<T> of(View view, T item) {
            return new ListViewSelectedItemChangedEvent<T>(view, ListViewItemEventArgs.of(item));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ListViewSelectedItemChangedEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ListViewSelectedItemChangedEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ListViewSelectedItemChangedEvent.class, "view;args", "view", "args"}, this, o);
        }

        @Override
        public View view() {
            return this.view;
        }

        @Override
        public ListViewItemEventArgs<T> args() {
            return this.args;
        }
    }

    public static final class ListViewOpenSelectedItemEvent<T>
    extends Record
    implements ViewEvent {
        private final View view;
        private final ListViewItemEventArgs<T> args;

        public ListViewOpenSelectedItemEvent(View view, ListViewItemEventArgs<T> args) {
            this.view = view;
            this.args = args;
        }

        public static <T> ListViewOpenSelectedItemEvent<T> of(View view, T item) {
            return new ListViewOpenSelectedItemEvent<T>(view, ListViewItemEventArgs.of(item));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ListViewOpenSelectedItemEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ListViewOpenSelectedItemEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ListViewOpenSelectedItemEvent.class, "view;args", "view", "args"}, this, o);
        }

        @Override
        public View view() {
            return this.view;
        }

        @Override
        public ListViewItemEventArgs<T> args() {
            return this.args;
        }
    }

    public record ListViewItemEventArgs<T>(T item) implements ViewEventArgs
    {
        public static <T> ListViewItemEventArgs<T> of(T item) {
            return new ListViewItemEventArgs<T>(item);
        }
    }
}

