/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view.control;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.shell.component.message.ShellMessageBuilder;
import org.springframework.shell.component.message.StaticShellMessageHeaderAccessor;
import org.springframework.shell.component.view.control.BoxView;
import org.springframework.shell.component.view.control.GridView;
import org.springframework.shell.component.view.control.Spinner;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.control.ViewEvent;
import org.springframework.shell.component.view.control.ViewEventArgs;
import org.springframework.shell.component.view.control.cell.TextCell;
import org.springframework.shell.component.view.event.EventLoop;
import org.springframework.shell.component.view.screen.Screen;
import org.springframework.shell.geom.HorizontalAlign;
import org.springframework.shell.geom.Rectangle;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;

public class ProgressView
extends BoxView {
    private static final Logger log = LoggerFactory.getLogger(ProgressView.class);
    private final int tickStart;
    private final int tickEnd;
    private int tickValue;
    private boolean running = false;
    private String description;
    private Spinner spinner;
    private List<ProgressViewItem> items;
    private GridView grid;
    private long startTime;
    private long updateTime;
    private List<TextCell<ProgressContext>> cells = new ArrayList<TextCell<ProgressContext>>();
    private static final Function<ProgressContext, TextCell<ProgressContext>> DEFAULT_DESCRIPTION_FACTORY = item -> TextCell.of(item, ctx -> ctx.getDescription());
    private static final Function<ProgressContext, TextCell<ProgressContext>> DEFAULT_PERCENT_FACTORY = item -> {
        TextCell<ProgressContext> cell = TextCell.of(item, ctx -> {
            ProgressState state = ctx.getState();
            int percentAbs = state.tickEnd() - state.tickStart();
            int relativeValue = state.tickValue() - state.tickStart();
            int percent = relativeValue * 100 / percentAbs;
            return String.format("%s%%", percent);
        });
        return cell;
    };
    private static final Function<ProgressContext, TextCell<ProgressContext>> DEFAULT_SPINNER_FACTORY = item -> {
        TextCell<ProgressContext> cell = TextCell.of(item, ctx -> {
            int frame = 0;
            Spinner spin = ctx.resolveThemeSpinner("dot", ctx.getSpinner(), Spinner.of(Spinner.LINE1, 130));
            if (ctx.getState().running()) {
                int interval = spin.getInterval();
                long startTime = ctx.getState().startTime();
                long updateTime = ctx.getState().updateTime();
                long elapsedTime = updateTime - startTime;
                long elapsedFrame = elapsedTime / (long)interval;
                frame = (int)elapsedFrame % spin.getFrames().length;
                log.debug("Calculate frame {} {} {}", new Object[]{interval, elapsedTime, elapsedFrame});
            }
            log.debug("Drawing frame {}", (Object)frame);
            return String.format("%s", spin.getFrames()[frame]);
        });
        return cell;
    };
    private Disposable.Composite disposables;
    private final String TAG_KEY = "ProgressView";
    private final String TAG_VALUE = UUID.randomUUID().toString();

    public ProgressView() {
        this(0, 100);
    }

    public ProgressView(int tickStart, int tickEnd) {
        this(tickStart, tickEnd, ProgressViewItem.ofText(), ProgressViewItem.ofSpinner(), ProgressViewItem.ofPercent());
    }

    public ProgressView(ProgressViewItem ... items) {
        this(0, 100, items);
    }

    public ProgressView(int tickStart, int tickEnd, ProgressViewItem ... items) {
        Assert.isTrue((tickStart >= 0 ? 1 : 0) != 0, (String)"Start tick value must be greater or equal than zero");
        Assert.isTrue((tickEnd > 0 ? 1 : 0) != 0, (String)"End tick value must be greater than zero");
        Assert.isTrue((tickEnd > tickStart ? 1 : 0) != 0, (String)"End tick value must be greater than start tick value");
        this.tickStart = tickStart;
        this.tickEnd = tickEnd;
        this.tickValue = tickStart;
        this.items = Arrays.asList(items);
        this.initLayout();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSpinner(Spinner spinner) {
        this.spinner = spinner;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.startTime = System.currentTimeMillis();
        ProgressState state = this.getState();
        this.scheduleTicks();
        this.dispatch(ShellMessageBuilder.ofView(this, ProgressViewStartEvent.of(this, state)));
    }

    private void scheduleTicks() {
        if (this.disposables != null) {
            return;
        }
        EventLoop eventLoop = this.getEventLoop();
        if (eventLoop == null) {
            return;
        }
        Flux ticks = Flux.interval((Duration)Duration.ofMillis(50L)).map(l -> {
            Message message = MessageBuilder.withPayload((Object)l).setHeader("eventType", (Object)EventLoop.Type.USER).setHeader("ProgressView", (Object)this.TAG_VALUE).build();
            return message;
        });
        Disposable ticksDisposable = ticks.subscribe(m -> eventLoop.dispatch((Message<?>)m));
        Disposable eventsDisposable = eventLoop.events().filter(m -> EventLoop.Type.USER.equals((Object)StaticShellMessageHeaderAccessor.getEventType(m))).filter(m -> ObjectUtils.nullSafeEquals((Object)m.getHeaders().get((Object)"ProgressView"), (Object)this.TAG_VALUE)).subscribe(m -> this.requestRedraw());
        this.disposables = Disposables.composite();
        this.disposables.add(eventsDisposable);
        this.disposables.add(ticksDisposable);
    }

    private void requestRedraw() {
        EventLoop eventLoop = this.getEventLoop();
        if (eventLoop != null) {
            eventLoop.dispatch(ShellMessageBuilder.ofRedraw());
        }
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        if (this.disposables != null) {
            this.disposables.dispose();
            this.disposables = null;
        }
        this.running = false;
        ProgressState state = this.getState();
        this.dispatch(ShellMessageBuilder.ofView(this, ProgressViewEndEvent.of(this, state)));
    }

    private void initLayout() {
        this.grid = new GridView();
        int[] columnSizes = new int[this.items.size()];
        int index = 0;
        for (ProgressViewItem item : this.items) {
            columnSizes[index] = item.size;
            TextCell<ProgressContext> cell = item.factory.apply(this.buildContext());
            this.cells.add(cell);
            cell.setHorizontalAlign(item.align);
            this.grid.addItem(new BoxWrapper(cell), 0, index, 1, 1, 0, 0);
            ++index;
        }
        this.grid.setRowSize(0);
        this.grid.setColumnSize(columnSizes);
    }

    @Override
    protected void drawInternal(Screen screen) {
        long current;
        this.updateTime = current = System.currentTimeMillis();
        ProgressContext context = this.buildContext();
        for (TextCell<ProgressContext> cell : this.cells) {
            cell.setItem(context);
        }
        Rectangle rect = this.getRect();
        this.grid.setRect(rect.x(), rect.y(), rect.width(), rect.height());
        this.grid.draw(screen);
        super.drawInternal(screen);
    }

    public void tickAdvance(int count) {
        this.setTickValue(this.tickValue + count);
    }

    public void setTickValue(int value) {
        boolean changed = false;
        if (value > this.tickEnd) {
            changed = this.tickValue != this.tickEnd;
            this.tickValue = this.tickEnd;
        } else if (value < this.tickStart) {
            changed = this.tickValue != this.tickStart;
            this.tickValue = this.tickStart;
        } else {
            changed = this.tickValue != value;
            this.tickValue = value;
        }
        if (changed) {
            ProgressState state = this.getState();
            this.dispatch(ShellMessageBuilder.ofView(this, ProgressViewStateChangeEvent.of(this, state)));
            this.requestRedraw();
        }
    }

    public ProgressState getState() {
        return ProgressState.of(this.tickStart, this.tickEnd, this.tickValue, this.running, this.startTime, this.updateTime);
    }

    private ProgressContext buildContext() {
        return new ProgressContext(){

            @Override
            public String getDescription() {
                return ProgressView.this.getDescription();
            }

            @Override
            public ProgressState getState() {
                return ProgressView.this.getState();
            }

            @Override
            public ProgressView getView() {
                return ProgressView.this;
            }

            @Override
            public int resolveThemeStyle(String tag, int defaultStyle) {
                return ProgressView.this.resolveThemeStyle(tag, defaultStyle);
            }

            @Override
            public Spinner resolveThemeSpinner(String tag, Spinner defaultSpinner, Spinner fallbackSpinner) {
                return ProgressView.this.resolveThemeSpinner(tag, defaultSpinner, fallbackSpinner);
            }

            @Override
            public Spinner getSpinner() {
                return ProgressView.this.spinner;
            }
        };
    }

    public static class ProgressViewItem {
        private final Function<ProgressContext, TextCell<ProgressContext>> factory;
        private final int size;
        private final HorizontalAlign align;

        public ProgressViewItem(Function<ProgressContext, TextCell<ProgressContext>> factory, int size, HorizontalAlign align) {
            this.factory = factory;
            this.size = size;
            this.align = align;
        }

        public static ProgressViewItem ofText() {
            return ProgressViewItem.ofText(0, HorizontalAlign.CENTER);
        }

        public static ProgressViewItem ofText(int size, HorizontalAlign hAligh) {
            return new ProgressViewItem(DEFAULT_DESCRIPTION_FACTORY, size, hAligh);
        }

        public static ProgressViewItem ofSpinner() {
            return ProgressViewItem.ofSpinner(0, HorizontalAlign.CENTER);
        }

        public static ProgressViewItem ofSpinner(int size, HorizontalAlign hAligh) {
            return new ProgressViewItem(DEFAULT_SPINNER_FACTORY, size, hAligh);
        }

        public static ProgressViewItem ofPercent() {
            return ProgressViewItem.ofPercent(0, HorizontalAlign.CENTER);
        }

        public static ProgressViewItem ofPercent(int size, HorizontalAlign hAligh) {
            return new ProgressViewItem(DEFAULT_PERCENT_FACTORY, size, hAligh);
        }
    }

    public record ProgressState(int tickStart, int tickEnd, int tickValue, boolean running, long startTime, long updateTime) {
        public static ProgressState of(int tickStart, int tickEnd, int tickValue, boolean running, long startTime, long updateTime) {
            return new ProgressState(tickStart, tickEnd, tickValue, running, startTime, updateTime);
        }
    }

    public static final class ProgressViewStartEvent
    extends Record
    implements ViewEvent {
        private final View view;
        private final ProgressViewStateEventArgs args;

        public ProgressViewStartEvent(View view, ProgressViewStateEventArgs args) {
            this.view = view;
            this.args = args;
        }

        public static ProgressViewStartEvent of(View view, ProgressState state) {
            return new ProgressViewStartEvent(view, ProgressViewStateEventArgs.of(state));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ProgressViewStartEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ProgressViewStartEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ProgressViewStartEvent.class, "view;args", "view", "args"}, this, o);
        }

        @Override
        public View view() {
            return this.view;
        }

        @Override
        public ProgressViewStateEventArgs args() {
            return this.args;
        }
    }

    public static final class ProgressViewEndEvent
    extends Record
    implements ViewEvent {
        private final View view;
        private final ProgressViewStateEventArgs args;

        public ProgressViewEndEvent(View view, ProgressViewStateEventArgs args) {
            this.view = view;
            this.args = args;
        }

        public static ProgressViewEndEvent of(View view, ProgressState state) {
            return new ProgressViewEndEvent(view, ProgressViewStateEventArgs.of(state));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ProgressViewEndEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ProgressViewEndEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ProgressViewEndEvent.class, "view;args", "view", "args"}, this, o);
        }

        @Override
        public View view() {
            return this.view;
        }

        @Override
        public ProgressViewStateEventArgs args() {
            return this.args;
        }
    }

    public static interface ProgressContext {
        public String getDescription();

        public ProgressState getState();

        public ProgressView getView();

        public Spinner getSpinner();

        public int resolveThemeStyle(String var1, int var2);

        public Spinner resolveThemeSpinner(String var1, Spinner var2, Spinner var3);
    }

    private static class BoxWrapper
    extends BoxView {
        TextCell<ProgressContext> delegate;

        BoxWrapper(TextCell<ProgressContext> delegate) {
            this.delegate = delegate;
        }

        @Override
        protected void drawInternal(Screen screen) {
            Rectangle rect = this.getRect();
            this.delegate.setRect(rect.x(), rect.y(), rect.width(), rect.height());
            this.delegate.draw(screen);
            super.drawInternal(screen);
        }
    }

    public static final class ProgressViewStateChangeEvent
    extends Record
    implements ViewEvent {
        private final View view;
        private final ProgressViewStateEventArgs args;

        public ProgressViewStateChangeEvent(View view, ProgressViewStateEventArgs args) {
            this.view = view;
            this.args = args;
        }

        public static ProgressViewStateChangeEvent of(View view, ProgressState state) {
            return new ProgressViewStateChangeEvent(view, ProgressViewStateEventArgs.of(state));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ProgressViewStateChangeEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ProgressViewStateChangeEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ProgressViewStateChangeEvent.class, "view;args", "view", "args"}, this, o);
        }

        @Override
        public View view() {
            return this.view;
        }

        @Override
        public ProgressViewStateEventArgs args() {
            return this.args;
        }
    }

    public record ProgressViewStateEventArgs(ProgressState state) implements ViewEventArgs
    {
        public static ProgressViewStateEventArgs of(ProgressState state) {
            return new ProgressViewStateEventArgs(state);
        }
    }
}

