/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view.control;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.component.message.ShellMessageBuilder;
import org.springframework.shell.component.view.control.BoxView;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.control.ViewEvent;
import org.springframework.shell.component.view.control.ViewEventArgs;
import org.springframework.shell.component.view.event.MouseEvent;
import org.springframework.shell.component.view.event.MouseHandler;
import org.springframework.shell.component.view.screen.Screen;
import org.springframework.shell.geom.Rectangle;

public class StatusBarView
extends BoxView {
    private final Logger log = LoggerFactory.getLogger(StatusBarView.class);
    private final List<StatusItem> items = new ArrayList<StatusItem>();

    public StatusBarView() {
        this(new StatusItem[0]);
    }

    public StatusBarView(StatusItem[] items) {
        this(Arrays.asList(items));
    }

    public StatusBarView(List<StatusItem> items) {
        this.setItems(items);
    }

    @Override
    protected String getBackgroundStyle() {
        return "style-statusbar-background";
    }

    @Override
    protected void drawInternal(Screen screen) {
        Rectangle rect = this.getInnerRect();
        this.log.debug("Drawing status bar to {}", (Object)rect);
        Screen.Writer writer = screen.writerBuilder().build();
        int x = rect.x();
        ListIterator<StatusItem> iter = this.items.listIterator();
        while (iter.hasNext()) {
            StatusItem item = iter.next();
            String text = String.format(" %s%s", item.getTitle(), iter.hasNext() ? " |" : "");
            writer.text(text, x, rect.y());
            x += text.length();
        }
        super.drawInternal(screen);
    }

    @Override
    public MouseHandler getMouseHandler() {
        this.log.trace("getMouseHandler()");
        return args -> {
            MouseEvent event = args.event();
            boolean consumed = false;
            if (!event.hasModifier() && event.has(1) && event.has(64)) {
                int y;
                int x = event.x();
                StatusItem item = this.itemAt(x, y = event.y());
                if (item != null) {
                    this.dispatch(ShellMessageBuilder.ofView(this, StatusBarViewOpenSelectedItemEvent.of(this, item)));
                    if (item.getAction() != null) {
                        this.dispatchRunnable(item.getAction());
                    }
                }
                consumed = true;
            }
            return MouseHandler.resultOf(args.event(), consumed, null, null);
        };
    }

    private StatusItem itemAt(int x, int y) {
        Rectangle rect = this.getRect();
        if (!rect.contains(x, y)) {
            return null;
        }
        int ix = 0;
        for (StatusItem item : this.items) {
            if (x < ix + item.getTitle().length()) {
                return item;
            }
            ix += item.getTitle().length();
        }
        return null;
    }

    public void setItems(List<StatusItem> items) {
        this.items.clear();
        this.items.addAll(items);
        this.registerHotKeys();
    }

    public List<StatusItem> getItems() {
        return this.items;
    }

    private void registerHotKeys() {
        this.getItems().stream().filter(item -> item.getHotKey() != null).forEach(item -> {
            Runnable action = item.getAction();
            if (action != null) {
                this.registerHotKeyBinding(item.getHotKey(), action);
            }
        });
    }

    public static class StatusItem {
        private String title;
        private Runnable action;
        private Integer hotKey;

        public StatusItem(String title) {
            this(title, null);
        }

        public StatusItem(String title, Runnable action) {
            this(title, action, null);
        }

        public StatusItem(String title, Runnable action, Integer hotKey) {
            this.title = title;
            this.action = action;
            this.hotKey = hotKey;
        }

        public static StatusItem of(String title) {
            return new StatusItem(title);
        }

        public static StatusItem of(String title, Runnable action) {
            return new StatusItem(title, action);
        }

        public static StatusItem of(String title, Runnable action, Integer hotKey) {
            return new StatusItem(title, action, hotKey);
        }

        public String getTitle() {
            return this.title;
        }

        public Runnable getAction() {
            return this.action;
        }

        public StatusItem setAction(Runnable action) {
            this.action = action;
            return this;
        }

        public Integer getHotKey() {
            return this.hotKey;
        }

        public StatusItem setHotKey(Integer hotKey) {
            this.hotKey = hotKey;
            return this;
        }
    }

    public static final class StatusBarViewOpenSelectedItemEvent
    extends Record
    implements ViewEvent {
        private final View view;
        private final StatusBarViewItemEventArgs args;

        public StatusBarViewOpenSelectedItemEvent(View view, StatusBarViewItemEventArgs args) {
            this.view = view;
            this.args = args;
        }

        public static StatusBarViewOpenSelectedItemEvent of(View view, StatusItem item) {
            return new StatusBarViewOpenSelectedItemEvent(view, StatusBarViewItemEventArgs.of(item));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StatusBarViewOpenSelectedItemEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StatusBarViewOpenSelectedItemEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StatusBarViewOpenSelectedItemEvent.class, "view;args", "view", "args"}, this, o);
        }

        @Override
        public View view() {
            return this.view;
        }

        @Override
        public StatusBarViewItemEventArgs args() {
            return this.args;
        }
    }

    public record StatusBarViewItemEventArgs(StatusItem item) implements ViewEventArgs
    {
        public static StatusBarViewItemEventArgs of(StatusItem item) {
            return new StatusBarViewItemEventArgs(item);
        }
    }
}

