/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view.control;

import org.springframework.shell.component.view.control.AbstractView;
import org.springframework.shell.component.view.screen.Screen;
import org.springframework.shell.geom.Rectangle;

public class WindowView
extends AbstractView {
    private int backgroundColor = -1;
    private int minWidth = 30;
    private int maxWidth = 60;
    private int minHeight = 8;
    private int maxHeight = 12;

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    protected String getBackgroundStyle() {
        return "style-background";
    }

    @Override
    protected void drawInternal(Screen screen) {
        Rectangle rect = this.getInnerRect();
        int bgColor = this.resolveThemeBackground(this.getBackgroundStyle(), this.backgroundColor, -1);
        screen.writerBuilder().layer(this.getLayer()).build().background(rect, bgColor);
    }

    protected Rectangle getInnerRect() {
        int y;
        int h;
        int x;
        int w;
        Rectangle rect = this.getRect();
        if (rect.width() <= this.minWidth) {
            w = rect.width();
            x = rect.x();
        } else if (rect.width() >= this.maxWidth) {
            w = this.maxWidth;
            x = (rect.width() - w) / 2;
        } else {
            w = this.minWidth;
            x = (rect.width() - w) / 2;
        }
        if (rect.height() <= this.minHeight) {
            h = rect.height();
            y = rect.y();
        } else if (rect.height() >= this.maxHeight) {
            h = this.maxHeight;
            y = (rect.height() - h) / 2;
        } else {
            h = rect.height();
            y = (rect.height() - h) / 2;
        }
        rect = new Rectangle(x, y, w, h);
        return rect;
    }
}

