/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view.control.cell;

import org.springframework.shell.component.view.control.ListView;
import org.springframework.shell.component.view.control.cell.AbstractCell;
import org.springframework.shell.component.view.control.cell.ListCell;
import org.springframework.shell.component.view.screen.Screen;
import org.springframework.shell.geom.Rectangle;
import org.springframework.util.StringUtils;

public abstract class AbstractListCell<T>
extends AbstractCell<T>
implements ListCell<T> {
    private ListView.ItemStyle itemStyle;
    private boolean selected;

    public AbstractListCell(T item) {
        super(item);
    }

    public AbstractListCell(T item, ListView.ItemStyle itemStyle) {
        super(item);
        this.itemStyle = itemStyle;
    }

    protected String getText() {
        return this.getItem().toString();
    }

    protected String getIndicator() {
        if (this.getItemStyle() == ListView.ItemStyle.CHECKED || this.getItemStyle() == ListView.ItemStyle.RADIO) {
            return this.selected ? "[x]" : "[ ]";
        }
        return null;
    }

    protected String getBackgroundStyle() {
        return "style-background";
    }

    @Override
    protected void drawBackground(Screen screen) {
        Rectangle rect = this.getRect();
        int bgColor = this.resolveThemeBackground(this.getBackgroundStyle(), this.getBackgroundColor(), -1);
        if (bgColor > -1) {
            screen.writerBuilder().build().background(rect, bgColor);
        }
    }

    @Override
    protected void drawContent(Screen screen) {
        String indicator = this.getIndicator();
        String text = null;
        text = StringUtils.hasText((String)indicator) ? String.format("%s %s", indicator, this.getText()) : this.getText();
        Rectangle rect = this.getRect();
        Screen.Writer writer = screen.writerBuilder().style(this.getStyle()).color(this.getForegroundColor()).build();
        writer.text(text, rect.x(), rect.y());
    }

    @Override
    public void setItemStyle(ListView.ItemStyle itemStyle) {
        this.itemStyle = itemStyle;
    }

    public ListView.ItemStyle getItemStyle() {
        return this.itemStyle;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

