/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view.event;

import org.jline.terminal.MouseEvent;

public record MouseEvent(int x, int y, int mouse) {
    public static MouseEvent of(int x, int y, int mouse) {
        return new MouseEvent(x, y, mouse);
    }

    public static MouseEvent of(org.jline.terminal.MouseEvent event) {
        int type = switch (event.getType()) {
            case MouseEvent.Type.Released -> 1;
            case MouseEvent.Type.Pressed -> 2;
            case MouseEvent.Type.Wheel -> 4;
            case MouseEvent.Type.Moved -> 8;
            case MouseEvent.Type.Dragged -> 16;
            default -> 0;
        };
        int button = switch (event.getButton()) {
            case MouseEvent.Button.NoButton -> 32;
            case MouseEvent.Button.Button1 -> 64;
            case MouseEvent.Button.Button2 -> 128;
            case MouseEvent.Button.Button3 -> 256;
            case MouseEvent.Button.WheelUp -> 512;
            case MouseEvent.Button.WheelDown -> 1024;
            default -> 0;
        };
        int modifier = 0;
        if (event.getModifiers() != null) {
            if (event.getModifiers().contains(MouseEvent.Modifier.Shift)) {
                modifier |= 0x800;
            }
            if (event.getModifiers().contains(MouseEvent.Modifier.Alt)) {
                modifier |= 0x1000;
            }
            if (event.getModifiers().contains(MouseEvent.Modifier.Control)) {
                modifier |= 0x2000;
            }
        }
        return MouseEvent.of(event.getX(), event.getY(), type | button | modifier);
    }

    public boolean hasType() {
        return (this.mouse & 0x1F) != 0;
    }

    public boolean hasButton() {
        return (this.mouse & 0x7E0) != 0;
    }

    public boolean hasModifier() {
        return (this.mouse & 0x3800) != 0;
    }

    public boolean has(int mask) {
        return (this.mouse & mask) == mask;
    }

    public static class Type {
        public static final int Released = 1;
        public static final int Pressed = 2;
        public static final int Wheel = 4;
        public static final int Moved = 8;
        public static final int Dragged = 16;
    }

    public static class Button {
        public static final int NoButton = 32;
        public static final int Button1 = 64;
        public static final int Button2 = 128;
        public static final int Button3 = 256;
        public static final int WheelUp = 512;
        public static final int WheelDown = 1024;
    }

    public static class Modifier {
        public static final int Shift = 2048;
        public static final int Alt = 4096;
        public static final int Control = 8192;
    }

    public static class MouseMask {
        public static final int TypeMask = 31;
        public static final int ButtonMask = 2016;
        public static final int ModifierMask = 14336;
    }
}

