/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.view.event;

import java.util.function.Predicate;
import org.springframework.lang.Nullable;
import org.springframework.shell.component.view.control.View;
import org.springframework.shell.component.view.event.MouseEvent;

@FunctionalInterface
public interface MouseHandler {
    public MouseHandlerResult handle(MouseHandlerArgs var1);

    default public MouseHandler thenConditionally(MouseHandler other, Predicate<MouseHandlerResult> predicate) {
        return args -> {
            MouseHandlerResult result = this.handle(args);
            if (predicate.test(result)) {
                return other.handle(args);
            }
            return result;
        };
    }

    default public MouseHandler thenIfConsumed(MouseHandler other) {
        return this.thenConditionally(other, result -> result.consumed());
    }

    default public MouseHandler thenIfNotConsumed(MouseHandler other) {
        return this.thenConditionally(other, result -> !result.consumed());
    }

    public static MouseHandler neverConsume() {
        return args -> MouseHandler.resultOf(args.event(), false, null, null);
    }

    public static MouseHandlerArgs argsOf(MouseEvent event) {
        return new MouseHandlerArgs(event);
    }

    public static MouseHandlerResult resultOf(MouseEvent event, boolean consumed, View focus, View capture) {
        return new MouseHandlerResult(event, consumed, focus, capture);
    }

    public record MouseHandlerArgs(MouseEvent event) {
    }

    public record MouseHandlerResult(@Nullable MouseEvent event, boolean consumed, @Nullable View focus, @Nullable View capture) {
    }
}

