/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.springframework.shell.CompletingParsedLine;

public class ExtendedDefaultParser
implements Parser {
    private char[] quoteChars = new char[]{'\'', '\"'};
    private char[] escapeChars = new char[]{'\\'};
    private boolean eofOnUnclosedQuote;
    private boolean eofOnEscapedNewLine;

    public void setQuoteChars(char[] chars) {
        this.quoteChars = chars;
    }

    public char[] getQuoteChars() {
        return this.quoteChars;
    }

    public void setEscapeChars(char[] chars) {
        this.escapeChars = chars;
    }

    public char[] getEscapeChars() {
        return this.escapeChars;
    }

    public void setEofOnUnclosedQuote(boolean eofOnUnclosedQuote) {
        this.eofOnUnclosedQuote = eofOnUnclosedQuote;
    }

    public boolean isEofOnUnclosedQuote() {
        return this.eofOnUnclosedQuote;
    }

    public void setEofOnEscapedNewLine(boolean eofOnEscapedNewLine) {
        this.eofOnEscapedNewLine = eofOnEscapedNewLine;
    }

    public boolean isEofOnEscapedNewLine() {
        return this.eofOnEscapedNewLine;
    }

    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) {
        LinkedList<String> words = new LinkedList<String>();
        StringBuilder current = new StringBuilder();
        int wordCursor = -1;
        int wordIndex = -1;
        int quoteStart = -1;
        for (int i = 0; line != null && i < line.length(); ++i) {
            if (i == cursor) {
                wordIndex = words.size();
                wordCursor = current.length();
            }
            if (quoteStart < 0 && this.isQuoteChar(line, i)) {
                quoteStart = i;
                continue;
            }
            if (quoteStart >= 0) {
                if (line.charAt(quoteStart) == line.charAt(i) && !this.isEscaped(line, i)) {
                    words.add(current.toString());
                    current.setLength(0);
                    quoteStart = -1;
                    continue;
                }
                if (this.isEscapeChar(line, i)) continue;
                current.append(line.charAt(i));
                continue;
            }
            if (this.isDelimiter(line, i)) {
                if (current.length() <= 0) continue;
                words.add(current.toString());
                current.setLength(0);
                continue;
            }
            if (this.isEscapeChar(line, i)) continue;
            current.append(line.charAt(i));
        }
        if (current.length() > 0 || line != null && cursor == line.length()) {
            words.add(current.toString());
        }
        if (line != null && cursor == line.length()) {
            wordIndex = words.size() - 1;
            wordCursor = ((String)words.get(words.size() - 1)).length();
        }
        if (this.eofOnEscapedNewLine && line != null && this.isEscapeChar(line, line.length() - 1)) {
            throw new EOFError(-1, -1, "Escaped new line", "newline");
        }
        if (this.eofOnUnclosedQuote && quoteStart >= 0 && context != Parser.ParseContext.COMPLETE) {
            throw new EOFError(-1, -1, "Missing closing quote", line != null && line.charAt(quoteStart) == '\'' ? "quote" : "dquote");
        }
        String openingQuote = quoteStart >= 0 && line != null ? line.substring(quoteStart, quoteStart + 1) : null;
        return ExtendedDefaultParser.wrap(new ExtendedArgumentList(line, words, wordIndex, wordCursor, cursor, openingQuote));
    }

    public boolean isDelimiter(CharSequence buffer, int pos) {
        return !this.isQuoted(buffer, pos) && !this.isEscaped(buffer, pos) && this.isDelimiterChar(buffer, pos);
    }

    public boolean isQuoted(CharSequence buffer, int pos) {
        return false;
    }

    public boolean isQuoteChar(CharSequence buffer, int pos) {
        if (pos < 0) {
            return false;
        }
        for (int i = 0; this.quoteChars != null && i < this.quoteChars.length; ++i) {
            if (buffer.charAt(pos) != this.quoteChars[i]) continue;
            return !this.isEscaped(buffer, pos);
        }
        return false;
    }

    public boolean isEscapeChar(CharSequence buffer, int pos) {
        if (pos < 0) {
            return false;
        }
        for (int i = 0; this.escapeChars != null && i < this.escapeChars.length; ++i) {
            if (buffer.charAt(pos) != this.escapeChars[i]) continue;
            return !this.isEscaped(buffer, pos);
        }
        return false;
    }

    public boolean isEscaped(CharSequence buffer, int pos) {
        if (pos <= 0) {
            return false;
        }
        return this.isEscapeChar(buffer, pos - 1);
    }

    public boolean isDelimiterChar(CharSequence buffer, int pos) {
        return Character.isWhitespace(buffer.charAt(pos));
    }

    private boolean isRawEscapeChar(char key) {
        for (char e : this.escapeChars) {
            if (e != key) continue;
            return true;
        }
        return false;
    }

    private boolean isRawQuoteChar(char key) {
        for (char e : this.quoteChars) {
            if (e != key) continue;
            return true;
        }
        return false;
    }

    private static org.jline.reader.CompletingParsedLine wrap(final ParsedLine line) {
        if (line instanceof org.jline.reader.CompletingParsedLine) {
            return (org.jline.reader.CompletingParsedLine)line;
        }
        return new org.jline.reader.CompletingParsedLine(){

            public String word() {
                return line.word();
            }

            public int wordCursor() {
                return line.wordCursor();
            }

            public int wordIndex() {
                return line.wordIndex();
            }

            public List<String> words() {
                return line.words();
            }

            public String line() {
                return line.line();
            }

            public int cursor() {
                return line.cursor();
            }

            public CharSequence escape(CharSequence candidate, boolean complete) {
                return candidate;
            }

            public int rawWordCursor() {
                return this.wordCursor();
            }

            public int rawWordLength() {
                return this.word().length();
            }
        };
    }

    public class ExtendedArgumentList
    implements ParsedLine,
    CompletingParsedLine {
        private final String line;
        private final List<String> words;
        private final int wordIndex;
        private final int wordCursor;
        private final int cursor;
        private final String openingQuote;

        public ExtendedArgumentList(String line, List<String> words, int wordIndex, int wordCursor, int cursor, String openingQuote) {
            this.line = line;
            this.words = Collections.unmodifiableList(Objects.requireNonNull(words));
            this.wordIndex = wordIndex;
            this.wordCursor = wordCursor;
            this.cursor = cursor;
            this.openingQuote = openingQuote;
        }

        public int wordIndex() {
            return this.wordIndex;
        }

        public String word() {
            if (this.wordIndex < 0 || this.wordIndex >= this.words.size()) {
                return "";
            }
            return this.words.get(this.wordIndex);
        }

        public int wordCursor() {
            return this.wordCursor;
        }

        public List<String> words() {
            return this.words;
        }

        public int cursor() {
            return this.cursor;
        }

        public String line() {
            return this.line;
        }

        @Override
        public CharSequence emit(CharSequence candidate) {
            StringBuilder sb = new StringBuilder(candidate);
            Predicate<Integer> needToBeEscaped = this.openingQuote != null ? i -> ExtendedDefaultParser.this.isRawEscapeChar(sb.charAt((int)i)) || String.valueOf(sb.charAt((int)i)).equals(this.openingQuote) : i -> ExtendedDefaultParser.this.isDelimiterChar(sb, (int)i) || ExtendedDefaultParser.this.isRawEscapeChar(sb.charAt((int)i)) || ExtendedDefaultParser.this.isRawQuoteChar(sb.charAt((int)i));
            for (int i2 = 0; i2 < sb.length(); ++i2) {
                if (!needToBeEscaped.test(i2)) continue;
                sb.insert(i2++, ExtendedDefaultParser.this.escapeChars[0]);
            }
            if (this.openingQuote != null) {
                sb.append(this.openingQuote);
            }
            return sb;
        }
    }
}

