/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.UserInterruptException;
import org.jline.utils.AttributedString;
import org.springframework.core.annotation.Order;
import org.springframework.shell.ExitRequest;
import org.springframework.shell.Input;
import org.springframework.shell.InputProvider;
import org.springframework.shell.Shell;
import org.springframework.shell.ShellRunner;
import org.springframework.shell.context.InteractionMode;
import org.springframework.shell.context.ShellContext;
import org.springframework.shell.jline.ParsedLineInput;
import org.springframework.shell.jline.PromptProvider;

@Order(value=0)
public class InteractiveShellRunner
implements ShellRunner {
    public static final int PRECEDENCE = 0;
    private final LineReader lineReader;
    private final PromptProvider promptProvider;
    private final Shell shell;
    private final ShellContext shellContext;

    public InteractiveShellRunner(LineReader lineReader, PromptProvider promptProvider, Shell shell, ShellContext shellContext) {
        this.lineReader = lineReader;
        this.promptProvider = promptProvider;
        this.shell = shell;
        this.shellContext = shellContext;
    }

    @Override
    public boolean run(String[] args) throws Exception {
        this.shellContext.setInteractionMode(InteractionMode.INTERACTIVE);
        JLineInputProvider inputProvider = new JLineInputProvider(this.lineReader, this.promptProvider);
        this.shell.run(inputProvider);
        return true;
    }

    public static class JLineInputProvider
    implements InputProvider {
        private final LineReader lineReader;
        private final PromptProvider promptProvider;

        public JLineInputProvider(LineReader lineReader, PromptProvider promptProvider) {
            this.lineReader = lineReader;
            this.promptProvider = promptProvider;
        }

        @Override
        public Input readInput() {
            try {
                AttributedString prompt = this.promptProvider.getPrompt();
                this.lineReader.readLine(prompt.toAnsi(this.lineReader.getTerminal()));
            }
            catch (UserInterruptException e) {
                if (e.getPartialLine().isEmpty()) {
                    throw new ExitRequest(1);
                }
                return Input.EMPTY;
            }
            catch (EndOfFileException e) {
                throw new ExitRequest(1);
            }
            return new ParsedLineInput(this.lineReader.getParsedLine());
        }
    }
}

