/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import org.springframework.core.annotation.Order;
import org.springframework.shell.Input;
import org.springframework.shell.InputProvider;
import org.springframework.shell.Shell;
import org.springframework.shell.ShellRunner;
import org.springframework.shell.Utils;
import org.springframework.shell.context.InteractionMode;
import org.springframework.shell.context.ShellContext;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Order(value=-50)
public class NonInteractiveShellRunner
implements ShellRunner {
    public static final int PRECEDENCE = -50;
    private final Shell shell;
    private final ShellContext shellContext;
    private Parser lineParser;
    private String primaryCommand;
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private Function<String[], List<String>> commandsFromArgs = args -> {
        if (ObjectUtils.isEmpty((Object[])args)) {
            if (StringUtils.hasText((String)this.primaryCommand)) {
                Collections.singletonList(this.primaryCommand);
            } else {
                return Collections.emptyList();
            }
        }
        String raw = Arrays.stream(args).map(a -> {
            if (!NonInteractiveShellRunner.isQuoted(a) && StringUtils.containsWhitespace((String)a)) {
                return DOUBLE_QUOTE + a + DOUBLE_QUOTE;
            }
            return a;
        }).collect(Collectors.joining(" "));
        if (StringUtils.hasText((String)this.primaryCommand)) {
            return Collections.singletonList(this.primaryCommand + " " + raw);
        }
        return Collections.singletonList(raw);
    };

    private static boolean isQuoted(String str) {
        if (str == null) {
            return false;
        }
        return str.startsWith(SINGLE_QUOTE) && str.endsWith(SINGLE_QUOTE) || str.startsWith(DOUBLE_QUOTE) && str.endsWith(DOUBLE_QUOTE);
    }

    public NonInteractiveShellRunner(Shell shell, ShellContext shellContext) {
        this(shell, shellContext, null);
    }

    public NonInteractiveShellRunner(Shell shell, ShellContext shellContext, String primaryCommand) {
        this.shell = shell;
        this.shellContext = shellContext;
        this.primaryCommand = primaryCommand;
        this.lineParser = new DefaultParser();
    }

    public void setCommandsFromArgs(Function<String[], List<String>> commandsFromArgs) {
        this.commandsFromArgs = commandsFromArgs;
    }

    public void setLineParser(Parser lineParser) {
        this.lineParser = lineParser;
    }

    @Override
    public boolean run(String[] args) throws Exception {
        List<String> commands = this.commandsFromArgs.apply(args);
        if (commands.isEmpty()) {
            return false;
        }
        List<ParsedLine> parsedLines = commands.stream().map(rawCommandLine -> this.lineParser.parse(rawCommandLine, rawCommandLine.length() + 1)).collect(Collectors.toList());
        MultiParsedLineInputProvider inputProvider = new MultiParsedLineInputProvider(parsedLines);
        this.shellContext.setInteractionMode(InteractionMode.NONINTERACTIVE);
        this.shell.run(inputProvider);
        return true;
    }

    static class MultiParsedLineInputProvider
    implements InputProvider {
        private final List<ParsedLineInput> parsedLineInputs;
        private int inputIdx;

        MultiParsedLineInputProvider(List<ParsedLine> parsedLines) {
            this.parsedLineInputs = parsedLines.stream().map(ParsedLineInput::new).collect(Collectors.toList());
        }

        @Override
        public Input readInput() {
            if (this.inputIdx == this.parsedLineInputs.size()) {
                return null;
            }
            return this.parsedLineInputs.get(this.inputIdx++);
        }

        private static class ParsedLineInput
        implements Input {
            private final ParsedLine parsedLine;

            ParsedLineInput(ParsedLine parsedLine) {
                this.parsedLine = parsedLine;
            }

            @Override
            public String rawText() {
                return this.parsedLine.line();
            }

            @Override
            public List<String> words() {
                return Utils.sanitizeInput(this.parsedLine.words());
            }
        }
    }
}

