/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jline.reader.Parser;
import org.springframework.core.annotation.Order;
import org.springframework.shell.Shell;
import org.springframework.shell.ShellRunner;
import org.springframework.shell.jline.FileInputProvider;
import org.springframework.util.ObjectUtils;

@Order(value=-100)
public class ScriptShellRunner
implements ShellRunner {
    public static final int PRECEDENCE = -100;
    private final Parser parser;
    private final Shell shell;

    public ScriptShellRunner(Parser parser, Shell shell) {
        this.parser = parser;
        this.shell = shell;
    }

    @Override
    public boolean run(String[] args) throws Exception {
        Object[] sourceArgs = args;
        if (ObjectUtils.isEmpty((Object[])sourceArgs)) {
            return false;
        }
        if (!((String)sourceArgs[0]).startsWith("@") || ((String)sourceArgs[0]).length() <= 1) {
            return false;
        }
        List scriptsToRun = Arrays.asList(args).stream().filter(s -> s.startsWith("@")).map(s -> new File(s.substring(1))).collect(Collectors.toList());
        for (File file : scriptsToRun) {
            try (FileReader reader = new FileReader(file);
                 FileInputProvider inputProvider = new FileInputProvider(reader, this.parser);){
                this.shell.run(inputProvider);
            }
        }
        return true;
    }
}

