/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.result;

import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.shell.CommandNotFound;
import org.springframework.shell.result.CommandNotFoundMessageProvider;
import org.springframework.shell.result.TerminalAwareResultHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class CommandNotFoundResultHandler
extends TerminalAwareResultHandler<CommandNotFound> {
    private CommandNotFoundMessageProvider provider;

    public CommandNotFoundResultHandler(Terminal terminal, ObjectProvider<CommandNotFoundMessageProvider> provider) {
        super(terminal);
        Assert.notNull(provider, (String)"provider cannot be null");
        this.provider = (CommandNotFoundMessageProvider)provider.getIfAvailable(() -> new DefaultProvider());
    }

    @Override
    protected void doHandleResult(CommandNotFound result) {
        CommandNotFoundMessageProvider.ProviderContext context = CommandNotFoundMessageProvider.contextOf(result, result.getWords(), result.getRegistrations(), result.getText());
        String message = (String)this.provider.apply(context);
        if (StringUtils.hasText((String)message)) {
            this.terminal.writer().println(message);
        }
    }

    private static class DefaultProvider
    implements CommandNotFoundMessageProvider {
        private DefaultProvider() {
        }

        @Override
        public String apply(CommandNotFoundMessageProvider.ProviderContext context) {
            String message = new AttributedString((CharSequence)context.error().getMessage(), AttributedStyle.DEFAULT.foreground(1)).toAnsi();
            return message;
        }
    }
}

