/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.result;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.shell.command.CommandCatalog;
import org.springframework.shell.context.InteractionMode;
import org.springframework.shell.context.ShellContext;
import org.springframework.shell.jline.InteractiveShellRunner;
import org.springframework.shell.result.TerminalAwareResultHandler;
import org.springframework.util.StringUtils;

public class ThrowableResultHandler
extends TerminalAwareResultHandler<Throwable> {
    public static final String DETAILS_COMMAND_NAME = "stacktrace";
    private Throwable lastError;
    private CommandCatalog commandCatalog;
    private ObjectProvider<InteractiveShellRunner> interactiveRunner;
    private ShellContext shellContext;

    public ThrowableResultHandler(Terminal terminal, CommandCatalog commandCatalog, ShellContext shellContext, ObjectProvider<InteractiveShellRunner> interactiveRunner) {
        super(terminal);
        this.commandCatalog = commandCatalog;
        this.shellContext = shellContext;
        this.interactiveRunner = interactiveRunner;
    }

    @Override
    protected void doHandleResult(Throwable result) {
        String noteMsg;
        this.lastError = result;
        boolean shouldHandle = this.shouldHandle();
        if (shouldHandle) {
            String errorMsg = StringUtils.hasLength((String)result.getMessage()) ? result.getMessage() : result.toString();
            this.terminal.writer().println(new AttributedString((CharSequence)errorMsg, AttributedStyle.DEFAULT.foreground(1)).toAnsi());
            if (this.showShortError()) {
                noteMsg = new AttributedStringBuilder().append((CharSequence)"Details of the error have been omitted. You can use the ", AttributedStyle.DEFAULT.foreground(1)).append((CharSequence)DETAILS_COMMAND_NAME, AttributedStyle.DEFAULT.foreground(1).bold()).append((CharSequence)" command to print the full stacktrace.", AttributedStyle.DEFAULT.foreground(1)).toAnsi();
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                result.printStackTrace(pw);
                String stacktraceStr = sw.toString();
                noteMsg = new AttributedString((CharSequence)stacktraceStr, AttributedStyle.DEFAULT.foreground(1)).toAnsi();
            }
        } else {
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            if (result instanceof Error) {
                throw (Error)result;
            }
            throw new RuntimeException(result);
        }
        this.terminal.writer().println(noteMsg);
        this.terminal.writer().flush();
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    private boolean shouldHandle() {
        return this.interactiveRunner.getIfAvailable() != null;
    }

    private boolean showShortError() {
        return this.commandCatalog.getRegistrations().keySet().contains(DETAILS_COMMAND_NAME) && this.shellContext.getInteractionMode() == InteractionMode.INTERACTIVE;
    }
}

