/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.style;

import org.springframework.shell.component.view.control.Spinner;

public abstract class SpinnerSettings {
    public static final String TAG_LINE = "line";
    public static final String TAG_DOT = "dot";

    public Spinner line() {
        return Spinner.of(Spinner.LINE1, 130);
    }

    public Spinner dot() {
        return Spinner.of(Spinner.DOTS1, 80);
    }

    public Spinner resolveTag(String tag) {
        switch (tag) {
            case "line": {
                return this.line();
            }
            case "dot": {
                return this.dot();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown tag '%s'", tag));
    }

    public static String[] tags() {
        return new String[]{TAG_LINE, TAG_DOT};
    }

    public static SpinnerSettings defaults() {
        return new DefaultSpinnerSettings();
    }

    public static SpinnerSettings dump() {
        return new DumpSpinnerSettings();
    }

    private static class DefaultSpinnerSettings
    extends SpinnerSettings {
        private DefaultSpinnerSettings() {
        }
    }

    private static class DumpSpinnerSettings
    extends SpinnerSettings {
        private DumpSpinnerSettings() {
        }

        @Override
        public Spinner dot() {
            return Spinner.of(Spinner.DOTS14, 200);
        }
    }
}

