/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.style;

import java.util.Locale;
import java.util.stream.Stream;
import org.springframework.shell.style.ThemeResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.stringtemplate.v4.AttributeRenderer;

public class StringToStyleExpressionRenderer
implements AttributeRenderer<String> {
    private final ThemeResolver themeResolver;
    private static final String TRUNCATE = "truncate-";

    public StringToStyleExpressionRenderer(ThemeResolver themeResolver) {
        Assert.notNull((Object)themeResolver, (String)"themeResolver must be set");
        this.themeResolver = themeResolver;
    }

    public String toString(String value, String formatString, Locale locale) {
        if (!StringUtils.hasText((String)formatString)) {
            return value;
        }
        if (formatString.startsWith("style-")) {
            return String.format("@{%s %s}", this.themeResolver.resolveStyleTag(formatString), value);
        }
        if (formatString.startsWith(TRUNCATE)) {
            String f = formatString.substring(TRUNCATE.length());
            TruncateValues config = StringToStyleExpressionRenderer.mapValues(f);
            if (value.length() + config.prefix > config.width) {
                return String.format(locale, "%1." + (config.width - config.prefix - 2) + "s..", value);
            }
            return value;
        }
        return String.format(locale, formatString, value);
    }

    private static TruncateValues mapValues(String expression) {
        TruncateValues values = new TruncateValues();
        Stream.of(expression.split("-")).map(String::trim).forEach(v -> {
            String[] split = v.split(":", 2);
            if (split.length == 2) {
                if ("width".equals(split[0])) {
                    values.setWidth(Integer.parseInt(split[1]));
                } else if ("prefix".equals(split[0])) {
                    values.setPrefix(Integer.parseInt(split[1]));
                }
            }
        });
        return values;
    }

    private static class TruncateValues {
        Integer width;
        Integer prefix;

        private TruncateValues() {
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public void setPrefix(Integer prefix) {
            this.prefix = prefix;
        }
    }
}

