/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.style;

import java.util.Set;
import org.jline.style.MemoryStyleSource;
import org.jline.style.StyleExpression;
import org.jline.style.StyleResolver;
import org.jline.style.StyleSource;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Colors;
import org.springframework.shell.component.view.control.Spinner;
import org.springframework.shell.style.Theme;
import org.springframework.shell.style.ThemeRegistry;
import org.springframework.util.StringUtils;

public class ThemeResolver {
    private StyleSource styleSource = new MemoryStyleSource();
    private StyleResolver styleResolver = new StyleResolver(this.styleSource, "default");
    private StyleExpression styleExpression = new StyleExpression(this.styleResolver);
    private ThemeRegistry themeRegistry;
    private final Theme theme;
    private static final long F_FOREGROUND_IND = 256L;
    private static final long F_FOREGROUND_RGB = 512L;
    private static final long F_FOREGROUND = 768L;
    private static final long F_BACKGROUND_IND = 1024L;
    private static final long F_BACKGROUND_RGB = 2048L;
    private static final long F_BACKGROUND = 3072L;
    private static final int FG_COLOR_EXP = 15;
    private static final int BG_COLOR_EXP = 39;
    private static final long FG_COLOR = 549755781120L;
    private static final long BG_COLOR = 9223371487098961920L;

    public ThemeResolver(ThemeRegistry themeRegistry, String themeName) {
        this.themeRegistry = themeRegistry;
        this.theme = themeRegistry.get(themeName);
    }

    public ResolvedValues resolveValues(AttributedStyle attributedStyle) {
        boolean hasBg;
        boolean hasFb;
        long style = attributedStyle.getStyle();
        long s = style & 0xFFFFFFFFFFFFF0FFL;
        s &= 0x7FFFL;
        int fg = (int)((style & 0x7FFFFF8000L) >> 15);
        int bg = (int)((style & 0x7FFFFF8000000000L) >> 39);
        boolean bl = hasFb = (style & 0x100L) != 0L || (style & 0x200L) != 0L;
        if ((style & 0x100L) != 0L) {
            fg = Colors.DEFAULT_COLORS_256[fg & 0xFF];
        }
        boolean bl2 = hasBg = (style & 0x400L) != 0L || (style & 0x800L) != 0L;
        if ((style & 0x400L) != 0L) {
            bg = Colors.DEFAULT_COLORS_256[bg & 0xFF];
        }
        return new ResolvedValues((int)s, hasFb ? fg : -1, hasBg ? bg : -1);
    }

    public Set<String> themeNames() {
        return this.themeRegistry.getThemeNames();
    }

    public AttributedString evaluateExpression(String expression) {
        return this.styleExpression.evaluate(expression);
    }

    public String resolveStyleTag(String tag) {
        return this.theme.getSettings().styles().resolveTag(tag);
    }

    public String resolveStyleTag(String tag, String themeName) {
        Theme t = StringUtils.hasText((String)themeName) ? this.themeRegistry.get(themeName) : this.theme;
        return t.getSettings().styles().resolveTag(tag);
    }

    public String resolveFigureTag(String tag) {
        return this.theme.getSettings().figures().resolveTag(tag);
    }

    public Spinner resolveSpinnerTag(String tag) {
        return this.theme.getSettings().spinners().resolveTag(tag);
    }

    public AttributedStyle resolveStyle(String spec) {
        return this.styleResolver.resolve(spec);
    }

    public record ResolvedValues(int style, int foreground, int background) {
    }
}

