/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.support.search;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.springframework.shell.support.search.Normalize;
import org.springframework.shell.support.search.SearchMatchAlgorithm;
import org.springframework.util.StringUtils;

abstract class AbstractSearchMatchAlgorithm
implements SearchMatchAlgorithm {
    public static final int SCORE_MATCH = 16;
    public static final int SCORE_GAP_START = -3;
    public static final int SCORE_GAP_EXTENSION = -1;
    public static final int BONUS_BOUNDARY = 8;
    public static final int BONUS_NON_WORD = 8;
    public static final int BONUS_CAMEL123 = 7;
    public static final int BONUS_CONSECUTIVE = 4;
    public static final int BONUS_FIRST_CHAR_MULTIPLIER = 2;
    public static final int BONUS_BOUNDARY_WHITE = 10;
    public static final int BONUS_BOUNDARY_DELIMITER = 10;
    private static final String DELIMITER_CHARS = "/,:;|";

    AbstractSearchMatchAlgorithm() {
    }

    static int indexAt(int index, int max, boolean forward) {
        if (forward) {
            return index;
        }
        return max - index - 1;
    }

    static CharClass charClassOfAscii(char c) {
        if (c >= 'a' && c <= 'z') {
            return CharClass.LOWER;
        }
        if (c >= 'A' && c <= 'Z') {
            return CharClass.UPPER;
        }
        if (c >= '0' && c <= '9') {
            return CharClass.NUMBER;
        }
        if (Character.isWhitespace(c)) {
            return CharClass.WHITE;
        }
        if (DELIMITER_CHARS.indexOf(c) >= 0) {
            return CharClass.DELIMITER;
        }
        return CharClass.NONWORD;
    }

    static CharClass charClassOfNonAscii(char c) {
        if (Character.isLowerCase(c)) {
            return CharClass.LOWER;
        }
        if (Character.isUpperCase(c)) {
            return CharClass.UPPER;
        }
        if (Character.isDigit(c)) {
            return CharClass.NUMBER;
        }
        if (Character.isLetter(c)) {
            return CharClass.LETTER;
        }
        if (Character.isWhitespace(c)) {
            return CharClass.WHITE;
        }
        if (DELIMITER_CHARS.indexOf(c) >= 0) {
            return CharClass.DELIMITER;
        }
        return CharClass.NONWORD;
    }

    static int bonusFor(CharClass prevClass, CharClass clazz) {
        if (clazz.ordinal() > CharClass.NONWORD.ordinal()) {
            if (prevClass == CharClass.WHITE) {
                return 10;
            }
            if (prevClass == CharClass.DELIMITER) {
                return 10;
            }
            if (prevClass == CharClass.NONWORD) {
                return 8;
            }
        }
        if (prevClass == CharClass.LOWER && clazz == CharClass.UPPER || prevClass != CharClass.NUMBER && clazz == CharClass.NUMBER) {
            return 7;
        }
        if (clazz == CharClass.NONWORD) {
            return 8;
        }
        if (clazz == CharClass.WHITE) {
            return 10;
        }
        return 0;
    }

    static int bonusAt(String input, int idx) {
        if (idx == 0) {
            return 10;
        }
        return AbstractSearchMatchAlgorithm.bonusFor(AbstractSearchMatchAlgorithm.charClassOfAscii(input.charAt(idx - 1)), AbstractSearchMatchAlgorithm.charClassOfAscii(input.charAt(idx)));
    }

    static CalculateScore calculateScore(boolean caseSensitive, boolean normalize, String text, String pattern, int sidx, int eidx) {
        int pidx = 0;
        int score = 0;
        boolean inGap = false;
        int consecutive = 0;
        int firstBonus = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        CharClass prevClass = CharClass.WHITE;
        if (sidx > 0) {
            prevClass = AbstractSearchMatchAlgorithm.charClassOfAscii(text.charAt(sidx - 1));
        }
        for (int idx = sidx; idx < eidx; ++idx) {
            char c = text.charAt(idx);
            CharClass clazz = AbstractSearchMatchAlgorithm.charClassOfAscii(c);
            if (!caseSensitive && c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            if (normalize) {
                c = AbstractSearchMatchAlgorithm.normalizeRune(c);
            }
            if (c == pattern.charAt(pidx)) {
                positions.add(idx);
                score += 16;
                int bonus = AbstractSearchMatchAlgorithm.bonusFor(prevClass, clazz);
                if (consecutive == 0) {
                    firstBonus = bonus;
                } else {
                    if (bonus >= 8 && bonus > firstBonus) {
                        firstBonus = bonus;
                    }
                    bonus = Math.max(Math.max(bonus, firstBonus), 4);
                }
                score = pidx == 0 ? (score += bonus * 2) : (score += bonus);
                inGap = false;
                ++consecutive;
                ++pidx;
            } else {
                score = inGap ? --score : (score -= 3);
                inGap = true;
                consecutive = 0;
                firstBonus = 0;
            }
            prevClass = clazz;
        }
        return new CalculateScore(score, positions.stream().mapToInt(Integer::intValue).toArray());
    }

    static int trySkip(String input, boolean caseSensitive, char b, int from) {
        String byteArray = input.substring(from);
        int idx = byteArray.indexOf(b);
        if (idx == 0) {
            return from;
        }
        if (!caseSensitive && b >= 'a' && b <= 'z') {
            int uidx;
            if (idx > 0) {
                byteArray = byteArray.substring(idx);
            }
            if ((uidx = byteArray.indexOf(b - 32)) >= 0) {
                idx = uidx;
            }
        }
        if (idx < 0) {
            return -1;
        }
        return from + idx;
    }

    static int asciiFuzzyIndex(String input, String pattern, boolean caseSensitive) {
        if (!StringUtils.hasText((String)input)) {
            return 0;
        }
        if (!Charset.forName("US-ASCII").newEncoder().canEncode(input)) {
            return 0;
        }
        int firstIndex = 0;
        int idx = 0;
        for (int pidx = 0; pidx < pattern.length(); ++pidx) {
            idx = AbstractSearchMatchAlgorithm.trySkip(input, caseSensitive, pattern.charAt(pidx), idx);
            if (idx < 0) {
                return -1;
            }
            if (pidx == 0 && idx > 0) {
                firstIndex = idx - 1;
            }
            ++idx;
        }
        return firstIndex;
    }

    static char normalizeRune(char r) {
        if (r < '\u00c0' || r > '\u2184') {
            return r;
        }
        Character n = Normalize.normalized.get(Character.valueOf(r));
        if (n != null && n.charValue() > '\u0000') {
            return n.charValue();
        }
        return r;
    }

    static enum CharClass {
        WHITE,
        NONWORD,
        DELIMITER,
        LOWER,
        UPPER,
        LETTER,
        NUMBER;

    }

    static class CalculateScore {
        int score;
        int[] pos;

        CalculateScore(int score, int[] pos) {
            this.score = score;
            this.pos = pos;
        }
    }
}

