/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.support.search;

import org.springframework.shell.support.search.AbstractSearchMatchAlgorithm;
import org.springframework.shell.support.search.SearchMatchResult;
import org.springframework.util.StringUtils;

class ExactMatchNaiveSearchMatchAlgorithm
extends AbstractSearchMatchAlgorithm {
    ExactMatchNaiveSearchMatchAlgorithm() {
    }

    @Override
    public SearchMatchResult match(boolean caseSensitive, boolean normalize, boolean forward, String text, String pattern) {
        int lenPattern;
        if (!StringUtils.hasText((String)pattern)) {
            return SearchMatchResult.ofZeros();
        }
        int lenRunes = text.length();
        if (lenRunes < (lenPattern = pattern.length())) {
            return SearchMatchResult.ofMinus();
        }
        int pidx = 0;
        int bestPos = -1;
        int bonus = 0;
        int bestBonus = -1;
        for (int index = 0; index < lenRunes; ++index) {
            int pidx_;
            char pchar;
            int index_ = ExactMatchNaiveSearchMatchAlgorithm.indexAt(index, lenRunes, forward);
            char c = text.charAt(index_);
            if (!caseSensitive) {
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                if (normalize) {
                    c = ExactMatchNaiveSearchMatchAlgorithm.normalizeRune(c);
                }
            }
            if (c == (pchar = pattern.charAt(pidx_ = ExactMatchNaiveSearchMatchAlgorithm.indexAt(pidx, lenPattern, forward)))) {
                if (pidx_ == 0) {
                    bonus = ExactMatchNaiveSearchMatchAlgorithm.bonusAt(text, index_);
                }
                if (++pidx != lenPattern) continue;
                if (bonus > bestBonus) {
                    bestPos = index;
                    bestBonus = bonus;
                }
                if (bonus >= 8) break;
                index -= pidx - 1;
                pidx = 0;
                bonus = 0;
                continue;
            }
            index -= pidx;
            pidx = 0;
            bonus = 0;
        }
        if (bestPos >= 0) {
            int eidx;
            int sidx;
            if (forward) {
                sidx = bestPos - lenPattern + 1;
                eidx = bestPos + 1;
            } else {
                sidx = lenRunes - (bestPos + 1);
                eidx = lenRunes - (bestPos - lenPattern + 1);
            }
            AbstractSearchMatchAlgorithm.CalculateScore score = ExactMatchNaiveSearchMatchAlgorithm.calculateScore(caseSensitive, normalize, text, pattern, sidx, eidx);
            return SearchMatchResult.of(sidx, eidx, score.score, score.pos, this);
        }
        return SearchMatchResult.ofMinus();
    }
}

