/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect;

import org.springframework.social.connect.UserProfile;

public class UserProfileBuilder {
    private String id;
    private String name;
    private String firstName;
    private String lastName;
    private String email;
    private String username;
    private String[] EMPTY_FIRST_AND_LAST_NAME_ARRAY = new String[]{null, null};

    public UserProfileBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public UserProfileBuilder setName(String name) {
        this.name = name;
        String[] firstAndLastName = this.firstAndLastName(this.name);
        this.setFirstName(firstAndLastName[0]);
        this.setLastName(firstAndLastName[1]);
        return this;
    }

    public UserProfileBuilder setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public UserProfileBuilder setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public UserProfileBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public UserProfileBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public UserProfile build() {
        return new UserProfile(this.id, this.name, this.firstName, this.lastName, this.email, this.username);
    }

    private String[] firstAndLastName(String name) {
        if (name == null) {
            return this.EMPTY_FIRST_AND_LAST_NAME_ARRAY;
        }
        String[] nameParts = name.split("\\s+");
        if (nameParts.length == 1) {
            return new String[]{nameParts[0], null};
        }
        return new String[]{nameParts[0], nameParts[nameParts.length - 1]};
    }
}

