/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetFactory;
import javax.sql.rowset.RowSetProvider;
import org.springframework.core.JdkVersion;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.support.rowset.ResultSetWrappingSqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.util.ClassUtils;

public class SqlRowSetResultSetExtractor
implements ResultSetExtractor<SqlRowSet> {
    private static final CachedRowSetFactory cachedRowSetFactory = JdkVersion.getMajorJavaVersion() >= 4 ? new StandardCachedRowSetFactory() : new SunCachedRowSetFactory();

    @Override
    public SqlRowSet extractData(ResultSet rs) throws SQLException {
        return this.createSqlRowSet(rs);
    }

    protected SqlRowSet createSqlRowSet(ResultSet rs) throws SQLException {
        CachedRowSet rowSet = this.newCachedRowSet();
        rowSet.populate(rs);
        return new ResultSetWrappingSqlRowSet(rowSet);
    }

    protected CachedRowSet newCachedRowSet() throws SQLException {
        return cachedRowSetFactory.createCachedRowSet();
    }

    private static class SunCachedRowSetFactory
    implements CachedRowSetFactory {
        private static final Class<?> implementationClass;

        private SunCachedRowSetFactory() {
        }

        @Override
        public CachedRowSet createCachedRowSet() throws SQLException {
            try {
                return (CachedRowSet)implementationClass.newInstance();
            }
            catch (Throwable ex) {
                throw new IllegalStateException(ex);
            }
        }

        static {
            try {
                implementationClass = ClassUtils.forName((String)"com.sun.rowset.CachedRowSetImpl", (ClassLoader)SqlRowSetResultSetExtractor.class.getClassLoader());
            }
            catch (Throwable ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static class StandardCachedRowSetFactory
    implements CachedRowSetFactory {
        private final RowSetFactory rowSetFactory;

        public StandardCachedRowSetFactory() {
            try {
                this.rowSetFactory = RowSetProvider.newFactory();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Cannot create RowSetFactory through RowSetProvider", ex);
            }
        }

        @Override
        public CachedRowSet createCachedRowSet() throws SQLException {
            return this.rowSetFactory.createCachedRowSet();
        }
    }

    private static interface CachedRowSetFactory {
        public CachedRowSet createCachedRowSet() throws SQLException;
    }
}

