/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import org.springframework.lang.Nullable;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.support.DefaultTestContextBootstrapper;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.context.web.WebDelegatingSmartContextLoader;
import org.springframework.test.context.web.WebMergedContextConfiguration;

public class WebTestContextBootstrapper
extends DefaultTestContextBootstrapper {
    @Override
    protected Class<? extends ContextLoader> getDefaultContextLoaderClass(Class<?> testClass) {
        if (WebTestContextBootstrapper.getWebAppConfiguration(testClass) != null) {
            return WebDelegatingSmartContextLoader.class;
        }
        return super.getDefaultContextLoaderClass(testClass);
    }

    @Override
    protected MergedContextConfiguration processMergedContextConfiguration(MergedContextConfiguration mergedConfig) {
        WebAppConfiguration webAppConfiguration = WebTestContextBootstrapper.getWebAppConfiguration(mergedConfig.getTestClass());
        if (webAppConfiguration != null) {
            return new WebMergedContextConfiguration(mergedConfig, webAppConfiguration.value());
        }
        return mergedConfig;
    }

    @Nullable
    private static WebAppConfiguration getWebAppConfiguration(Class<?> testClass) {
        return TestContextAnnotationUtils.findMergedAnnotation(testClass, WebAppConfiguration.class);
    }
}

