/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.io.IOException;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.DefaultPropertySourceFactory;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceDescriptor;
import org.springframework.core.io.support.PropertySourceFactory;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.support.MergedTestPropertySources;
import org.springframework.test.context.support.TestPropertySourceAttributes;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class TestPropertySourceUtils {
    public static final String INLINED_PROPERTIES_PROPERTY_SOURCE_NAME = "Inlined Test Properties";
    private static final PropertySourceFactory defaultPropertySourceFactory = new DefaultPropertySourceFactory();
    private static final Comparator<MergedAnnotation<? extends Annotation>> reversedMetaDistance = Comparator.comparingInt(MergedAnnotation::getDistance).reversed();
    private static final Log logger = LogFactory.getLog(TestPropertySourceUtils.class);

    static MergedTestPropertySources buildMergedTestPropertySources(Class<?> testClass) {
        ArrayList<TestPropertySourceAttributes> attributesList = new ArrayList<TestPropertySourceAttributes>();
        TestPropertySourceAttributes previousAttributes = null;
        for (List<MergedAnnotation<TestPropertySource>> aggregatedAnnotations : TestPropertySourceUtils.findRepeatableAnnotations(testClass, TestPropertySource.class)) {
            List<TestPropertySourceAttributes> aggregatedAttributesList = aggregatedAnnotations.stream().map(TestPropertySourceAttributes::new).toList();
            TestPropertySourceAttributes mergedAttributes = TestPropertySourceUtils.mergeTestPropertySourceAttributes(aggregatedAttributesList);
            if (mergedAttributes == null) continue;
            if (!TestPropertySourceUtils.duplicationDetected(mergedAttributes, previousAttributes)) {
                attributesList.add(mergedAttributes);
            }
            previousAttributes = mergedAttributes;
        }
        if (attributesList.isEmpty()) {
            return MergedTestPropertySources.empty();
        }
        return new MergedTestPropertySources(TestPropertySourceUtils.mergeLocations(attributesList), TestPropertySourceUtils.mergeProperties(attributesList));
    }

    @Nullable
    private static TestPropertySourceAttributes mergeTestPropertySourceAttributes(List<TestPropertySourceAttributes> aggregatedAttributesList) {
        TestPropertySourceAttributes mergedAttributes = null;
        TestPropertySourceAttributes previousAttributes = null;
        for (TestPropertySourceAttributes currentAttributes : aggregatedAttributesList) {
            if (mergedAttributes == null) {
                mergedAttributes = currentAttributes;
            } else if (!TestPropertySourceUtils.duplicationDetected(currentAttributes, previousAttributes)) {
                mergedAttributes.mergeWith(currentAttributes);
            }
            previousAttributes = currentAttributes;
        }
        return mergedAttributes;
    }

    private static boolean duplicationDetected(TestPropertySourceAttributes currentAttributes, @Nullable TestPropertySourceAttributes previousAttributes) {
        boolean duplicationDetected;
        boolean bl = duplicationDetected = currentAttributes.equals(previousAttributes) && !currentAttributes.isEmpty();
        if (duplicationDetected && logger.isTraceEnabled()) {
            logger.trace((Object)String.format("Ignoring duplicate %s declaration on %s since it is also declared on %s", currentAttributes, currentAttributes.getDeclaringClass().getName(), previousAttributes.getDeclaringClass().getName()));
        }
        return duplicationDetected;
    }

    private static List<PropertySourceDescriptor> mergeLocations(List<TestPropertySourceAttributes> attributesList) {
        ArrayList<PropertySourceDescriptor> descriptors = new ArrayList<PropertySourceDescriptor>();
        for (TestPropertySourceAttributes attrs : attributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Processing locations for " + attrs));
            }
            descriptors.addAll(0, attrs.getPropertySourceDescriptors());
            if (attrs.isInheritLocations()) continue;
            break;
        }
        return descriptors;
    }

    private static String[] mergeProperties(List<TestPropertySourceAttributes> attributesList) {
        ArrayList<String> properties = new ArrayList<String>();
        for (TestPropertySourceAttributes attrs : attributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Processing inlined properties for " + attrs));
            }
            String[] attrProps = attrs.getProperties();
            properties.addAll(0, Arrays.asList(attrProps));
            if (attrs.isInheritProperties()) continue;
            break;
        }
        return StringUtils.toStringArray(properties);
    }

    public static void addPropertiesFilesToEnvironment(ConfigurableApplicationContext context, String ... locations) {
        Assert.notNull((Object)context, (String)"'context' must not be null");
        Assert.notNull((Object)locations, (String)"'locations' must not be null");
        TestPropertySourceUtils.addPropertiesFilesToEnvironment(context.getEnvironment(), (ResourceLoader)context, locations);
    }

    public static void addPropertiesFilesToEnvironment(ConfigurableEnvironment environment, ResourceLoader resourceLoader, String ... locations) {
        Assert.notNull((Object)locations, (String)"'locations' must not be null");
        TestPropertySourceUtils.addPropertySourcesToEnvironment(environment, resourceLoader, List.of(new PropertySourceDescriptor(locations)));
    }

    public static void addPropertySourcesToEnvironment(ConfigurableApplicationContext context, List<PropertySourceDescriptor> descriptors) {
        Assert.notNull((Object)context, (String)"'context' must not be null");
        Assert.notNull(descriptors, (String)"'descriptors' must not be null");
        TestPropertySourceUtils.addPropertySourcesToEnvironment(context.getEnvironment(), (ResourceLoader)context, descriptors);
    }

    public static void addPropertySourcesToEnvironment(ConfigurableEnvironment environment, ResourceLoader resourceLoader, List<PropertySourceDescriptor> descriptors) {
        Assert.notNull((Object)environment, (String)"'environment' must not be null");
        Assert.notNull((Object)resourceLoader, (String)"'resourceLoader' must not be null");
        Assert.notNull(descriptors, (String)"'descriptors' must not be null");
        ResourcePatternResolver resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        MutablePropertySources propertySources = environment.getPropertySources();
        try {
            for (PropertySourceDescriptor descriptor : descriptors) {
                if (descriptor.locations().isEmpty()) continue;
                Class factoryClass = descriptor.propertySourceFactory();
                PropertySourceFactory factory = factoryClass != null ? (PropertySourceFactory)BeanUtils.instantiateClass((Class)factoryClass) : defaultPropertySourceFactory;
                for (String location : descriptor.locations()) {
                    String resolvedLocation = environment.resolveRequiredPlaceholders(location);
                    for (Resource resource : resourcePatternResolver.getResources(resolvedLocation)) {
                        PropertySource propertySource = factory.createPropertySource(descriptor.name(), new EncodedResource(resource, descriptor.encoding()));
                        propertySources.addFirst(propertySource);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to add PropertySource to Environment", ex);
        }
    }

    public static void addInlinedPropertiesToEnvironment(ConfigurableApplicationContext context, String ... inlinedProperties) {
        Assert.notNull((Object)context, (String)"'context' must not be null");
        Assert.notNull((Object)inlinedProperties, (String)"'inlinedProperties' must not be null");
        TestPropertySourceUtils.addInlinedPropertiesToEnvironment(context.getEnvironment(), inlinedProperties);
    }

    public static void addInlinedPropertiesToEnvironment(ConfigurableEnvironment environment, String ... inlinedProperties) {
        Assert.notNull((Object)environment, (String)"'environment' must not be null");
        Assert.notNull((Object)inlinedProperties, (String)"'inlinedProperties' must not be null");
        if (!ObjectUtils.isEmpty((Object[])inlinedProperties)) {
            MapPropertySource ps;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Adding inlined properties to environment: " + ObjectUtils.nullSafeToString((Object[])inlinedProperties)));
            }
            if ((ps = (MapPropertySource)environment.getPropertySources().get(INLINED_PROPERTIES_PROPERTY_SOURCE_NAME)) == null) {
                ps = new MapPropertySource(INLINED_PROPERTIES_PROPERTY_SOURCE_NAME, new LinkedHashMap());
                environment.getPropertySources().addFirst((PropertySource)ps);
            }
            ((Map)ps.getSource()).putAll(TestPropertySourceUtils.convertInlinedPropertiesToMap(inlinedProperties));
        }
    }

    public static Map<String, Object> convertInlinedPropertiesToMap(String ... inlinedProperties) {
        Assert.notNull((Object)inlinedProperties, (String)"'inlinedProperties' must not be null");
        SequencedProperties sequencedProperties = new SequencedProperties();
        for (String input : inlinedProperties) {
            if (!StringUtils.hasText((String)input)) continue;
            try {
                sequencedProperties.load(new StringReader(input));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to load test environment properties from [" + input + "]", ex);
            }
        }
        return sequencedProperties.getSequencedMap();
    }

    private static <T extends Annotation> List<List<MergedAnnotation<T>>> findRepeatableAnnotations(Class<?> clazz, Class<T> annotationType) {
        ArrayList<List<MergedAnnotation<T>>> listOfLists = new ArrayList<List<MergedAnnotation<T>>>();
        TestPropertySourceUtils.findRepeatableAnnotations(clazz, annotationType, listOfLists, new int[]{0});
        return listOfLists;
    }

    private static <T extends Annotation> void findRepeatableAnnotations(Class<?> clazz, Class<T> annotationType, List<List<MergedAnnotation<T>>> listOfLists, int[] aggregateIndex) {
        if (listOfLists.size() < aggregateIndex[0] + 1) {
            listOfLists.add(new ArrayList());
        }
        MergedAnnotations.from(clazz, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.DIRECT).stream(annotationType).sorted(reversedMetaDistance).forEach(annotation -> ((List)listOfLists.get(aggregateIndex[0])).add(0, annotation));
        aggregateIndex[0] = aggregateIndex[0] + 1;
        for (Class<?> ifc : clazz.getInterfaces()) {
            TestPropertySourceUtils.findRepeatableAnnotations(ifc, annotationType, listOfLists, aggregateIndex);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null & superclass != Object.class) {
            TestPropertySourceUtils.findRepeatableAnnotations(superclass, annotationType, listOfLists, aggregateIndex);
        }
        if (TestContextAnnotationUtils.searchEnclosingClass(clazz)) {
            TestPropertySourceUtils.findRepeatableAnnotations(clazz.getEnclosingClass(), annotationType, listOfLists, aggregateIndex);
        }
    }

    private static class SequencedProperties
    extends Properties {
        private final LinkedHashMap<String, Object> map = new LinkedHashMap();

        private SequencedProperties() {
        }

        @Override
        public Object put(Object key, Object value) {
            if (key instanceof String) {
                String str = (String)key;
                return this.map.put(str, value);
            }
            return null;
        }

        public Map<String, Object> getSequencedMap() {
            return this.map;
        }
    }
}

