/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webjars.WebJarAssetLocator;

public class WebJarExtractor {
    public static final String PACKAGE_JSON = "package.json";
    public static final String BOWER_JSON = "bower.json";
    private static final String JAR_PATH_DELIMITER = "/";
    private static final Logger log = LoggerFactory.getLogger(WebJarExtractor.class);
    private final ClassLoader classLoader;

    public WebJarExtractor() {
        this(WebJarExtractor.class.getClassLoader());
    }

    public WebJarExtractor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void extractAllWebJarsTo(File to) throws IOException {
        this.extractWebJarsTo(null, null, to);
    }

    public void extractWebJarTo(String name, File to) throws IOException {
        this.extractWebJarsTo(name, null, to);
    }

    public void extractAllNodeModulesTo(File to) throws IOException {
        this.extractWebJarsTo(null, PACKAGE_JSON, to);
    }

    public void extractAllBowerComponentsTo(File to) throws IOException {
        this.extractWebJarsTo(null, BOWER_JSON, to);
    }

    private String getModuleId(String moduleNameFile) {
        String json;
        block29: {
            json = null;
            try (InputStream inputStream = this.classLoader.getResourceAsStream(moduleNameFile);){
                if (inputStream == null) break block29;
                try (Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name());){
                    json = scanner.useDelimiter("\\A").next();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (json != null) {
            try {
                return WebJarExtractor.getJsonModuleId(json);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private void extractResourcesTo(final String webJarName, final WebJarAssetLocator.WebJarInfo webJarInfo, String moduleFilePath, ResourceList webJarResources, final File to) {
        String maybeModuleId = moduleFilePath != null ? this.getModuleId(moduleFilePath) : null;
        final String webJarId = maybeModuleId != null ? maybeModuleId : webJarName;
        webJarResources.forEachInputStream(new ResourceList.InputStreamConsumer(){

            public void accept(Resource resource, InputStream inputStream) {
                String prefix = "META-INF/resources/webjars" + File.separator + webJarName + File.separator + (webJarInfo.version == null ? "" : webJarInfo.version + File.separator);
                if (resource.getPath().startsWith(prefix)) {
                    String newPath = resource.getPath().substring(prefix.length());
                    String relativeName = webJarId + File.separator + newPath;
                    File newFile = new File(to, relativeName);
                    if (!newFile.exists()) {
                        try {
                            newFile.getParentFile().mkdirs();
                            Files.copy(inputStream, newFile.toPath(), new CopyOption[0]);
                            inputStream.close();
                            Set resourcePerms = resource.getPosixFilePermissions();
                            if (resourcePerms != null) {
                                Files.setPosixFilePermissions(newFile.toPath(), resourcePerms);
                            }
                            if (resource.getLastModified() > 0L) {
                                newFile.setLastModified(resource.getLastModified());
                            }
                        }
                        catch (IOException e) {
                            log.error("Could not write file", (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    private void extractWebJarsTo(String name, String moduleNameFile, File to) {
        if (name == null) {
            ClassGraph classGraph = new ClassGraph().overrideClassLoaders(new ClassLoader[]{this.classLoader}).ignoreParentClassLoaders().whitelistPaths(new String[]{"META-INF/resources/webjars"});
            try (ScanResult scanResult = classGraph.scan();){
                Map<String, WebJarAssetLocator.WebJarInfo> allWebJars = WebJarAssetLocator.findWebJars(scanResult);
                WebJarAssetLocator webJarAssetLocator = new WebJarAssetLocator(allWebJars);
                for (String webJarName : allWebJars.keySet()) {
                    String moduleFilePath = webJarAssetLocator.getFullPathExact(webJarName, moduleNameFile);
                    WebJarAssetLocator.WebJarInfo webJarInfo = webJarAssetLocator.allWebJars.get(webJarName);
                    this.extractResourcesTo(webJarName, webJarInfo, moduleFilePath, WebJarAssetLocator.webJarResources(webJarName, scanResult.getAllResources()), to);
                }
            }
        }
        ClassGraph classGraph = new ClassGraph().overrideClassLoaders(new ClassLoader[]{this.classLoader}).ignoreParentClassLoaders().whitelistPaths(new String[]{"META-INF/resources/webjars/" + name + "/*"});
        try (ScanResult scanResult = classGraph.scan();){
            Map<String, WebJarAssetLocator.WebJarInfo> allWebJars = WebJarAssetLocator.findWebJars(scanResult);
            WebJarAssetLocator webJarAssetLocator = new WebJarAssetLocator(allWebJars);
            ResourceList webJarResources = scanResult.getAllResources();
            WebJarAssetLocator.WebJarInfo webJarInfo = allWebJars.get(name);
            String moduleFilePath = webJarAssetLocator.getFullPathExact(name, moduleNameFile);
            this.extractResourcesTo(name, webJarInfo, moduleFilePath, webJarResources, to);
        }
    }

    protected static String getJsonModuleId(String packageJson) throws IOException {
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createParser(packageJson);
        if (parser.nextToken() != JsonToken.START_OBJECT) {
            throw new IOException("package.json is not a valid JSON object");
        }
        String moduleId = null;
        while (!parser.isClosed()) {
            JsonToken jsonToken = parser.nextToken();
            String fieldName = parser.getCurrentName();
            if (!"name".equals(fieldName) || !parser.getParsingContext().getParent().inRoot()) continue;
            parser.nextToken();
            moduleId = parser.getText();
            parser.close();
        }
        return moduleId;
    }
}

