/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webjars.WebJarAssetLocator;

public class WebJarExtractor {
    public static final String PACKAGE_JSON = "package.json";
    public static final String BOWER_JSON = "bower.json";
    private static final String JAR_PATH_DELIMITER = "/";
    private static final Logger log = LoggerFactory.getLogger(WebJarExtractor.class);
    private final ClassLoader classLoader;

    public WebJarExtractor() {
        this(WebJarExtractor.class.getClassLoader());
    }

    public WebJarExtractor(@Nonnull ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader);
    }

    public void extractAllWebJarsTo(@Nullable File to) throws IOException {
        this.extractWebJarsTo(null, null, to);
    }

    public void extractWebJarTo(@Nullable String name, @Nullable File to) throws IOException {
        this.extractWebJarsTo(name, null, to);
    }

    public void extractAllNodeModulesTo(@Nullable File to) throws IOException {
        this.extractWebJarsTo(null, PACKAGE_JSON, to);
    }

    public void extractAllBowerComponentsTo(@Nullable File to) throws IOException {
        this.extractWebJarsTo(null, BOWER_JSON, to);
    }

    @Nullable
    private String getModuleId(@Nonnull String moduleNameFile) {
        String json;
        block16: {
            Objects.requireNonNull(moduleNameFile, "Module name file must not be null");
            json = null;
            try (InputStream inputStream = this.classLoader.getResourceAsStream(moduleNameFile);){
                if (inputStream == null) break block16;
                try (Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name());){
                    json = scanner.useDelimiter("\\A").next();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (json != null) {
            try {
                return WebJarExtractor.getJsonModuleId(json);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private void extractResourcesTo(@Nonnull String webJarName, @Nonnull WebJarAssetLocator.WebJarInfo webJarInfo, @Nullable String moduleFilePath, @Nonnull ResourceList webJarResources, @Nullable File to) {
        String maybeModuleId = moduleFilePath == null ? null : this.getModuleId(moduleFilePath);
        String webJarId = maybeModuleId == null ? webJarName : maybeModuleId;
        webJarResources.forEachInputStreamIgnoringIOException((resource, inputStream) -> WebJarExtractor.extractResource(webJarName, webJarInfo, to, webJarId, resource, inputStream));
    }

    private static void extractResource(@Nonnull String webJarName, @Nonnull WebJarAssetLocator.WebJarInfo webJarInfo, @Nullable File to, @Nonnull String webJarId, @Nonnull Resource resource, @Nonnull InputStream inputStream) {
        String newPath;
        String relativeName;
        File newFile;
        String prefix = String.format("%s%s%s%s%s", "META-INF/resources/webjars", JAR_PATH_DELIMITER, webJarName, JAR_PATH_DELIMITER, webJarInfo.getVersion() == null ? "" : String.format("%s%s", webJarInfo.getVersion(), JAR_PATH_DELIMITER));
        if (resource.getPath().startsWith(prefix) && !(newFile = new File(to, relativeName = String.format("%s%s%s", webJarId, File.separator, newPath = resource.getPath().substring(prefix.length())))).exists()) {
            try {
                boolean lastModifiedSet;
                newFile.getParentFile().mkdirs();
                Files.copy(inputStream, newFile.toPath(), new CopyOption[0]);
                inputStream.close();
                Set resourcePerms = resource.getPosixFilePermissions();
                if (resourcePerms != null && Files.getFileStore(newFile.toPath()).supportsFileAttributeView(PosixFileAttributeView.class)) {
                    Files.setPosixFilePermissions(newFile.toPath(), resourcePerms);
                }
                if (resource.getLastModified() > 0L && !(lastModifiedSet = newFile.setLastModified(resource.getLastModified()))) {
                    log.warn("Last modified of file {} could not be changed", (Object)newFile);
                }
            }
            catch (IOException e) {
                log.error("Could not write file", (Throwable)e);
            }
        }
    }

    private void extractWebJarsTo(@Nullable String name, @Nullable String moduleNameFile, @Nullable File to) {
        if (name == null) {
            ClassGraph classGraph = new ClassGraph().overrideClassLoaders(new ClassLoader[]{this.classLoader}).ignoreParentClassLoaders().acceptPaths(new String[]{"META-INF/resources/webjars"});
            try (ScanResult scanResult = classGraph.scan();){
                Map<String, WebJarAssetLocator.WebJarInfo> allWebJars = WebJarAssetLocator.findWebJars(scanResult);
                WebJarAssetLocator webJarAssetLocator = new WebJarAssetLocator(allWebJars);
                for (String webJarName : allWebJars.keySet()) {
                    String moduleFilePath = webJarAssetLocator.getFullPathExact(webJarName, moduleNameFile);
                    WebJarAssetLocator.WebJarInfo webJarInfo = webJarAssetLocator.getAllWebJars().get(webJarName);
                    this.extractResourcesTo(webJarName, webJarInfo, moduleFilePath, WebJarAssetLocator.webJarResources(webJarName, scanResult.getAllResources()), to);
                }
            }
        }
        ClassGraph classGraph = new ClassGraph().overrideClassLoaders(new ClassLoader[]{this.classLoader}).ignoreParentClassLoaders().acceptPaths(new String[]{String.format("%s/%s/*", "META-INF/resources/webjars", name)});
        try (ScanResult scanResult = classGraph.scan();){
            Map<String, WebJarAssetLocator.WebJarInfo> allWebJars = WebJarAssetLocator.findWebJars(scanResult);
            WebJarAssetLocator webJarAssetLocator = new WebJarAssetLocator(allWebJars);
            ResourceList webJarResources = scanResult.getAllResources();
            WebJarAssetLocator.WebJarInfo webJarInfo = allWebJars.get(name);
            String moduleFilePath = webJarAssetLocator.getFullPathExact(name, moduleNameFile);
            this.extractResourcesTo(name, webJarInfo, moduleFilePath, webJarResources, to);
        }
    }

    @Nullable
    protected static String getJsonModuleId(@Nonnull String packageJson) throws IOException {
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createParser(packageJson);
        if (parser.nextToken() != JsonToken.START_OBJECT) {
            throw new IOException("package.json is not a valid JSON object");
        }
        String moduleId = null;
        while (!parser.isClosed()) {
            parser.nextToken();
            String fieldName = parser.getCurrentName();
            if (!"name".equals(fieldName) || !parser.getParsingContext().getParent().inRoot()) continue;
            parser.nextToken();
            moduleId = parser.getText();
            parser.close();
        }
        return moduleId;
    }
}

