/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import org.apiguardian.api.API;
import org.zalando.logbook.BodyReplacementHttpResponse;
import org.zalando.logbook.BodyReplacer;
import org.zalando.logbook.BodyReplacers;
import org.zalando.logbook.DefaultFilters;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.ResponseFilter;

@API(status=API.Status.STABLE)
public final class ResponseFilters {
    private ResponseFilters() {
    }

    @API(status=API.Status.MAINTAINED)
    public static ResponseFilter defaultValue() {
        return DefaultFilters.defaultValues(ResponseFilter.class).stream().reduce(ResponseFilters.replaceBody(BodyReplacers.defaultValue()), ResponseFilter::merge);
    }

    public static ResponseFilter replaceBody(BodyReplacer<HttpResponse> replacer) {
        return response -> {
            String replacement = replacer.replace((HttpMessage)response);
            if (replacement == null) {
                return response;
            }
            return new BodyReplacementHttpResponse(response, replacement);
        };
    }
}

