/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.Objects;
import java.util.function.UnaryOperator;
import org.zalando.logbook.PathFilter;

final class DynamicPathFilter
implements PathFilter {
    private final UnaryOperator<String> replacementFunction;
    private final String[] parts;

    DynamicPathFilter(UnaryOperator<String> replacementFunction, String pathExpression) {
        this.replacementFunction = replacementFunction;
        String[] parts = pathExpression.split("/");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (!part.startsWith("{") || !part.endsWith("}")) continue;
            parts[i] = null;
        }
        this.parts = parts;
    }

    public String filter(String path) {
        int i;
        String[] pathParts = path.split("/");
        if (this.parts.length > pathParts.length) {
            return path;
        }
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < this.parts.length; ++i) {
            if (Objects.isNull(this.parts[i])) {
                if (i > 0) {
                    builder.append('/');
                }
                builder.append((String)this.replacementFunction.apply(pathParts[i]));
                continue;
            }
            if (Objects.equals(this.parts[i], pathParts[i])) {
                if (!this.parts[i].isEmpty()) {
                    builder.append('/');
                }
                builder.append(pathParts[i]);
                continue;
            }
            return path;
        }
        if (this.parts.length < pathParts.length) {
            for (i = this.parts.length; i < pathParts.length; ++i) {
                builder.append('/');
                builder.append(pathParts[i]);
            }
        }
        return builder.toString();
    }
}

