/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.StructuredHttpLogFormatter;
import org.zalando.logbook.json.JsonMediaType;

@API(status=API.Status.STABLE)
public final class JsonHttpLogFormatter
implements StructuredHttpLogFormatter {
    private final ObjectMapper mapper;

    public JsonHttpLogFormatter() {
        this(new ObjectMapper());
    }

    public JsonHttpLogFormatter(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public Optional<Object> prepareBody(HttpMessage message) throws IOException {
        String contentType = message.getContentType();
        String body = message.getBodyAsString();
        if (body.isEmpty()) {
            return Optional.empty();
        }
        if (JsonMediaType.JSON.test(contentType)) {
            return Optional.of(new JsonBody(body));
        }
        return Optional.of(body);
    }

    public String format(Map<String, Object> content) throws IOException {
        return this.mapper.writeValueAsString(content);
    }

    private static final class JsonBody {
        String json;

        @JsonRawValue
        @JsonValue
        public String getJson() {
            return this.json;
        }

        @Generated
        public JsonBody(String json) {
            this.json = json;
        }
    }
}

