/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.List;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.SafeEncoder;

public abstract class JedisPubSub {
    private static final String JEDIS_SUBSCRIPTION_MESSAGE = "JedisPubSub is not subscribed to a Jedis instance.";
    private int subscribedChannels = 0;
    private volatile Connection client;

    public void onMessage(String channel, String message) {
    }

    public void onPMessage(String pattern, String channel, String message) {
    }

    public void onSubscribe(String channel, int subscribedChannels) {
    }

    public void onUnsubscribe(String channel, int subscribedChannels) {
    }

    public void onPUnsubscribe(String pattern, int subscribedChannels) {
    }

    public void onPSubscribe(String pattern, int subscribedChannels) {
    }

    public void onPong(String pattern) {
    }

    public void unsubscribe() {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand(Protocol.Command.UNSUBSCRIBE);
        this.client.flush();
    }

    public void unsubscribe(String ... channels) {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand((ProtocolCommand)Protocol.Command.UNSUBSCRIBE, channels);
        this.client.flush();
    }

    public void subscribe(String ... channels) {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand((ProtocolCommand)Protocol.Command.SUBSCRIBE, channels);
        this.client.flush();
    }

    public void psubscribe(String ... patterns) {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand((ProtocolCommand)Protocol.Command.PSUBSCRIBE, patterns);
        this.client.flush();
    }

    public void punsubscribe() {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand(Protocol.Command.PUNSUBSCRIBE);
        this.client.flush();
    }

    public void punsubscribe(String ... patterns) {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand((ProtocolCommand)Protocol.Command.PUNSUBSCRIBE, patterns);
        this.client.flush();
    }

    public void ping() {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand(Protocol.Command.PING);
        this.client.flush();
    }

    public void ping(String argument) {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand((ProtocolCommand)Protocol.Command.PING, argument);
        this.client.flush();
    }

    public boolean isSubscribed() {
        return this.subscribedChannels > 0;
    }

    public void proceedWithPatterns(Connection client, String ... patterns) {
        this.client = client;
        this.psubscribe(patterns);
        this.process();
    }

    public void proceed(Connection client, String ... channels) {
        this.client = client;
        this.subscribe(channels);
        this.process();
    }

    private void process() {
        do {
            String strpattern;
            byte[] bpattern;
            String strchannel;
            byte[] bchannel;
            List<Object> reply;
            Object firstObj;
            if (!((firstObj = (reply = this.client.getUnflushedObjectMultiBulkReply()).get(0)) instanceof byte[])) {
                throw new JedisException("Unknown message type: " + firstObj);
            }
            byte[] resp = (byte[])firstObj;
            if (Arrays.equals(Protocol.ResponseKeyword.SUBSCRIBE.getRaw(), resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bchannel = (byte[])reply.get(1);
                strchannel = bchannel == null ? null : SafeEncoder.encode(bchannel);
                this.onSubscribe(strchannel, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.UNSUBSCRIBE.getRaw(), resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bchannel = (byte[])reply.get(1);
                strchannel = bchannel == null ? null : SafeEncoder.encode(bchannel);
                this.onUnsubscribe(strchannel, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.MESSAGE.getRaw(), resp)) {
                bchannel = (byte[])reply.get(1);
                byte[] bmesg = (byte[])reply.get(2);
                String strchannel2 = bchannel == null ? null : SafeEncoder.encode(bchannel);
                String strmesg = bmesg == null ? null : SafeEncoder.encode(bmesg);
                this.onMessage(strchannel2, strmesg);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PMESSAGE.getRaw(), resp)) {
                bpattern = (byte[])reply.get(1);
                byte[] bchannel2 = (byte[])reply.get(2);
                byte[] bmesg = (byte[])reply.get(3);
                String strpattern2 = bpattern == null ? null : SafeEncoder.encode(bpattern);
                String strchannel3 = bchannel2 == null ? null : SafeEncoder.encode(bchannel2);
                String strmesg = bmesg == null ? null : SafeEncoder.encode(bmesg);
                this.onPMessage(strpattern2, strchannel3, strmesg);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PSUBSCRIBE.getRaw(), resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bpattern = (byte[])reply.get(1);
                strpattern = bpattern == null ? null : SafeEncoder.encode(bpattern);
                this.onPSubscribe(strpattern, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PUNSUBSCRIBE.getRaw(), resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bpattern = (byte[])reply.get(1);
                strpattern = bpattern == null ? null : SafeEncoder.encode(bpattern);
                this.onPUnsubscribe(strpattern, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PONG.getRaw(), resp)) {
                bpattern = (byte[])reply.get(1);
                strpattern = bpattern == null ? null : SafeEncoder.encode(bpattern);
                this.onPong(strpattern);
                continue;
            }
            throw new JedisException("Unknown message type: " + firstObj);
        } while (this.isSubscribed());
        this.client = null;
    }

    public int getSubscribedChannels() {
        return this.subscribedChannels;
    }
}

