/* ClickHouseSqlParserTokenManager.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. ClickHouseSqlParserTokenManager.java */
package com.clickhouse.jdbc.parser;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;

/** Token Manager. */
@SuppressWarnings ("unused")
public class ClickHouseSqlParserTokenManager implements ClickHouseSqlParserConstants {
    // whitespaces and comments are invalid
    private int validTokens = 0;
    // see http://www.engr.mun.ca/~theo/JavaCC-FAQ/javacc-faq-moz.htm#tth_sEc3.17
    private int commentNestingDepth = 0;

    final java.util.Deque<Integer> stack = new java.util.LinkedList<>();
    int parentToken = -1;

    final StringBuilder builder = new StringBuilder();

    StatementType stmtType = StatementType.UNKNOWN;
    String cluster = null;
    String database = null;
    String table = null;
    String input = null;
    String format = null;
    String outfile = null;

    final List<Integer> parameters = new ArrayList<>();
    final Map<String, Integer> positions = new HashMap<>();
    final Map<String, String> settings = new LinkedHashMap<>();
    final Set<String> tempTables = new LinkedHashSet<>();

    public void CommonTokenAction(Token t) {
        if (t.kind != ClickHouseSqlParserConstants.SEMICOLON) {
            builder.append(t.image);

            if (t.kind != ClickHouseSqlParserConstants.EOF) {
                validTokens++;
            }
        }
 }

    void enterToken(int tokenKind) {
        if (tokenKind < 0) {
            return;
        }

        stack.push(parentToken = tokenKind);
    }

    void leaveToken(int tokenKind) {
        if (parentToken == tokenKind) {
            stack.pop();
        }

        parentToken = stack.isEmpty() ? -1 : stack.getLast();
    }

    void processMacro(String name, List<String> params, ParseHandler handler) {
        StringBuilder m = new StringBuilder();
        m.append('#').append(name);

        int startPos = builder.lastIndexOf(m.toString());
        int endPos = !params.isEmpty() ? builder.indexOf(")", startPos) + 1 : startPos + m.length();

        builder.delete(startPos, endPos);
        if (handler != null) {
            String replacement = handler.handleMacro(name, params);
            if (replacement != null && !replacement.isEmpty()) {
                builder.insert(startPos, replacement);
            }
        }
    }

    void processParameter(String str, ParseHandler handler) {
        int pos = builder.lastIndexOf(str);
        parameters.add(pos);

        if (handler != null) {
            String replacement = handler.handleParameter(cluster, database, table, parameters.size());
            if (replacement != null && !replacement.isEmpty()) {
                builder.deleteCharAt(pos);
                builder.insert(pos, replacement);
            }
        }
    }

    void append(StringBuilder str) {
        builder.append(str.toString());
    }

    void reset() {
        stack.clear();
        parentToken = -1;

        builder.setLength(validTokens = 0);

        stmtType = StatementType.UNKNOWN;
        cluster = null;
        database = null;
        table = null;
        input = null;
        format = null;
        outfile = null;
        parameters.clear();
        positions.clear();
        settings.clear();
        tempTables.clear();
    }

    ClickHouseSqlStatement build(ParseHandler handler) {
        String sqlStmt = builder.toString();
        ClickHouseSqlStatement s = null;
        if (handler != null) {
            s = handler.handleStatement(
                sqlStmt, stmtType, cluster, database, table, input, format, outfile, parameters, positions, settings, tempTables);
        }

        if (s == null) {
            s = new ClickHouseSqlStatement(
                sqlStmt, stmtType, cluster, database, table, input, format, outfile, parameters, positions, settings, tempTables);
        }

        // reset variables
        reset();

        return s;
    }

    boolean isValid() {
        return validTokens > 0;
    }

    void addPosition(Token t) {
        String keyword = null;
        if (t == null || (keyword = t.image) == null || keyword.isEmpty()) {
            return;
        }

        this.positions.put(keyword.toUpperCase(Locale.ROOT), builder.lastIndexOf(keyword));
    }

    void addCustomKeywordPosition(String keyword, Token t) {
        String search = t != null ? t.image : null;
        if (keyword == null || keyword.isEmpty() || search == null || search.isEmpty()) {
            return;
        }

        this.positions.put(keyword, builder.lastIndexOf(search));
    }

    void removePosition(String keyword) {
        this.positions.remove(keyword);
    }

    void addSetting(String key, String value) {
        if (key == null || key.isEmpty()) {
            return;
        }

        this.settings.put(key.toLowerCase(Locale.ROOT), value);
    }
private final int jjStopStringLiteralDfa_0(int pos, long active0, long active1, long active2){
   switch (pos)
   {
      case 0:
         if ((active2 & 0x800000000L) != 0x0L)
            return 58;
         if ((active0 & 0x10L) != 0x0L || (active2 & 0x4000000000000L) != 0x0L)
            return 4;
         if ((active2 & 0x14800000L) != 0x0L)
            return 37;
         if ((active2 & 0x20000000L) != 0x0L)
            return 53;
         if ((active2 & 0xa000000000L) != 0x0L)
            return 27;
         if ((active2 & 0x200000L) != 0x0L)
            return 565;
         if ((active2 & 0x8040000L) != 0x0L)
            return 1;
         if ((active2 & 0x200000000000L) != 0x0L)
            return 566;
         if ((active2 & 0x100000000000L) != 0x0L)
            return 567;
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_0(int pos, long active0, long active1, long active2){
   return jjMoveNfa_0(jjStopStringLiteralDfa_0(pos, active0, active1, active2), pos + 1);
}
private int jjStopAtPos(int pos, int kind)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   return pos + 1;
}
private int jjMoveStringLiteralDfa0_0(){
   switch(curChar)
   {
      case '"':
         return jjStartNfaWithStates_0(0, 172, 567);
      case '#':
         return jjStopAtPos(0, 162);
      case '$':
         return jjStartNfaWithStates_0(0, 156, 37);
      case '%':
         return jjStopAtPos(0, 169);
      case '\'':
         return jjStartNfaWithStates_0(0, 173, 566);
      case '(':
         return jjStopAtPos(0, 166);
      case ')':
         return jjStopAtPos(0, 176);
      case '*':
         return jjStopAtPos(0, 147);
      case '+':
         return jjStopAtPos(0, 170);
      case ',':
         return jjStopAtPos(0, 152);
      case '-':
         jjmatchedKind = 155;
         return jjMoveStringLiteralDfa1_0(0x0L, 0x40000L);
      case '.':
         return jjStartNfaWithStates_0(0, 157, 53);
      case '/':
         jjmatchedKind = 178;
         return jjMoveStringLiteralDfa1_0(0x10L, 0x0L);
      case ':':
         jjmatchedKind = 151;
         return jjMoveStringLiteralDfa1_0(0x0L, 0x4000000L);
      case ';':
         return jjStopAtPos(0, 177);
      case '<':
         jjmatchedKind = 167;
         return jjMoveStringLiteralDfa1_0(0x0L, 0x2000000000L);
      case '=':
         jjmatchedKind = 159;
         return jjMoveStringLiteralDfa1_0(0x0L, 0x40000000L);
      case '>':
         jjmatchedKind = 161;
         return jjMoveStringLiteralDfa1_0(0x0L, 0x100000000L);
      case '?':
         return jjStopAtPos(0, 171);
      case '@':
         return jjStopAtPos(0, 148);
      case '[':
         return jjStopAtPos(0, 164);
      case '\\':
         return jjStopAtPos(0, 150);
      case ']':
         return jjStopAtPos(0, 175);
      case '`':
         return jjStartNfaWithStates_0(0, 149, 565);
      case '{':
         return jjStartNfaWithStates_0(0, 163, 58);
      case '|':
         return jjMoveStringLiteralDfa1_0(0x0L, 0x2000000L);
      case '}':
         return jjStopAtPos(0, 174);
      default :
         return jjMoveNfa_0(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_0(long active0, long active2){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(0, active0, 0L, active2);
      return 1;
   }
   switch(curChar)
   {
      case '*':
         if ((active0 & 0x10L) != 0x0L)
            return jjStopAtPos(1, 4);
         break;
      case ':':
         if ((active2 & 0x4000000L) != 0x0L)
            return jjStopAtPos(1, 154);
         break;
      case '=':
         if ((active2 & 0x40000000L) != 0x0L)
            return jjStopAtPos(1, 158);
         else if ((active2 & 0x100000000L) != 0x0L)
            return jjStopAtPos(1, 160);
         else if ((active2 & 0x2000000000L) != 0x0L)
            return jjStopAtPos(1, 165);
         break;
      case '>':
         if ((active2 & 0x40000L) != 0x0L)
            return jjStopAtPos(1, 146);
         break;
      case '|':
         if ((active2 & 0x2000000L) != 0x0L)
            return jjStopAtPos(1, 153);
         break;
      default :
         break;
   }
   return jjStartNfa_0(0, active0, 0L, active2);
}
private int jjStartNfaWithStates_0(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_0(state, pos + 1);
}
static final long[] jjbitVec0 = {
   0x0L, 0x0L, 0x100000020L, 0x0L
};
static final long[] jjbitVec1 = {
   0x4000L, 0x0L, 0x0L, 0x0L
};
static final long[] jjbitVec2 = {
   0x830000003c01L, 0x180000000L, 0x0L, 0x0L
};
static final long[] jjbitVec3 = {
   0x1L, 0x0L, 0x0L, 0x0L
};
static final long[] jjbitVec4 = {
   0x0L, 0x0L, 0x0L, 0x8000000000000000L
};
static final long[] jjbitVec5 = {
   0xfffffffffffffffeL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL
};
static final long[] jjbitVec7 = {
   0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
};
private int jjMoveNfa_0(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 565;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 565:
               case 41:
               case 40:
                  { jjCheckNAddStates(0, 3); }
                  break;
               case 566:
                  if ((0xffffff7fffffffffL & l) != 0x0L)
                     { jjCheckNAddStates(4, 7); }
                  else if (curChar == 39)
                  {
                     if (kind > 180)
                        kind = 180;
                  }
                  if (curChar == 39)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 567:
                  if ((0xfffffffbffffffffL & l) != 0x0L)
                     { jjCheckNAddStates(8, 11); }
                  else if (curChar == 34)
                  {
                     if (kind > 183)
                        kind = 183;
                  }
                  if (curChar == 34)
                     jjstateSet[jjnewStateCnt++] = 49;
                  break;
               case 0:
                  if ((0x3ff000000000000L & l) != 0x0L)
                  {
                     if (kind > 185)
                        kind = 185;
                     { jjCheckNAddStates(12, 19); }
                  }
                  else if ((0x100003e00L & l) != 0x0L)
                  {
                     if (kind > 1)
                        kind = 1;
                  }
                  else if ((0x400001000000000L & l) != 0x0L)
                  {
                     if (kind > 181)
                        kind = 181;
                     { jjCheckNAdd(37); }
                  }
                  else if (curChar == 46)
                     { jjCheckNAdd(53); }
                  else if (curChar == 34)
                     { jjCheckNAddStates(8, 11); }
                  else if (curChar == 39)
                     { jjCheckNAddStates(4, 7); }
                  else if (curChar == 60)
                     jjstateSet[jjnewStateCnt++] = 27;
                  else if (curChar == 33)
                     jjstateSet[jjnewStateCnt++] = 25;
                  else if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 4;
                  else if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 1;
                  if (curChar == 48)
                     { jjAddStates(20, 22); }
                  break;
               case 1:
                  if (curChar != 45)
                     break;
                  if (kind > 3)
                     kind = 3;
                  { jjCheckNAdd(2); }
                  break;
               case 2:
                  if ((0xffffffffffffdbffL & l) == 0x0L)
                     break;
                  if (kind > 3)
                     kind = 3;
                  { jjCheckNAdd(2); }
                  break;
               case 3:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 4:
                  if (curChar != 47)
                     break;
                  if (kind > 3)
                     kind = 3;
                  { jjCheckNAdd(2); }
                  break;
               case 5:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 25:
                  if (curChar == 61 && kind > 168)
                     kind = 168;
                  break;
               case 26:
                  if (curChar == 33)
                     jjstateSet[jjnewStateCnt++] = 25;
                  break;
               case 27:
                  if (curChar == 62 && kind > 168)
                     kind = 168;
                  break;
               case 28:
                  if (curChar == 60)
                     jjstateSet[jjnewStateCnt++] = 27;
                  break;
               case 29:
               case 33:
                  if (curChar == 39)
                     { jjCheckNAddStates(4, 7); }
                  break;
               case 31:
                  { jjCheckNAddStates(4, 7); }
                  break;
               case 32:
                  if ((0xffffff7fffffffffL & l) != 0x0L)
                     { jjCheckNAddStates(4, 7); }
                  break;
               case 34:
                  if (curChar == 39)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 35:
                  if (curChar == 39 && kind > 180)
                     kind = 180;
                  break;
               case 36:
                  if ((0x400001000000000L & l) == 0x0L)
                     break;
                  if (kind > 181)
                     kind = 181;
                  { jjCheckNAdd(37); }
                  break;
               case 37:
                  if ((0x3ff001000000000L & l) == 0x0L)
                     break;
                  if (kind > 181)
                     kind = 181;
                  { jjCheckNAdd(37); }
                  break;
               case 45:
               case 49:
                  if (curChar == 34)
                     { jjCheckNAddStates(8, 11); }
                  break;
               case 47:
                  { jjCheckNAddStates(8, 11); }
                  break;
               case 48:
                  if ((0xfffffffbffffffffL & l) != 0x0L)
                     { jjCheckNAddStates(8, 11); }
                  break;
               case 50:
                  if (curChar == 34)
                     jjstateSet[jjnewStateCnt++] = 49;
                  break;
               case 51:
                  if (curChar == 34 && kind > 183)
                     kind = 183;
                  break;
               case 52:
                  if (curChar == 46)
                     { jjCheckNAdd(53); }
                  break;
               case 53:
                  if ((0x3ff000000000000L & l) == 0x0L)
                     break;
                  if (kind > 184)
                     kind = 184;
                  { jjCheckNAddTwoStates(53, 54); }
                  break;
               case 55:
                  if ((0x280000000000L & l) != 0x0L)
                     { jjCheckNAdd(56); }
                  break;
               case 56:
                  if ((0x3ff000000000000L & l) == 0x0L)
                     break;
                  if (kind > 184)
                     kind = 184;
                  { jjCheckNAdd(56); }
                  break;
               case 59:
                  { jjAddStates(23, 24); }
                  break;
               case 531:
                  if ((0x3ff000000000000L & l) == 0x0L)
                     break;
                  if (kind > 185)
                     kind = 185;
                  { jjCheckNAddStates(12, 19); }
                  break;
               case 532:
                  if ((0x3ff000000000000L & l) != 0x0L)
                     { jjCheckNAddStates(25, 27); }
                  break;
               case 536:
                  if ((0x3ff000000000000L & l) == 0x0L)
                     break;
                  if (kind > 181)
                     kind = 181;
                  jjstateSet[jjnewStateCnt++] = 536;
                  break;
               case 537:
                  if ((0x3ff000000000000L & l) != 0x0L)
                     { jjCheckNAddTwoStates(537, 538); }
                  break;
               case 538:
                  if (curChar != 46)
                     break;
                  if (kind > 184)
                     kind = 184;
                  { jjCheckNAddTwoStates(539, 540); }
                  break;
               case 539:
                  if ((0x3ff000000000000L & l) == 0x0L)
                     break;
                  if (kind > 184)
                     kind = 184;
                  { jjCheckNAddTwoStates(539, 540); }
                  break;
               case 541:
                  if ((0x280000000000L & l) != 0x0L)
                     { jjCheckNAdd(542); }
                  break;
               case 542:
                  if ((0x3ff000000000000L & l) == 0x0L)
                     break;
                  if (kind > 184)
                     kind = 184;
                  { jjCheckNAdd(542); }
                  break;
               case 543:
                  if ((0x3ff000000000000L & l) != 0x0L)
                     { jjCheckNAddTwoStates(543, 544); }
                  break;
               case 545:
                  if ((0x280000000000L & l) != 0x0L)
                     { jjCheckNAdd(546); }
                  break;
               case 546:
                  if ((0x3ff000000000000L & l) == 0x0L)
                     break;
                  if (kind > 184)
                     kind = 184;
                  { jjCheckNAdd(546); }
                  break;
               case 547:
                  if ((0x3ff000000000000L & l) == 0x0L)
                     break;
                  if (kind > 185)
                     kind = 185;
                  { jjCheckNAdd(547); }
                  break;
               case 548:
                  if (curChar == 48)
                     { jjAddStates(20, 22); }
                  break;
               case 550:
                  if ((0x3ff000000000000L & l) != 0x0L)
                     { jjAddStates(28, 29); }
                  break;
               case 551:
                  if (curChar == 46)
                     { jjCheckNAddTwoStates(552, 555); }
                  break;
               case 552:
                  if (curChar == 48)
                     jjstateSet[jjnewStateCnt++] = 553;
                  break;
               case 554:
                  if ((0x3ff000000000000L & l) != 0x0L)
                     { jjCheckNAddTwoStates(554, 555); }
                  break;
               case 556:
                  if ((0x280000000000L & l) != 0x0L)
                     { jjCheckNAdd(557); }
                  break;
               case 557:
                  if ((0x3ff000000000000L & l) == 0x0L)
                     break;
                  if (kind > 184)
                     kind = 184;
                  { jjCheckNAdd(557); }
                  break;
               case 559:
                  if ((0x3ff000000000000L & l) != 0x0L)
                     { jjAddStates(30, 31); }
                  break;
               case 561:
                  if ((0x280000000000L & l) != 0x0L)
                     { jjCheckNAdd(562); }
                  break;
               case 562:
                  if ((0x3ff000000000000L & l) == 0x0L)
                     break;
                  if (kind > 184)
                     kind = 184;
                  { jjCheckNAdd(562); }
                  break;
               case 564:
                  if ((0x3ff000000000000L & l) == 0x0L)
                     break;
                  if (kind > 186)
                     kind = 186;
                  jjstateSet[jjnewStateCnt++] = 564;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 565:
                  if ((0xfffffffeefffffffL & l) != 0x0L)
                     { jjCheckNAddStates(0, 3); }
                  else if (curChar == 96)
                  {
                     if (kind > 182)
                        kind = 182;
                  }
                  else if (curChar == 92)
                     jjstateSet[jjnewStateCnt++] = 40;
                  if (curChar == 96)
                     jjstateSet[jjnewStateCnt++] = 42;
                  break;
               case 566:
                  if ((0xffffffffefffffffL & l) != 0x0L)
                     { jjCheckNAddStates(4, 7); }
                  else if (curChar == 92)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 567:
                  if ((0xffffffffefffffffL & l) != 0x0L)
                     { jjCheckNAddStates(8, 11); }
                  else if (curChar == 92)
                     jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 0:
                  if ((0x7fffffe87fffffeL & l) != 0x0L)
                  {
                     if (kind > 181)
                        kind = 181;
                     { jjCheckNAdd(37); }
                  }
                  else if (curChar == 123)
                     { jjCheckNAddStates(32, 35); }
                  else if (curChar == 96)
                     { jjCheckNAddStates(0, 3); }
                  if ((0x40000000400000L & l) != 0x0L)
                     { jjAddStates(36, 37); }
                  else if ((0x2000000020000L & l) != 0x0L)
                     { jjAddStates(38, 39); }
                  else if ((0x1000000010000L & l) != 0x0L)
                     { jjAddStates(40, 42); }
                  else if ((0x400000004000L & l) != 0x0L)
                     { jjAddStates(43, 45); }
                  else if ((0x200000002000L & l) != 0x0L)
                     { jjAddStates(46, 48); }
                  else if ((0x100000001000L & l) != 0x0L)
                     { jjAddStates(49, 52); }
                  else if ((0x10000000100L & l) != 0x0L)
                     { jjAddStates(53, 54); }
                  else if ((0x4000000040L & l) != 0x0L)
                     { jjAddStates(55, 59); }
                  else if ((0x80000000800000L & l) != 0x0L)
                     { jjAddStates(60, 64); }
                  else if ((0x20000000200000L & l) != 0x0L)
                     { jjAddStates(65, 69); }
                  else if ((0x10000000100000L & l) != 0x0L)
                     { jjAddStates(70, 78); }
                  else if ((0x8000000080000L & l) != 0x0L)
                     { jjAddStates(79, 85); }
                  else if ((0x4000000040000L & l) != 0x0L)
                     { jjAddStates(86, 91); }
                  else if ((0x800000008000L & l) != 0x0L)
                     { jjAddStates(92, 97); }
                  else if ((0x20000000200L & l) != 0x0L)
                     { jjAddStates(98, 107); }
                  else if ((0x8000000080L & l) != 0x0L)
                     { jjAddStates(108, 110); }
                  else if ((0x2000000020L & l) != 0x0L)
                     { jjAddStates(111, 115); }
                  else if ((0x1000000010L & l) != 0x0L)
                     { jjAddStates(116, 127); }
                  else if ((0x800000008L & l) != 0x0L)
                     { jjAddStates(128, 131); }
                  else if ((0x200000002L & l) != 0x0L)
                     { jjAddStates(132, 139); }
                  else if ((0x200000002000000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 22;
                  else if ((0x40000000400L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 18;
                  else if ((0x400000004L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 11;
                  else if ((0x80000000800L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 58:
                  if (curChar == 116)
                     { jjCheckNAdd(61); }
                  else if (curChar == 100)
                     { jjCheckNAddTwoStates(59, 60); }
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 62;
                  if (curChar == 116)
                     { jjCheckNAddTwoStates(59, 60); }
                  break;
               case 2:
                  if (kind > 3)
                     kind = 3;
                  jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 6:
                  if ((0x80000000800L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 7:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 8;
                  break;
               case 8:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 9:
                  if ((0x100000001000L & l) != 0x0L && kind > 21)
                     kind = 21;
                  break;
               case 10:
                  if ((0x400000004L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               case 11:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 12:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 13:
                  if ((0x80000000800000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 14:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 15;
                  break;
               case 15:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 16:
                  if ((0x400000004000L & l) != 0x0L && kind > 39)
                     kind = 39;
                  break;
               case 17:
                  if ((0x40000000400L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 18;
                  break;
               case 18:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 19;
                  break;
               case 19:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 20;
                  break;
               case 20:
                  if ((0x400000004000L & l) != 0x0L && kind > 67)
                     kind = 67;
                  break;
               case 21:
                  if ((0x200000002000000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 22;
                  break;
               case 22:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 23;
                  break;
               case 23:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 24;
                  break;
               case 24:
                  if ((0x4000000040000L & l) != 0x0L && kind > 112)
                     kind = 112;
                  break;
               case 30:
                  if (curChar == 92)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 31:
                  { jjCheckNAddStates(4, 7); }
                  break;
               case 32:
                  if ((0xffffffffefffffffL & l) != 0x0L)
                     { jjCheckNAddStates(4, 7); }
                  break;
               case 36:
               case 37:
                  if ((0x7fffffe87fffffeL & l) == 0x0L)
                     break;
                  if (kind > 181)
                     kind = 181;
                  { jjCheckNAdd(37); }
                  break;
               case 38:
               case 42:
                  if (curChar == 96)
                     { jjCheckNAddStates(0, 3); }
                  break;
               case 39:
                  if (curChar == 92)
                     jjstateSet[jjnewStateCnt++] = 40;
                  break;
               case 40:
                  { jjCheckNAddStates(0, 3); }
                  break;
               case 41:
                  if ((0xfffffffeefffffffL & l) != 0x0L)
                     { jjCheckNAddStates(0, 3); }
                  break;
               case 43:
                  if (curChar == 96)
                     jjstateSet[jjnewStateCnt++] = 42;
                  break;
               case 44:
                  if (curChar == 96 && kind > 182)
                     kind = 182;
                  break;
               case 46:
                  if (curChar == 92)
                     jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 47:
                  { jjCheckNAddStates(8, 11); }
                  break;
               case 48:
                  if ((0xffffffffefffffffL & l) != 0x0L)
                     { jjCheckNAddStates(8, 11); }
                  break;
               case 54:
                  if ((0x2000000020L & l) != 0x0L)
                     { jjAddStates(140, 141); }
                  break;
               case 57:
                  if (curChar == 123)
                     { jjCheckNAddStates(32, 35); }
                  break;
               case 59:
                  if ((0xdfffffffffffffffL & l) != 0x0L)
                     { jjCheckNAddTwoStates(59, 60); }
                  break;
               case 60:
                  if (curChar == 125 && kind > 2)
                     kind = 2;
                  break;
               case 61:
                  if (curChar == 116)
                     { jjCheckNAddTwoStates(59, 60); }
                  break;
               case 62:
                  if (curChar == 115)
                     { jjCheckNAddTwoStates(59, 60); }
                  break;
               case 63:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 62;
                  break;
               case 64:
                  if (curChar == 116)
                     { jjCheckNAdd(61); }
                  break;
               case 65:
                  if ((0x200000002L & l) != 0x0L)
                     { jjAddStates(132, 139); }
                  break;
               case 66:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 67:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 68;
                  break;
               case 68:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 69;
                  break;
               case 69:
                  if ((0x4000000040000L & l) != 0x0L && kind > 8)
                     kind = 8;
                  break;
               case 70:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 71;
                  break;
               case 71:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 72;
                  break;
               case 72:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 74;
                  break;
               case 74:
                  if ((0x10000000100L & l) != 0x0L && kind > 9)
                     kind = 9;
                  break;
               case 75:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 76;
                  break;
               case 76:
                  if ((0x100000001000L & l) != 0x0L && kind > 33)
                     kind = 33;
                  break;
               case 77:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 78;
                  break;
               case 78:
                  if ((0x1000000010L & l) != 0x0L && kind > 34)
                     kind = 34;
                  break;
               case 79:
                  if ((0x1000000010000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 80;
                  break;
               case 80:
                  if ((0x1000000010000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 81;
                  break;
               case 81:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 82:
                  if ((0x200000002000000L & l) != 0x0L && kind > 35)
                     kind = 35;
                  break;
               case 83:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 84;
                  break;
               case 84:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 85;
                  break;
               case 85:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 86;
                  break;
               case 86:
                  if ((0x200000002000000L & l) != 0x0L && kind > 36)
                     kind = 36;
                  break;
               case 87:
                  if ((0x8000000080000L & l) != 0x0L && kind > 37)
                     kind = 37;
                  break;
               case 88:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 89;
                  break;
               case 89:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 90;
                  break;
               case 90:
                  if ((0x4000000040L & l) != 0x0L && kind > 38)
                     kind = 38;
                  break;
               case 91:
                  if ((0x800000008L & l) != 0x0L)
                     { jjAddStates(128, 131); }
                  break;
               case 92:
                  if ((0x10000000100L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 93;
                  break;
               case 93:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 94;
                  break;
               case 94:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 95;
                  break;
               case 95:
                  if ((0x80000000800L & l) != 0x0L && kind > 10)
                     kind = 10;
                  break;
               case 96:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 97;
                  break;
               case 97:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 98;
                  break;
               case 98:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 99;
                  break;
               case 99:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 100;
                  break;
               case 100:
                  if ((0x2000000020L & l) != 0x0L && kind > 11)
                     kind = 11;
                  break;
               case 101:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 102;
                  break;
               case 102:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 103;
                  break;
               case 103:
                  if ((0x2000000020L & l) != 0x0L && kind > 40)
                     kind = 40;
                  break;
               case 104:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 105;
                  break;
               case 105:
                  if ((0x20000000200000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 106;
                  break;
               case 106:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 107;
                  break;
               case 107:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 108;
                  break;
               case 108:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 109;
                  break;
               case 109:
                  if ((0x4000000040000L & l) != 0x0L && kind > 41)
                     kind = 41;
                  break;
               case 110:
                  if ((0x1000000010L & l) != 0x0L)
                     { jjAddStates(116, 127); }
                  break;
               case 111:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 112;
                  break;
               case 112:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 113;
                  break;
               case 113:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 114;
                  break;
               case 114:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 115;
                  break;
               case 115:
                  if ((0x2000000020L & l) != 0x0L && kind > 12)
                     kind = 12;
                  break;
               case 116:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 117;
                  break;
               case 117:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 118;
                  break;
               case 118:
                  if ((0x800000008L & l) != 0x0L && kind > 13)
                     kind = 13;
                  break;
               case 119:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 120;
                  break;
               case 120:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 121;
                  break;
               case 121:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 122;
                  break;
               case 122:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 123;
                  break;
               case 123:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 124;
                  break;
               case 124:
                  if ((0x400000004L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 125;
                  break;
               case 125:
                  if ((0x2000000020L & l) != 0x0L && kind > 14)
                     kind = 14;
                  break;
               case 126:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 127;
                  break;
               case 127:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 128;
                  break;
               case 128:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 129;
                  break;
               case 129:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 130;
                  break;
               case 130:
                  if ((0x10000000100L & l) != 0x0L && kind > 15)
                     kind = 15;
                  break;
               case 131:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 132;
                  break;
               case 132:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 133;
                  break;
               case 133:
                  if ((0x1000000010000L & l) != 0x0L && kind > 16)
                     kind = 16;
                  break;
               case 134:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 135;
                  break;
               case 135:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 136;
                  break;
               case 136:
                  if ((0x2000000020L & l) != 0x0L && kind > 42)
                     kind = 42;
                  break;
               case 137:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 138;
                  break;
               case 138:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 139;
                  break;
               case 139:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 140;
                  break;
               case 140:
                  if ((0x400000004L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 141;
                  break;
               case 141:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 142;
                  break;
               case 142:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 143;
                  break;
               case 143:
                  if ((0x2000000020L & l) != 0x0L && kind > 43)
                     kind = 43;
                  break;
               case 144:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 145;
                  break;
               case 145:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 146;
                  break;
               case 146:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 147;
                  break;
               case 147:
                  if ((0x400000004L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 148;
                  break;
               case 148:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 149;
                  break;
               case 149:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 150;
                  break;
               case 150:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 151;
                  break;
               case 151:
                  if ((0x8000000080000L & l) != 0x0L && kind > 44)
                     kind = 44;
                  break;
               case 152:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 153;
                  break;
               case 153:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 154;
                  break;
               case 154:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 155;
                  break;
               case 155:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 156;
                  break;
               case 156:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 157;
                  break;
               case 157:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 158;
                  break;
               case 158:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 159;
                  break;
               case 159:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 160;
                  break;
               case 160:
                  if ((0x200000002000000L & l) != 0x0L && kind > 45)
                     kind = 45;
                  break;
               case 161:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 162;
                  break;
               case 162:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 163;
                  break;
               case 163:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 164;
                  break;
               case 164:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 165;
                  break;
               case 165:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 166;
                  break;
               case 166:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 167;
                  break;
               case 167:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 168;
                  break;
               case 168:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 169;
                  break;
               case 169:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 170;
                  break;
               case 170:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 171;
                  break;
               case 171:
                  if ((0x8000000080000L & l) != 0x0L && kind > 46)
                     kind = 46;
                  break;
               case 172:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 173;
                  break;
               case 173:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 174;
                  break;
               case 174:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 175;
                  break;
               case 175:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 176;
                  break;
               case 176:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 177;
                  break;
               case 177:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 178;
                  break;
               case 178:
                  if ((0x10000000100000L & l) != 0x0L && kind > 47)
                     kind = 47;
                  break;
               case 179:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 180;
                  break;
               case 180:
                  if ((0x200000002000000L & l) != 0x0L && kind > 108)
                     kind = 108;
                  break;
               case 181:
                  if ((0x2000000020L & l) != 0x0L)
                     { jjAddStates(111, 115); }
                  break;
               case 182:
                  if ((0x100000001000000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 183;
                  break;
               case 183:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 184;
                  break;
               case 184:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 185;
                  break;
               case 185:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 186;
                  break;
               case 186:
                  if ((0x8000000080000L & l) != 0x0L && kind > 17)
                     kind = 17;
                  break;
               case 187:
                  if ((0x100000001000000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 188;
                  break;
               case 188:
                  if ((0x1000000010000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 189;
                  break;
               case 189:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 190;
                  break;
               case 190:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 191;
                  break;
               case 191:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 192;
                  break;
               case 192:
                  if ((0x400000004000L & l) != 0x0L && kind > 18)
                     kind = 18;
                  break;
               case 193:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 194;
                  break;
               case 194:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 195;
                  break;
               case 195:
                  if ((0x2000000020L & l) != 0x0L && kind > 48)
                     kind = 48;
                  break;
               case 196:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 197;
                  break;
               case 197:
                  if ((0x1000000010L & l) != 0x0L && kind > 49)
                     kind = 49;
                  break;
               case 198:
                  if ((0x100000001000000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 199;
                  break;
               case 199:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 200;
                  break;
               case 200:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 201;
                  break;
               case 201:
                  if ((0x1000000010000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 202;
                  break;
               case 202:
                  if ((0x10000000100000L & l) != 0x0L && kind > 50)
                     kind = 50;
                  break;
               case 203:
                  if ((0x8000000080L & l) != 0x0L)
                     { jjAddStates(108, 110); }
                  break;
               case 204:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 205;
                  break;
               case 205:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 206;
                  break;
               case 206:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 207;
                  break;
               case 207:
                  if ((0x10000000100000L & l) != 0x0L && kind > 19)
                     kind = 19;
                  break;
               case 208:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 209;
                  break;
               case 209:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 210;
                  break;
               case 210:
                  if ((0x400000004L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 211;
                  break;
               case 211:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 212;
                  break;
               case 212:
                  if ((0x100000001000L & l) != 0x0L && kind > 56)
                     kind = 56;
                  break;
               case 213:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 214;
                  break;
               case 214:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 215;
                  break;
               case 215:
                  if ((0x20000000200000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 216;
                  break;
               case 216:
                  if ((0x1000000010000L & l) != 0x0L && kind > 57)
                     kind = 57;
                  break;
               case 217:
                  if ((0x20000000200L & l) != 0x0L)
                     { jjAddStates(98, 107); }
                  break;
               case 218:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 219;
                  break;
               case 219:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 220;
                  break;
               case 220:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 221;
                  break;
               case 221:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 222;
                  break;
               case 222:
                  if ((0x10000000100000L & l) != 0x0L && kind > 20)
                     kind = 20;
                  break;
               case 223:
                  if ((0x4000000040L & l) != 0x0L && kind > 59)
                     kind = 59;
                  break;
               case 224:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 225;
                  break;
               case 225:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 226;
                  break;
               case 226:
                  if ((0x80000000800L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 227;
                  break;
               case 227:
                  if ((0x2000000020L & l) != 0x0L && kind > 60)
                     kind = 60;
                  break;
               case 228:
                  if ((0x400000004000L & l) != 0x0L && kind > 61)
                     kind = 61;
                  break;
               case 229:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 230;
                  break;
               case 230:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 231;
                  break;
               case 231:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 232;
                  break;
               case 232:
                  if ((0x4000000040000L & l) != 0x0L && kind > 62)
                     kind = 62;
                  break;
               case 233:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 234;
                  break;
               case 234:
                  if ((0x1000000010000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 235;
                  break;
               case 235:
                  if ((0x20000000200000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 236;
                  break;
               case 236:
                  if ((0x10000000100000L & l) != 0x0L && kind > 63)
                     kind = 63;
                  break;
               case 237:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 238;
                  break;
               case 238:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 239;
                  break;
               case 239:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 240;
                  break;
               case 240:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 241;
                  break;
               case 241:
                  if ((0x40000000400000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 242;
                  break;
               case 242:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 243;
                  break;
               case 243:
                  if ((0x100000001000L & l) != 0x0L && kind > 64)
                     kind = 64;
                  break;
               case 244:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 245;
                  break;
               case 245:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 246;
                  break;
               case 246:
                  if ((0x800000008000L & l) != 0x0L && kind > 65)
                     kind = 65;
                  break;
               case 247:
                  if ((0x8000000080000L & l) != 0x0L && kind > 66)
                     kind = 66;
                  break;
               case 248:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 249;
                  break;
               case 249:
                  if ((0x4000000040L & l) != 0x0L && kind > 113)
                     kind = 113;
                  break;
               case 250:
                  if ((0x800000008000L & l) != 0x0L)
                     { jjAddStates(92, 97); }
                  break;
               case 251:
                  if ((0x1000000010000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 252;
                  break;
               case 252:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 253;
                  break;
               case 253:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 254;
                  break;
               case 254:
                  if ((0x200000002000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 255;
                  break;
               case 255:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 256;
                  break;
               case 256:
                  if ((0x400000004000000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 257;
                  break;
               case 257:
                  if ((0x2000000020L & l) != 0x0L && kind > 22)
                     kind = 22;
                  break;
               case 258:
                  if ((0x4000000040L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 259;
                  break;
               case 259:
                  if ((0x4000000040L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 260;
                  break;
               case 260:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 261;
                  break;
               case 261:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 262;
                  break;
               case 262:
                  if ((0x10000000100000L & l) != 0x0L && kind > 74)
                     kind = 74;
                  break;
               case 263:
                  if ((0x400000004000L & l) != 0x0L && kind > 75)
                     kind = 75;
                  break;
               case 264:
                  if ((0x4000000040000L & l) != 0x0L && kind > 76)
                     kind = 76;
                  break;
               case 265:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 266;
                  break;
               case 266:
                  if ((0x1000000010L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 267;
                  break;
               case 267:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 268;
                  break;
               case 268:
                  if ((0x4000000040000L & l) != 0x0L && kind > 77)
                     kind = 77;
                  break;
               case 269:
                  if ((0x20000000200000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 270;
                  break;
               case 270:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 271;
                  break;
               case 271:
                  if ((0x4000000040L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 272;
                  break;
               case 272:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 273;
                  break;
               case 273:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 274;
                  break;
               case 274:
                  if ((0x2000000020L & l) != 0x0L && kind > 78)
                     kind = 78;
                  break;
               case 275:
                  if ((0x4000000040000L & l) != 0x0L)
                     { jjAddStates(86, 91); }
                  break;
               case 276:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 277;
                  break;
               case 277:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 278;
                  break;
               case 278:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 279;
                  break;
               case 279:
                  if ((0x200000002000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 280;
                  break;
               case 280:
                  if ((0x2000000020L & l) != 0x0L && kind > 23)
                     kind = 23;
                  break;
               case 281:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 282;
                  break;
               case 282:
                  if ((0x40000000400000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 283;
                  break;
               case 283:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 284;
                  break;
               case 284:
                  if ((0x80000000800L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 285;
                  break;
               case 285:
                  if ((0x2000000020L & l) != 0x0L && kind > 24)
                     kind = 24;
                  break;
               case 286:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 287;
                  break;
               case 287:
                  if ((0x1000000010000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 288;
                  break;
               case 288:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 289;
                  break;
               case 289:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 290;
                  break;
               case 290:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 291;
                  break;
               case 291:
                  if ((0x2000000020L & l) != 0x0L && kind > 83)
                     kind = 83;
                  break;
               case 292:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 293;
                  break;
               case 293:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 294;
                  break;
               case 294:
                  if ((0x2000000020L & l) != 0x0L && kind > 84)
                     kind = 84;
                  break;
               case 295:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 296;
                  break;
               case 296:
                  if ((0x80000000800000L & l) != 0x0L && kind > 85)
                     kind = 85;
                  break;
               case 297:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 298;
                  break;
               case 298:
                  if ((0x8000000080L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 299;
                  break;
               case 299:
                  if ((0x10000000100L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 300;
                  break;
               case 300:
                  if ((0x10000000100000L & l) != 0x0L && kind > 86)
                     kind = 86;
                  break;
               case 301:
                  if ((0x8000000080000L & l) != 0x0L)
                     { jjAddStates(79, 85); }
                  break;
               case 302:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 303;
                  break;
               case 303:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 304;
                  break;
               case 304:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 305;
                  break;
               case 305:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 306;
                  break;
               case 306:
                  if ((0x10000000100000L & l) != 0x0L && kind > 25)
                     kind = 25;
                  break;
               case 307:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 308;
                  break;
               case 308:
                  if ((0x10000000100000L & l) != 0x0L && kind > 26)
                     kind = 26;
                  break;
               case 309:
                  if ((0x10000000100L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 310;
                  break;
               case 310:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 311;
                  break;
               case 311:
                  if ((0x80000000800000L & l) != 0x0L && kind > 27)
                     kind = 27;
                  break;
               case 312:
                  if ((0x200000002000000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 313;
                  break;
               case 313:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 314;
                  break;
               case 314:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 315;
                  break;
               case 315:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 316;
                  break;
               case 316:
                  if ((0x200000002000L & l) != 0x0L && kind > 28)
                     kind = 28;
                  break;
               case 317:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 318;
                  break;
               case 318:
                  if ((0x200000002000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 319;
                  break;
               case 319:
                  if ((0x1000000010000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 320;
                  break;
               case 320:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 321;
                  break;
               case 321:
                  if ((0x2000000020L & l) != 0x0L && kind > 87)
                     kind = 87;
                  break;
               case 322:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 323;
                  break;
               case 323:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 324;
                  break;
               case 324:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 325;
                  break;
               case 325:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 326;
                  break;
               case 326:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 327;
                  break;
               case 327:
                  if ((0x8000000080L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 328;
                  break;
               case 328:
                  if ((0x8000000080000L & l) != 0x0L && kind > 88)
                     kind = 88;
                  break;
               case 329:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 330;
                  break;
               case 330:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 331;
                  break;
               case 331:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 332;
                  break;
               case 332:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 333;
                  break;
               case 333:
                  if ((0x1000000010L & l) != 0x0L && kind > 105)
                     kind = 105;
                  break;
               case 334:
                  if ((0x10000000100000L & l) != 0x0L)
                     { jjAddStates(70, 78); }
                  break;
               case 335:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 336;
                  break;
               case 336:
                  if ((0x20000000200000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 337;
                  break;
               case 337:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 338;
                  break;
               case 338:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 339;
                  break;
               case 339:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 340;
                  break;
               case 340:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 341;
                  break;
               case 341:
                  if ((0x2000000020L & l) != 0x0L && kind > 29)
                     kind = 29;
                  break;
               case 342:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 343;
                  break;
               case 343:
                  if ((0x200000002000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 344;
                  break;
               case 344:
                  if ((0x1000000010000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 345;
                  break;
               case 345:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 346;
                  break;
               case 346:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 347;
                  break;
               case 347:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 348;
                  break;
               case 348:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 349;
                  break;
               case 349:
                  if ((0x200000002000000L & l) != 0x0L && kind > 89)
                     kind = 89;
                  break;
               case 350:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 351;
                  break;
               case 351:
                  if ((0x400000004L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 352;
                  break;
               case 352:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 353;
                  break;
               case 353:
                  if ((0x2000000020L & l) != 0x0L && kind > 90)
                     kind = 90;
                  break;
               case 354:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 355;
                  break;
               case 355:
                  if ((0x400000004L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 356;
                  break;
               case 356:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 357;
                  break;
               case 357:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 358;
                  break;
               case 358:
                  if ((0x8000000080000L & l) != 0x0L && kind > 91)
                     kind = 91;
                  break;
               case 359:
                  if ((0x10000000100L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 360;
                  break;
               case 360:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 361;
                  break;
               case 361:
                  if ((0x400000004000L & l) != 0x0L && kind > 92)
                     kind = 92;
                  break;
               case 362:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 363;
                  break;
               case 363:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 364;
                  break;
               case 364:
                  if ((0x8000000080000L & l) != 0x0L && kind > 93)
                     kind = 93;
                  break;
               case 365:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 366;
                  break;
               case 366:
                  if ((0x200000002000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 367;
                  break;
               case 367:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 368;
                  break;
               case 368:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 369;
                  break;
               case 369:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 370;
                  break;
               case 370:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 371;
                  break;
               case 371:
                  if ((0x200000002000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 372;
                  break;
               case 372:
                  if ((0x1000000010000L & l) != 0x0L && kind > 94)
                     kind = 94;
                  break;
               case 373:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 374;
                  break;
               case 374:
                  if ((0x1000000010000L & l) != 0x0L && kind > 95)
                     kind = 95;
                  break;
               case 375:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 376;
                  break;
               case 376:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 377;
                  break;
               case 377:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 378;
                  break;
               case 378:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 379;
                  break;
               case 379:
                  if ((0x8000000080000L & l) != 0x0L && kind > 96)
                     kind = 96;
                  break;
               case 380:
                  if ((0x20000000200000L & l) != 0x0L)
                     { jjAddStates(65, 69); }
                  break;
               case 381:
                  if ((0x1000000010000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 382;
                  break;
               case 382:
                  if ((0x1000000010L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 383;
                  break;
               case 383:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 384;
                  break;
               case 384:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 385;
                  break;
               case 385:
                  if ((0x2000000020L & l) != 0x0L && kind > 30)
                     kind = 30;
                  break;
               case 386:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 387;
                  break;
               case 387:
                  if ((0x2000000020L & l) != 0x0L && kind > 31)
                     kind = 31;
                  break;
               case 388:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 389;
                  break;
               case 389:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 390;
                  break;
               case 390:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 391;
                  break;
               case 391:
                  if ((0x400000004000L & l) != 0x0L && kind > 97)
                     kind = 97;
                  break;
               case 392:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 393;
                  break;
               case 393:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 394;
                  break;
               case 394:
                  if ((0x4000000040000L & l) != 0x0L && kind > 98)
                     kind = 98;
                  break;
               case 395:
                  if ((0x8000000080000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 396;
                  break;
               case 396:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 397;
                  break;
               case 397:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 398;
                  break;
               case 398:
                  if ((0x8000000080L & l) != 0x0L && kind > 99)
                     kind = 99;
                  break;
               case 399:
                  if ((0x80000000800000L & l) != 0x0L)
                     { jjAddStates(60, 64); }
                  break;
               case 400:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 401;
                  break;
               case 401:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 402;
                  break;
               case 402:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 403;
                  break;
               case 403:
                  if ((0x10000000100L & l) != 0x0L && kind > 32)
                     kind = 32;
                  break;
               case 404:
                  if ((0x10000000100L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 405;
                  break;
               case 405:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 406;
                  break;
               case 406:
                  if ((0x400000004000L & l) != 0x0L && kind > 102)
                     kind = 102;
                  break;
               case 407:
                  if ((0x10000000100L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 408;
                  break;
               case 408:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 409;
                  break;
               case 409:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 410;
                  break;
               case 410:
                  if ((0x2000000020L & l) != 0x0L && kind > 103)
                     kind = 103;
                  break;
               case 411:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 412;
                  break;
               case 412:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 413;
                  break;
               case 413:
                  if ((0x10000000100L & l) != 0x0L && kind > 104)
                     kind = 104;
                  break;
               case 414:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 415;
                  break;
               case 415:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 416;
                  break;
               case 416:
                  if ((0x80000000800L & l) != 0x0L && kind > 109)
                     kind = 109;
                  break;
               case 417:
                  if ((0x4000000040L & l) != 0x0L)
                     { jjAddStates(55, 59); }
                  break;
               case 418:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 419;
                  break;
               case 419:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 420;
                  break;
               case 420:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 421;
                  break;
               case 421:
                  if ((0x100000001000L & l) != 0x0L && kind > 51)
                     kind = 51;
                  break;
               case 422:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 423;
                  break;
               case 423:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 424;
                  break;
               case 424:
                  if ((0x200000002000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 425;
                  break;
               case 425:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 426;
                  break;
               case 426:
                  if ((0x10000000100000L & l) != 0x0L && kind > 52)
                     kind = 52;
                  break;
               case 427:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 428;
                  break;
               case 428:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 429;
                  break;
               case 429:
                  if ((0x200000002000L & l) != 0x0L && kind > 53)
                     kind = 53;
                  break;
               case 430:
                  if ((0x20000000200000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 431;
                  break;
               case 431:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 432;
                  break;
               case 432:
                  if ((0x100000001000L & l) != 0x0L && kind > 54)
                     kind = 54;
                  break;
               case 433:
                  if ((0x20000000200000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 434;
                  break;
               case 434:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 435;
                  break;
               case 435:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 436;
                  break;
               case 436:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 437;
                  break;
               case 437:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 438;
                  break;
               case 438:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 439;
                  break;
               case 439:
                  if ((0x400000004000L & l) != 0x0L && kind > 55)
                     kind = 55;
                  break;
               case 440:
                  if ((0x10000000100L & l) != 0x0L)
                     { jjAddStates(53, 54); }
                  break;
               case 441:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 442;
                  break;
               case 442:
                  if ((0x40000000400000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 443;
                  break;
               case 443:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 444;
                  break;
               case 444:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 445;
                  break;
               case 445:
                  if ((0x8000000080L & l) != 0x0L && kind > 58)
                     kind = 58;
                  break;
               case 446:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 447;
                  break;
               case 447:
                  if ((0x20000000200000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 448;
                  break;
               case 448:
                  if ((0x4000000040000L & l) != 0x0L && kind > 107)
                     kind = 107;
                  break;
               case 449:
                  if ((0x100000001000L & l) != 0x0L)
                     { jjAddStates(49, 52); }
                  break;
               case 450:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 451;
                  break;
               case 451:
                  if ((0x4000000040L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 452;
                  break;
               case 452:
                  if ((0x10000000100000L & l) != 0x0L && kind > 68)
                     kind = 68;
                  break;
               case 453:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 454;
                  break;
               case 454:
                  if ((0x80000000800L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 455;
                  break;
               case 455:
                  if ((0x2000000020L & l) != 0x0L && kind > 69)
                     kind = 69;
                  break;
               case 456:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 457;
                  break;
               case 457:
                  if ((0x200000002000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 458;
                  break;
               case 458:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 459;
                  break;
               case 459:
                  if ((0x10000000100000L & l) != 0x0L && kind > 70)
                     kind = 70;
                  break;
               case 460:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 461;
                  break;
               case 461:
                  if ((0x40000000400000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 462;
                  break;
               case 462:
                  if ((0x2000000020L & l) != 0x0L && kind > 71)
                     kind = 71;
                  break;
               case 463:
                  if ((0x200000002000L & l) != 0x0L)
                     { jjAddStates(46, 48); }
                  break;
               case 464:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 465;
                  break;
               case 465:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 466;
                  break;
               case 466:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 467;
                  break;
               case 467:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 468;
                  break;
               case 468:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 469;
                  break;
               case 469:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 470;
                  break;
               case 470:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 471;
                  break;
               case 471:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 472;
                  break;
               case 472:
                  if ((0x400000004000000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 473;
                  break;
               case 473:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 474;
                  break;
               case 474:
                  if ((0x1000000010L & l) != 0x0L && kind > 72)
                     kind = 72;
                  break;
               case 475:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 476;
                  break;
               case 476:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 477;
                  break;
               case 477:
                  if ((0x20000000200000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 478;
                  break;
               case 478:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 479;
                  break;
               case 479:
                  if ((0x2000000020L & l) != 0x0L && kind > 106)
                     kind = 106;
                  break;
               case 480:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 481;
                  break;
               case 481:
                  if ((0x400000004000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 482;
                  break;
               case 482:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 483;
                  break;
               case 483:
                  if ((0x10000000100L & l) != 0x0L && kind > 110)
                     kind = 110;
                  break;
               case 484:
                  if ((0x400000004000L & l) != 0x0L)
                     { jjAddStates(43, 45); }
                  break;
               case 485:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 486;
                  break;
               case 486:
                  if ((0x10000000100000L & l) != 0x0L && kind > 73)
                     kind = 73;
                  break;
               case 487:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 488;
                  break;
               case 488:
                  if ((0x400000004000L & l) != 0x0L && kind > 114)
                     kind = 114;
                  break;
               case 489:
                  if ((0x20000000200000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 490;
                  break;
               case 490:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 491;
                  break;
               case 491:
                  if ((0x100000001000L & l) != 0x0L && kind > 115)
                     kind = 115;
                  break;
               case 492:
                  if ((0x1000000010000L & l) != 0x0L)
                     { jjAddStates(40, 42); }
                  break;
               case 493:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 494;
                  break;
               case 494:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 495;
                  break;
               case 495:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 496;
                  break;
               case 496:
                  if ((0x800000008L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 497;
                  break;
               case 497:
                  if ((0x200000002000000L & l) != 0x0L && kind > 79)
                     kind = 79;
                  break;
               case 498:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 499;
                  break;
               case 499:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 500;
                  break;
               case 500:
                  if ((0x80000000800000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 501;
                  break;
               case 501:
                  if ((0x10000000100L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 502;
                  break;
               case 502:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 503;
                  break;
               case 503:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 504;
                  break;
               case 504:
                  if ((0x2000000020L & l) != 0x0L && kind > 80)
                     kind = 80;
                  break;
               case 505:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 506;
                  break;
               case 506:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 507;
                  break;
               case 507:
                  if ((0x4000000040L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 508;
                  break;
               case 508:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 509;
                  break;
               case 509:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 510;
                  break;
               case 510:
                  if ((0x2000000020L & l) != 0x0L && kind > 81)
                     kind = 81;
                  break;
               case 511:
                  if ((0x2000000020000L & l) != 0x0L)
                     { jjAddStates(38, 39); }
                  break;
               case 512:
                  if ((0x20000000200000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 513;
                  break;
               case 513:
                  if ((0x800000008000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 514;
                  break;
               case 514:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 515;
                  break;
               case 515:
                  if ((0x200000002L & l) != 0x0L && kind > 82)
                     kind = 82;
                  break;
               case 516:
                  if ((0x20000000200000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 517;
                  break;
               case 517:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 518;
                  break;
               case 518:
                  if ((0x4000000040000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 519;
                  break;
               case 519:
                  if ((0x10000000100000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 520;
                  break;
               case 520:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 521;
                  break;
               case 521:
                  if ((0x4000000040000L & l) != 0x0L && kind > 111)
                     kind = 111;
                  break;
               case 522:
                  if ((0x40000000400000L & l) != 0x0L)
                     { jjAddStates(36, 37); }
                  break;
               case 523:
                  if ((0x200000002L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 524;
                  break;
               case 524:
                  if ((0x100000001000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 525;
                  break;
               case 525:
                  if ((0x20000000200000L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 526;
                  break;
               case 526:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 527;
                  break;
               case 527:
                  if ((0x8000000080000L & l) != 0x0L && kind > 100)
                     kind = 100;
                  break;
               case 528:
                  if ((0x20000000200L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 529;
                  break;
               case 529:
                  if ((0x2000000020L & l) != 0x0L)
                     jjstateSet[jjnewStateCnt++] = 530;
                  break;
               case 530:
                  if ((0x80000000800000L & l) != 0x0L && kind > 101)
                     kind = 101;
                  break;
               case 533:
                  if ((0x2000000020L & l) == 0x0L)
                     break;
                  if (kind > 181)
                     kind = 181;
                  { jjCheckNAdd(534); }
                  break;
               case 534:
                  if ((0x7fffffe87fffffeL & l) == 0x0L)
                     break;
                  if (kind > 181)
                     kind = 181;
                  { jjCheckNAdd(534); }
                  break;
               case 535:
                  if ((0x7ffffde87ffffdeL & l) == 0x0L)
                     break;
                  if (kind > 181)
                     kind = 181;
                  { jjCheckNAdd(536); }
                  break;
               case 536:
                  if ((0x7fffffe87fffffeL & l) == 0x0L)
                     break;
                  if (kind > 181)
                     kind = 181;
                  { jjCheckNAdd(536); }
                  break;
               case 540:
                  if ((0x2000000020L & l) != 0x0L)
                     { jjAddStates(142, 143); }
                  break;
               case 544:
                  if ((0x2000000020L & l) != 0x0L)
                     { jjAddStates(144, 145); }
                  break;
               case 549:
                  if ((0x100000001000000L & l) != 0x0L)
                     { jjCheckNAdd(550); }
                  break;
               case 550:
                  if ((0x7e0000007eL & l) != 0x0L)
                     { jjCheckNAddTwoStates(550, 551); }
                  break;
               case 553:
                  if ((0x100000001000000L & l) != 0x0L)
                     { jjCheckNAdd(554); }
                  break;
               case 554:
                  if ((0x7e0000007eL & l) != 0x0L)
                     { jjCheckNAddTwoStates(554, 555); }
                  break;
               case 555:
                  if ((0x1002000010020L & l) != 0x0L)
                     { jjAddStates(146, 147); }
                  break;
               case 558:
                  if ((0x100000001000000L & l) != 0x0L)
                     { jjCheckNAdd(559); }
                  break;
               case 559:
                  if ((0x7e0000007eL & l) != 0x0L)
                     { jjCheckNAddTwoStates(559, 560); }
                  break;
               case 560:
                  if ((0x1002000010020L & l) != 0x0L)
                     { jjAddStates(148, 149); }
                  break;
               case 563:
                  if ((0x100000001000000L & l) != 0x0L)
                     { jjCheckNAdd(564); }
                  break;
               case 564:
                  if ((0x7e0000007eL & l) == 0x0L)
                     break;
                  if (kind > 186)
                     kind = 186;
                  { jjCheckNAdd(564); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 565:
               case 41:
               case 40:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(0, 3); }
                  break;
               case 566:
               case 32:
               case 31:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(4, 7); }
                  break;
               case 567:
               case 48:
               case 47:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(8, 11); }
                  break;
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 1)
                     kind = 1;
                  break;
               case 2:
                  if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 3)
                     kind = 3;
                  jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 59:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                     { jjAddStates(23, 24); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      i = jjnewStateCnt;
      jjnewStateCnt = startsAt;
      startsAt = 565 - jjnewStateCnt;
      if (i == startsAt)
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_1(){
   switch(curChar)
   {
      case '*':
         return jjMoveStringLiteralDfa1_1(0x40L);
      case '/':
         return jjMoveStringLiteralDfa1_1(0x20L);
      default :
         return 1;
   }
}
private int jjMoveStringLiteralDfa1_1(long active0){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 1;
   }
   switch(curChar)
   {
      case '*':
         if ((active0 & 0x20L) != 0x0L)
            return jjStopAtPos(1, 5);
         break;
      case '/':
         if ((active0 & 0x40L) != 0x0L)
            return jjStopAtPos(1, 6);
         break;
      default :
         return 2;
   }
   return 2;
}

/** Token literal values. */
public static final String[] jjstrLiteralImages = {
"", null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, "\55\76", "\52", "\100", "\140", "\134", 
"\72", "\54", "\174\174", "\72\72", "\55", "\44", "\56", "\75\75", "\75", "\76\75", 
"\76", "\43", "\173", "\133", "\74\75", "\50", "\74", null, "\45", "\53", "\77", 
"\42", "\47", "\175", "\135", "\51", "\73", "\57", null, null, null, null, null, null, 
null, null, };
protected Token jjFillToken()
{
   final Token t;
   final String curTokenImage;
   final int beginLine;
   final int endLine;
   final int beginColumn;
   final int endColumn;
   String im = jjstrLiteralImages[jjmatchedKind];
   curTokenImage = im == null ? input_stream.getImage() : im;
   beginLine = input_stream.getBeginLine();
   beginColumn = input_stream.getBeginColumn();
   endLine = input_stream.getEndLine();
   endColumn = input_stream.getEndColumn();
   t = Token.newToken(jjmatchedKind);
   t.kind = jjmatchedKind;
   t.image = curTokenImage;

   t.beginLine = beginLine;
   t.endLine = endLine;
   t.beginColumn = beginColumn;
   t.endColumn = endColumn;

   return t;
}
static final int[] jjnextStates = {
   39, 41, 43, 44, 30, 32, 34, 35, 46, 48, 50, 51, 532, 533, 535, 537, 
   538, 543, 544, 547, 549, 558, 563, 59, 60, 532, 533, 535, 550, 551, 559, 560, 
   58, 61, 63, 64, 523, 528, 512, 516, 493, 498, 505, 485, 487, 489, 464, 475, 
   480, 450, 453, 456, 460, 441, 446, 418, 422, 427, 430, 433, 400, 404, 407, 411, 
   414, 381, 386, 388, 392, 395, 335, 342, 350, 354, 359, 362, 365, 373, 375, 302, 
   307, 309, 312, 317, 322, 329, 276, 281, 286, 292, 295, 297, 251, 258, 263, 264, 
   265, 269, 218, 223, 224, 228, 229, 233, 237, 244, 247, 248, 204, 208, 213, 182, 
   187, 193, 196, 198, 111, 116, 119, 126, 131, 134, 137, 144, 152, 161, 172, 179, 
   92, 96, 101, 104, 66, 70, 75, 77, 79, 83, 87, 88, 55, 56, 541, 542, 
   545, 546, 556, 557, 561, 562, 
};
private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec0[i2] & l2) != 0L);
      case 24:
         return ((jjbitVec1[i2] & l2) != 0L);
      case 32:
         return ((jjbitVec2[i2] & l2) != 0L);
      case 48:
         return ((jjbitVec3[i2] & l2) != 0L);
      case 254:
         return ((jjbitVec4[i2] & l2) != 0L);
      default :
         return false;
   }
}
private static final boolean jjCanMove_1(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec7[i2] & l2) != 0L);
      default :
         if ((jjbitVec5[i1] & l1) != 0L)
            return true;
         return false;
   }
}

int curLexState = 0;
int defaultLexState = 0;
int jjnewStateCnt;
int jjround;
int jjmatchedPos;
int jjmatchedKind;

/** Get the next Token. */
public Token getNextToken() 
{
  Token matchedToken;
  int curPos = 0;

  EOFLoop:
  for (;;)
  {
   try
   {
      curChar = input_stream.beginToken();
   }
   catch(final Exception e)
   {
      jjmatchedKind = 0;
      jjmatchedPos = -1;
      matchedToken = jjFillToken();
      CommonTokenAction(matchedToken);
      return matchedToken;
   }
   image = jjimage;
   image.setLength(0);
   jjimageLen = 0;

   switch(curLexState)
   {
     case 0:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_0();
       break;
     case 1:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_1();
       if (jjmatchedPos == 0 && jjmatchedKind > 7)
       {
          jjmatchedKind = 7;
       }
       break;
   }
     if (jjmatchedKind != 0x7fffffff)
     {
        if (jjmatchedPos + 1 < curPos)
           input_stream.backup(curPos - jjmatchedPos - 1);
        if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           matchedToken = jjFillToken();
       if (jjnewLexState[jjmatchedKind] != -1)
         curLexState = jjnewLexState[jjmatchedKind];
           CommonTokenAction(matchedToken);
           return matchedToken;
        }
        else
        {
           SkipLexicalActions(null);
         if (jjnewLexState[jjmatchedKind] != -1)
           curLexState = jjnewLexState[jjmatchedKind];
           continue EOFLoop;
        }
     }
     int error_line = input_stream.getEndLine();
     int error_column = input_stream.getEndColumn();
     String error_after = null;
     boolean EOFSeen = false;
     try {
       input_stream.readChar();
       input_stream.backup(1);
     }
     catch (final java.io.IOException e1) {
        EOFSeen = true;
        error_after = curPos <= 1 ? "" : input_stream.getImage();
        if (curChar == '\n' || curChar == '\r') {
           error_line++;
           error_column = 0;
        }
        else
           error_column++;
     }
     if (!EOFSeen) {
        input_stream.backup(1);
        error_after = curPos <= 1 ? "" : input_stream.getImage();
     }
     throw new TokenMgrException(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrException.LEXICAL_ERROR);
  }
}

void SkipLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 1 :
         image.append(input_stream.getSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
      append(image);
         break;
      case 2 :
         image.append(input_stream.getSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        int startIndex = image.indexOf("\'");
        int endIndex = image.lastIndexOf("\'");
        if (startIndex < 0 || endIndex < 0 || endIndex <= startIndex) {
            // skip invalid content
        } else if (image.charAt(1) == 'd') { // date
            builder.append("date")
                .append(image.substring(startIndex, endIndex + 1));
        } else {
            char ch = image.charAt(2);
            if (ch == 's') { // timestamp
                int scale = image.lastIndexOf(".");
                if (scale > 0) {
                    scale = endIndex - scale - 1;
                } else {
                    scale = 0;
                }

                if (scale > 0) {
                    // or downgrade to DateTime32 for better compatibility?
                    builder.append("toDateTime64(")
                        .append(image.substring(startIndex, endIndex + 1)).append(',').append(scale).append(')');
                } else {
                    builder.append("timestamp")
                        .append(image.substring(startIndex, endIndex + 1));
                }
            } else if (ch == 't') { // temp table, either session-level temporary table or external table
                String tableName = ClickHouseSqlUtils.unescape(image.substring(startIndex, endIndex + 1));
                builder.append('`').append(tableName).append('`');
                tempTables.add(tableName);
            } else {
                builder.append("timestamp'1970-01-01 ")
                    .append(image.substring(startIndex + 1, endIndex + 1));
            }
        }
         break;
      case 3 :
         image.append(input_stream.getSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                              append(image);
         break;
      case 4 :
         image.append(input_stream.getSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             commentNestingDepth = 1; append(image);
         break;
      case 5 :
         image.append(input_stream.getSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
           commentNestingDepth += 1; append(image);
         break;
      case 6 :
         image.append(input_stream.getSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             SwitchTo(--commentNestingDepth == 0 ? DEFAULT : MULTI_LINE_COMMENT); append(image);
         break;
      case 7 :
         image.append(input_stream.getSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                append(image);
         break;
      default :
         break;
   }
}
void MoreLexicalActions()
{
   jjimageLen += (lengthOfMatch = jjmatchedPos + 1);
   switch(jjmatchedKind)
   {
      default :
         break;
   }
}
void TokenLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      default :
         break;
   }
}
private void jjCheckNAdd(int state)
{
   if (jjrounds[state] != jjround)
   {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
   }
}
private void jjAddStates(int start, int end)
{
   do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
   } while (start++ != end);
}
private void jjCheckNAddTwoStates(int state1, int state2)
{
   jjCheckNAdd(state1);
   jjCheckNAdd(state2);
}

private void jjCheckNAddStates(int start, int end)
{
   do {
      jjCheckNAdd(jjnextStates[start]);
   } while (start++ != end);
}

    /** Constructor. */
    public ClickHouseSqlParserTokenManager(SimpleCharStream stream){
    input_stream = stream;
  }

  /** Constructor. */
  public ClickHouseSqlParserTokenManager (SimpleCharStream stream, int lexState){
    ReInit(stream);
    SwitchTo(lexState);
  }

  /** Reinitialise parser. */
  
  public void ReInit(SimpleCharStream stream)
  {


    jjmatchedPos =
    jjnewStateCnt =
    0;
    curLexState = defaultLexState;
    input_stream = stream;
    ReInitRounds();
  }

  private void ReInitRounds()
  {
    int i;
    jjround = 0x80000001;
    for (i = 565; i-- > 0;)
      jjrounds[i] = 0x80000000;
  }

  /** Reinitialise parser. */
  public void ReInit(SimpleCharStream stream, int lexState)
  {
    ReInit(stream);
    SwitchTo(lexState);
  }

  /** Switch to specified lex state. */
  public void SwitchTo(int lexState)
  {
    if (lexState >= 2 || lexState < 0)
      throw new TokenMgrException("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrException.INVALID_LEXICAL_STATE);
    else
      curLexState = lexState;
  }


/** Lexer state names. */
public static final String[] lexStateNames = {
   "DEFAULT",
   "MULTI_LINE_COMMENT",
};

/** Lex State array. */
public static final int[] jjnewLexState = {
   -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
};
static final long[] jjtoToken = {
   0xffffffffffffff01L, 0xfffffffffffffL, 0x7f7fffffffc0000L, 
};
static final long[] jjtoSkip = {
   0xfeL, 0x0L, 0x0L, 
};
static final long[] jjtoSpecial = {
   0x0L, 0x0L, 0x0L, 
};
static final long[] jjtoMore = {
   0x0L, 0x0L, 0x0L, 
};
    protected SimpleCharStream  input_stream;

    private final int[] jjrounds = new int[565];
    private final int[] jjstateSet = new int[2 * 565];
    private final StringBuilder jjimage = new StringBuilder();
    private StringBuilder image = jjimage;
    private int jjimageLen;
    private int lengthOfMatch;
    protected int curChar;
}
