package com.cv.media.lib.api.dns;

import android.content.Context;

import me.ew.rdns.lib.Rdns;
import me.ew.rdns.lib.RdnsConfig;
import me.ew.rdns.lib.rdns.RdnsEvent;
import me.ew.rdns.lib.rdns.RdnsListener;

/**
 * Created by zhangyaoa on 2022/2/19.
 */
public class RdnsController {

    private static RdnsController sInstance;

    public static RdnsController getInstance() {
        if (sInstance == null) {
            synchronized (RdnsController.class) {
                if (sInstance == null)
                    sInstance = new RdnsController();
            }
        }
        return sInstance;
    }

    private RdnsController(){
    }

    public void init(Context context, String rdnsPath, String rdnsServers) {
        RdnsConfig rdnsConfig = new RdnsConfig()
                .setLocalRdmPath(rdnsPath)
                .setMetricOn(false)
                .setSystemDnsFirst(false)
                .setProvider(rdnsServers)
                .setRdnsListener(new RdnsListener() {
                    @Override
                    public void onEvent(RdnsEvent rdnsEvent) {
                        //ignore
                    }

                    @Override
                    public void onRdmUpdate() {
                        //从配置端拿到了新的rdm集合,进行RPL记录的使用
                    }
                });
        Rdns.init(context, rdnsConfig);
    }
}
