package com.cv.media.lib.api.okhttp;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public abstract class BaseCryptoInterceptor implements Interceptor {

    @Override
    public final Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request newRequest;
        boolean isEncrypted;

        if ((isEncrypted = onEncrypt(request))) {
            newRequest = getCipherRequest(request);
        } else {
            newRequest = request;
        }

        Response response = chain.proceed(newRequest);

        return isEncryptedCode(response) && isEncrypted ? handleResponse(getDecryptResponse(response)) : handleResponse(response);
    }

    /**
     * 是否是加密的httpcode（过滤需要相应的code范围）
     *
     * @param response 需要处理的response
     * @return 返回是否需要处理
     */
    public boolean isEncryptedCode(Response response) {
        return response.isSuccessful() || response.code() == 555;
    }

    /**
     * 当前的Request是否需要采用加密
     *
     * @param request 当前的Request
     */
    protected abstract boolean onEncrypt(Request request);

    /**
     * 处理Response 切口函数
     */
    public Response handleResponse(Response response) {
        return response;
    }

    /**
     * 获取解密后的Response
     */
    protected abstract Response getDecryptResponse(Response response);

    /**
     * 获取加密后的Request
     */
    protected abstract Request getCipherRequest(Request request);
}
