package com.cv.media.lib.geoip.nekudo;

import android.content.Context;

import com.cv.media.lib.common_utils.utils.StringUtils;

import io.reactivex.Observable;
import io.reactivex.functions.Function;

import com.cv.media.lib.geoip.provider.GeoIPProvider;
import com.cv.media.lib.geoip.factory.LenientGsonConverterFactory;
import com.cv.media.lib.geoip.model.GeoIP;

import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

/**
 * Geo IP api
 * from http://geoip.nekudo.com/
 */
public class NekudoGeoIPProvider implements GeoIPProvider {
    //This API endpoint is deprecated and has now been shut down.
    private final static String HOST = "http://geoip.nekudo.com/api/";
    private Context mContext;
    private final String defaultLangCode = "en";
    //empty or "full"
    private final String defaultType = "";

    private OkHttpClient.Builder mBuilder;
    private Retrofit.Builder mRetrofitBuilder;

    public NekudoGeoIPProvider(Context context) {
        this.mContext = context;
    }

    private NekudoGeoIPWebApi getApi() {
        if (null == mBuilder) {
            mBuilder = new OkHttpClient.Builder();
            mBuilder.followRedirects(true);
            mBuilder.followSslRedirects(true);
        }
        if (null == mRetrofitBuilder) {
            mRetrofitBuilder = new Retrofit.Builder();
            mRetrofitBuilder.addConverterFactory(LenientGsonConverterFactory.create());
            mRetrofitBuilder.addCallAdapterFactory(RxJava2CallAdapterFactory.create());
        }
        return mRetrofitBuilder.baseUrl(HOST).client(mBuilder.build()).build().create(NekudoGeoIPWebApi.class);
    }

    public Observable<GeoIP> getGeoByIP(String ipAddress) {
        return convertResult(getApi().getGeoIP(StringUtils.trimToEmpty(ipAddress), defaultLangCode, defaultType));
    }

    private Observable<GeoIP> convertResult(Observable<GeoIPResult> observable) {
        return observable.map(new Function<GeoIPResult, GeoIP>() {
            @Override
            public GeoIP apply(GeoIPResult geoIPResult) {
                GeoIP geoIP = new GeoIP();
                geoIP.setIp(geoIPResult.ip);
                geoIP.setCountryCode(geoIPResult.country.code);
                geoIP.setCountryName(geoIPResult.country.name);
                geoIP.setCity(geoIPResult.city);
                geoIP.setRegionCode("");
                geoIP.setRegionName("");
                geoIP.setTimeZone(geoIPResult.location.time_zone);
                geoIP.setLatitude(geoIPResult.location.latitude);
                geoIP.setLongitude(geoIPResult.location.longitude);
                return geoIP;
            }
        });
    }

    public Observable<GeoIP> getGeoByCurIP() {
        return getGeoByIP("");
    }
}
