package com.cv.media.lib.plugin.packing

import com.cv.media.lib.plugin.Logger
import org.gradle.api.GradleException

import java.util.zip.ZipEntry
import java.util.zip.ZipFile

/**
 * IJM（爱加密）加固打包任务
 * 职责: 使用IJM服务进行APK加固
 * @author Damon
 */
class IjmApkPackingTask extends BaseApkPackingTask {
    IjmApkPackingTask() {
        setGroup("IJM加固打包")
    }

    @Override
    File makeProtectedApk(File apkOriginFile) {
        def args = [
                "itman@valorosoltd.com",
                "${apkOriginFile.path}",
                "${mOutputDir.path}",
                "null",
                "458"
        ]
        logs("加固 开始...")
        Logger.startCount()
        execute("java -jar ${toolsDir.path}${File.separator}encryptiontool-1.2.jar ${args.join(" ")}", "爱加密官方服务")
        Logger.endCount("加固任务")
        logs("加固 结束...")

        List<File> apks = mOutputDir.listFiles().findAll {
            it.name.contains("enc_unsigned.apk")
        }

        if (apks.size() != 1) {
            throw new GradleException("Apk加固异常: 找到${apks.size()}个匹配apk")
        }
        File protectApkFile = new File(mOutputDir, "${apkOriginFile.name.replace(".apk", "_protected.apk")}")
        logs("更改加固后apk:${apks[0].name}为: $protectApkFile.name")
        apks[0].renameTo(protectApkFile)
        if (!protectApkFile.exists()) throw new GradleException("Apk加固失败: 加固包不存在")

        logs("开始检查加固后apk: $protectApkFile.name")
        ZipFile zipFileOfPAF = new ZipFile(protectApkFile)
        Enumeration<?> entries = zipFileOfPAF.entries()
        boolean onlyOneDex = true
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry) entries.nextElement()
            if (entry.name.startsWith("classes") && entry.name.endsWith(".dex") && entry.name != "classes.dex") {
                onlyOneDex = false
                break
            }
        }

        if (!onlyOneDex) {
            throw new GradleException("Apk加固异常: 不止一个.dex")
        }

        logs("加固成功: $protectApkFile.name")
        return protectApkFile
    }

    @Override
    void logs(String content) {
        println("${IjmApkPackingTask.simpleName}--> ${content}")
    }
}

